/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.QueueStatsId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.queue.QueueStats;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.queue.QueueStatsService;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class QueueStatsController
extends BaseController {
    private final QueueStatsService queueStatsService;

    @ApiOperation(value="Get Queue Stats entities (getTenantQueueStats)", notes="Returns a page of queue stats objects that are designed to collect queue statistics for every service. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/queueStats"}, params={"pageSize", "page"})
    public PageData<QueueStats> getTenantQueueStats(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the queue name or service id.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.queueStatsService.findByTenantId(this.getTenantId(), pageLink);
    }

    @ApiOperation(value="Get Queue stats entity by id (getQueueStatsById)", notes="Fetch the Queue stats object based on the provided Queue stats id. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/queueStats/{queueStatsId}"})
    public QueueStats getQueueStatsById(@Parameter(description="A string value representing the queue stats id. For example, '687f294c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="queueStatsId") String queueStatsIdStr) throws ThingsboardException {
        this.checkParameter("queueStatsId", queueStatsIdStr);
        QueueStatsId queueStatsId = new QueueStatsId(UUID.fromString(queueStatsIdStr));
        return (QueueStats)this.checkNotNull((Object)this.queueStatsService.findQueueStatsById(this.getTenantId(), queueStatsId));
    }

    @ApiOperation(value="Get QueueStats By Ids (getQueueStatsByIds)", notes="Fetch the Queue stats objects based on the provided ids. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/queueStats"}, params={"queueStatsIds"})
    public List<QueueStats> getQueueStatsByIds(@Parameter(description="A list of queue stats ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="queueStatsIds") String[] strQueueStatsIds) throws ThingsboardException {
        this.checkArrayParameter("queueStatsIds", strQueueStatsIds);
        ArrayList<QueueStatsId> queueStatsIds = new ArrayList<QueueStatsId>();
        for (String queueStatsId : strQueueStatsIds) {
            queueStatsIds.add(new QueueStatsId(this.toUUID(queueStatsId)));
        }
        return this.queueStatsService.findQueueStatsByIds(this.getTenantId(), queueStatsIds);
    }

    @ConstructorProperties(value={"queueStatsService"})
    @Generated
    public QueueStatsController(QueueStatsService queueStatsService) {
        this.queueStatsService = queueStatsService;
    }
}

