/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.OAuth2ClientRegistrationTemplateId;
import org.thingsboard.server.common.data.oauth2.OAuth2ClientRegistrationTemplate;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/oauth2/config/template"})
public class OAuth2ConfigTemplateController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ConfigTemplateController.class);
    private static final String CLIENT_REGISTRATION_TEMPLATE_ID = "clientRegistrationTemplateId";
    private static final String OAUTH2_CLIENT_REGISTRATION_TEMPLATE_DEFINITION = "Client registration template is OAuth2 provider configuration template with default settings for registering new OAuth2 clients";

    @ApiOperation(value="Create or update OAuth2 client registration template (saveClientRegistrationTemplate)\n\nAvailable for users with 'SYS_ADMIN' authority.", notes="Client registration template is OAuth2 provider configuration template with default settings for registering new OAuth2 clients")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public OAuth2ClientRegistrationTemplate saveClientRegistrationTemplate(@RequestBody OAuth2ClientRegistrationTemplate clientRegistrationTemplate) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.OAUTH2_CONFIGURATION_TEMPLATE, Operation.WRITE);
        return this.oAuth2ConfigTemplateService.saveClientRegistrationTemplate(clientRegistrationTemplate);
    }

    @ApiOperation(value="Delete OAuth2 client registration template by id (deleteClientRegistrationTemplate)\n\nAvailable for users with 'SYS_ADMIN' authority.", notes="Client registration template is OAuth2 provider configuration template with default settings for registering new OAuth2 clients")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @RequestMapping(value={"/{clientRegistrationTemplateId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteClientRegistrationTemplate(@Parameter(description="String representation of client registration template id to delete", example="139b1f81-2f5d-11ec-9dbe-9b627e1a88f4") @PathVariable(value="clientRegistrationTemplateId") String strClientRegistrationTemplateId) throws ThingsboardException {
        this.checkParameter(CLIENT_REGISTRATION_TEMPLATE_ID, strClientRegistrationTemplateId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.OAUTH2_CONFIGURATION_TEMPLATE, Operation.DELETE);
        OAuth2ClientRegistrationTemplateId clientRegistrationTemplateId = new OAuth2ClientRegistrationTemplateId(this.toUUID(strClientRegistrationTemplateId));
        this.oAuth2ConfigTemplateService.deleteClientRegistrationTemplateById(clientRegistrationTemplateId);
    }

    @ApiOperation(value="Get the list of all OAuth2 client registration templates (getClientRegistrationTemplates)\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.", notes="Client registration template is OAuth2 provider configuration template with default settings for registering new OAuth2 clients")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<OAuth2ClientRegistrationTemplate> getClientRegistrationTemplates() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.OAUTH2_CONFIGURATION_TEMPLATE, Operation.READ);
        return this.oAuth2ConfigTemplateService.findAllClientRegistrationTemplates();
    }
}

