/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.notification.rule.NotificationRule;
import org.thingsboard.server.common.data.notification.rule.NotificationRuleInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/notification"})
public class NotificationRuleController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationRuleController.class);
    private final NotificationRuleService notificationRuleService;

    @ApiOperation(value="Save notification rule (saveNotificationRule)", notes="Creates or updates notification rule. \n\nMandatory properties are `name`, `templateId` (of a template with `notificationType` matching to rule's `triggerType`), `triggerType`, `triggerConfig` and `recipientConfig`. Additionally, you may specify rule `description` inside of `additionalConfig`.\n\nTrigger type of the rule cannot be changed. Available trigger types for tenant: `ENTITY_ACTION`, `ALARM`, `ALARM_COMMENT`, `ALARM_ASSIGNMENT`, `DEVICE_ACTIVITY`, `RULE_ENGINE_COMPONENT_LIFECYCLE_EVENT`.\nFor sysadmin, there are following trigger types available: `ENTITIES_LIMIT`, `API_USAGE_LIMIT`, `NEW_PLATFORM_VERSION`.\n\nHere is an example of notification rule to send notification when a device, asset or customer is created or deleted:\n```json\n{\n  \"name\": \"Entity action\",\n  \"templateId\": {\n    \"entityType\": \"NOTIFICATION_TEMPLATE\",\n    \"id\": \"32117320-d785-11ed-a06c-21dd57dd88ca\"\n  },\n  \"triggerType\": \"ENTITY_ACTION\",\n  \"triggerConfig\": {\n    \"entityTypes\": [\n      \"CUSTOMER\",\n      \"DEVICE\",\n      \"ASSET\"\n    ],\n    \"created\": true,\n    \"updated\": false,\n    \"deleted\": true,\n    \"triggerType\": \"ENTITY_ACTION\"\n  },\n  \"recipientsConfig\": {\n    \"targets\": [\n      \"320f2930-d785-11ed-a06c-21dd57dd88ca\"\n    ],\n    \"triggerType\": \"ENTITY_ACTION\"\n  },\n  \"additionalConfig\": {\n    \"description\": \"Send notification to tenant admins or customer users when a device, asset or customer is created\"\n  },\n  \"templateName\": \"Entity action notification\",\n  \"deliveryMethods\": [\n    \"WEB\"\n  ]\n}\n```\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/rule"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationRule saveNotificationRule(@RequestBody @Valid NotificationRule notificationRule, @AuthenticationPrincipal SecurityUser user) throws Exception {
        notificationRule.setTenantId(user.getTenantId());
        this.checkEntity((EntityId)((NotificationRuleId)notificationRule.getId()), (TenantEntity)notificationRule, Resource.NOTIFICATION);
        NotificationRuleTriggerType triggerType = notificationRule.getTriggerType();
        if (user.isTenantAdmin() && !triggerType.isTenantLevel() || user.isSystemAdmin() && triggerType.isTenantLevel()) {
            throw new IllegalArgumentException("Trigger type " + String.valueOf(triggerType) + " is not available");
        }
        return (NotificationRule)this.doSaveAndLog(EntityType.NOTIFICATION_RULE, (HasName)notificationRule, (arg_0, arg_1) -> ((NotificationRuleService)this.notificationRuleService).saveNotificationRule(arg_0, arg_1));
    }

    @ApiOperation(value="Get notification rule by id (getNotificationRuleById)", notes="Fetches notification rule info by rule's id.\nIn addition to regular notification rule fields, there are `templateName` and `deliveryMethods` in the response.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/rule/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationRuleInfo getNotificationRuleById(@PathVariable UUID id) throws ThingsboardException {
        NotificationRuleId notificationRuleId = new NotificationRuleId(id);
        return (NotificationRuleInfo)this.checkEntityId((EntityId)notificationRuleId, (arg_0, arg_1) -> ((NotificationRuleService)this.notificationRuleService).findNotificationRuleInfoById(arg_0, arg_1), Operation.READ);
    }

    @ApiOperation(value="Get notification rules (getNotificationRules)", notes="Returns the page of notification rules.\n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/rules"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PageData<NotificationRuleInfo> getNotificationRules(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on rule's name") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.NOTIFICATION, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.notificationRuleService.findNotificationRulesInfosByTenantId(user.getTenantId(), pageLink);
    }

    @ApiOperation(value="Delete notification rule (deleteNotificationRule)", notes="Deletes notification rule by id.\nCancels all related scheduled notification requests (e.g. due to escalation table)\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @DeleteMapping(value={"/rule/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public void deleteNotificationRule(@PathVariable UUID id, @AuthenticationPrincipal SecurityUser user) throws Exception {
        NotificationRuleId notificationRuleId = new NotificationRuleId(id);
        NotificationRule notificationRule = (NotificationRule)this.checkEntityId((EntityId)notificationRuleId, (arg_0, arg_1) -> ((NotificationRuleService)this.notificationRuleService).findNotificationRuleById(arg_0, arg_1), Operation.DELETE);
        this.doDeleteAndLog(EntityType.NOTIFICATION_RULE, (HasName)notificationRule, (arg_0, arg_1) -> ((NotificationRuleService)this.notificationRuleService).deleteNotificationRuleById(arg_0, arg_1));
    }

    @ConstructorProperties(value={"notificationRuleService"})
    @Generated
    public NotificationRuleController(NotificationRuleService notificationRuleService) {
        this.notificationRuleService = notificationRuleService;
    }
}

