/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.NotificationId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.notification.Notification;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestInfo;
import org.thingsboard.server.common.data.notification.NotificationRequestPreview;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.settings.UserNotificationSettings;
import org.thingsboard.server.common.data.notification.targets.MicrosoftTeamsNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.notification.targets.NotificationTarget;
import org.thingsboard.server.common.data.notification.targets.NotificationTargetType;
import org.thingsboard.server.common.data.notification.targets.platform.PlatformUsersNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversation;
import org.thingsboard.server.common.data.notification.targets.slack.SlackNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.NotificationController;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.dao.notification.NotificationService;
import org.thingsboard.server.dao.notification.NotificationSettingsService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.notification.NotificationProcessingContext;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.translation.TranslationService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class NotificationController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationController.class);
    private final NotificationService notificationService;
    private final NotificationRequestService notificationRequestService;
    private final NotificationTemplateService notificationTemplateService;
    private final NotificationTargetService notificationTargetService;
    private final NotificationCenter notificationCenter;
    private final NotificationSettingsService notificationSettingsService;
    private final TranslationService translationService;

    @ApiOperation(value="Get notifications (getNotifications)", notes="Returns the page of notifications for current user.\n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for any authorized user. \n\n**WebSocket API**:\n\nThere are 2 types of subscriptions: one for unread notifications count, another for unread notifications themselves.\n\nThe URI for opening WS session for notifications: `/api/ws/plugins/notifications`.\n\nSubscription command for unread notifications count:\n```\n{\n  \"unreadCountSubCmd\": {\n    \"cmdId\": 1234\n  }\n}\n```\nTo subscribe for latest unread notifications:\n```\n{\n  \"unreadSubCmd\": {\n    \"cmdId\": 1234,\n    \"limit\": 10\n  }\n}\n```\nTo unsubscribe from any subscription:\n```\n{\n  \"unsubCmd\": {\n    \"cmdId\": 1234\n  }\n}\n```\nTo mark certain notifications as read, use following command:\n```\n{\n  \"markAsReadCmd\": {\n    \"cmdId\": 1234,\n    \"notifications\": [\n      \"6f860330-7fc2-11ed-b855-7dd3b7d2faa9\",\n      \"5b6dfee0-8d0d-11ed-b61f-35a57b03dade\"\n    ]\n  }\n}\n\n```\nTo mark all notifications as read:\n```\n{\n  \"markAllAsReadCmd\": {\n    \"cmdId\": 1234\n  }\n}\n```\n\n\nUpdate structure for unread **notifications count subscription**:\n```\n{\n  \"cmdId\": 1234,\n  \"totalUnreadCount\": 55\n}\n```\nFor **notifications subscription**:\n- full update of latest unread notifications:\n```\n{\n  \"cmdId\": 1234,\n  \"notifications\": [\n    {\n      \"id\": {\n        \"entityType\": \"NOTIFICATION\",\n        \"id\": \"6f860330-7fc2-11ed-b855-7dd3b7d2faa9\"\n      },\n      ...\n    }\n  ],\n  \"totalUnreadCount\": 1\n}\n```\n- when new notification arrives or shown notification is updated:\n```\n{\n  \"cmdId\": 1234,\n  \"update\": {\n    \"id\": {\n      \"entityType\": \"NOTIFICATION\",\n      \"id\": \"6f860330-7fc2-11ed-b855-7dd3b7d2faa9\"\n    },\n    # updated notification info, text, subject etc.\n    ...\n  },\n  \"totalUnreadCount\": 2\n}\n```\n- when unread notifications count changes:\n```\n{\n  \"cmdId\": 1234,\n  \"totalUnreadCount\": 5\n}\n```")
    @GetMapping(value={"/notifications"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public PageData<Notification> getNotifications(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on notification subject or text") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @Parameter(description="To search for unread notifications only") @RequestParam(defaultValue="false") boolean unreadOnly, @Parameter(description="Delivery method", schema=@Schema(allowableValues={"WEB", "MOBILE_APP"})) @RequestParam(defaultValue="WEB") NotificationDeliveryMethod deliveryMethod, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.notificationService.findNotificationsByRecipientIdAndReadStatus(user.getTenantId(), deliveryMethod, user.getId(), unreadOnly, pageLink);
    }

    @ApiOperation(value="Get unread notifications count (getUnreadNotificationsCount)", notes="Returns unread notifications count for chosen delivery method.\n\nAvailable for any authorized user. ")
    @GetMapping(value={"/notifications/unread/count"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public Integer getUnreadNotificationsCount(@Parameter(description="Delivery method", schema=@Schema(allowableValues={"WEB", "MOBILE_APP"})) @RequestParam(defaultValue="MOBILE_APP") NotificationDeliveryMethod deliveryMethod, @AuthenticationPrincipal SecurityUser user) {
        return this.notificationService.countUnreadNotificationsByRecipientId(user.getTenantId(), deliveryMethod, user.getId());
    }

    @ApiOperation(value="Mark notification as read (markNotificationAsRead)", notes="Marks notification as read by its id.\n\nAvailable for any authorized user. ")
    @PutMapping(value={"/notification/{id}/read"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public void markNotificationAsRead(@PathVariable UUID id, @AuthenticationPrincipal SecurityUser user) {
        NotificationId notificationId = new NotificationId(id);
        this.notificationCenter.markNotificationAsRead(user.getTenantId(), user.getId(), notificationId);
    }

    @ApiOperation(value="Mark all notifications as read (markAllNotificationsAsRead)", notes="Marks all unread notifications as read.\n\nAvailable for any authorized user. ")
    @PutMapping(value={"/notifications/read"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public void markAllNotificationsAsRead(@Parameter(description="Delivery method", schema=@Schema(allowableValues={"WEB", "MOBILE_APP"})) @RequestParam(defaultValue="WEB") NotificationDeliveryMethod deliveryMethod, @AuthenticationPrincipal SecurityUser user) {
        this.notificationCenter.markAllNotificationsAsRead(user.getTenantId(), deliveryMethod, user.getId());
    }

    @ApiOperation(value="Delete notification (deleteNotification)", notes="Deletes notification by its id.\n\nAvailable for any authorized user. ")
    @DeleteMapping(value={"/notification/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public void deleteNotification(@PathVariable UUID id, @AuthenticationPrincipal SecurityUser user) {
        NotificationId notificationId = new NotificationId(id);
        this.notificationCenter.deleteNotification(user.getTenantId(), user.getId(), notificationId);
    }

    @ApiOperation(value="Create notification request (createNotificationRequest)", notes="Processes notification request.\nMandatory request properties are `targets` (list of targets ids to send notification to), and either `templateId` (existing notification template id) or `template` (to send notification without saving the template).\nOptionally, you can set `sendingDelayInSec` inside the `additionalConfig` field to schedule the notification.\n\nFor each enabled delivery method in the notification template, there must be a target in the `targets` list that supports this delivery method: if you chose `WEB`, `EMAIL` or `SMS` - there must be at least one target in `targets` of `PLATFORM_USERS` type.\nFor `SLACK` delivery method - you need to chose at least one `SLACK` notification target.\n\nNotification request object with `PROCESSING` status will be returned immediately, and the notification sending itself is done asynchronously. After all notifications are sent, the `status` of the request becomes `SENT`. Use `getNotificationRequestById` to see the notification request processing status and some sending stats. \n\nHere is an example of notification request to one target using saved template:\n```json\n{\n  \"templateId\": {\n    \"entityType\": \"NOTIFICATION_TEMPLATE\",\n    \"id\": \"6dbc3670-e4dd-11ed-9401-dbcc5dff78be\"\n  },\n  \"targets\": [\n    \"320e3ed0-d785-11ed-a06c-21dd57dd88ca\"\n  ],\n  \"additionalConfig\": {\n    \"sendingDelayInSec\": 0\n  }\n}\n```\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/notification/request"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationRequest createNotificationRequest(@RequestBody @Valid NotificationRequest notificationRequest, @AuthenticationPrincipal SecurityUser user) throws Exception {
        if (notificationRequest.getId() != null) {
            throw new IllegalArgumentException("Notification request cannot be updated. You may only cancel/delete it");
        }
        notificationRequest.setTenantId(user.getTenantId());
        this.checkEntity((EntityId)((NotificationRequestId)notificationRequest.getId()), (TenantEntity)notificationRequest, Resource.NOTIFICATION);
        List<NotificationTargetId> targets = notificationRequest.getTargets().stream().map(NotificationTargetId::new).toList();
        for (NotificationTargetId targetId : targets) {
            this.checkNotificationTargetId(targetId, Operation.READ);
        }
        notificationRequest.setOriginatorEntityId((EntityId)user.getId());
        notificationRequest.setInfo(null);
        notificationRequest.setRuleId(null);
        notificationRequest.setStatus(null);
        notificationRequest.setStats(null);
        return (NotificationRequest)this.doSaveAndLog(EntityType.NOTIFICATION_REQUEST, (HasName)notificationRequest, (tenantId, request) -> this.notificationCenter.processNotificationRequest(tenantId, request, null));
    }

    @ApiOperation(value="Get notification request preview (getNotificationRequestPreview)", notes="Returns preview for notification request.\n\n`processedTemplates` shows how the notifications for each delivery method will look like for the first recipient of the corresponding notification target.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/notification/request/preview"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationRequestPreview getNotificationRequestPreview(@RequestBody @Valid NotificationRequest request, @Parameter(description="Amount of the recipients to show in preview") @RequestParam(defaultValue="20") int recipientsPreviewSize, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.NOTIFICATION, Operation.WRITE);
        NotificationTemplate template = request.getTemplateId() != null ? (NotificationTemplate)this.checkEntityId((EntityId)request.getTemplateId(), (arg_0, arg_1) -> ((NotificationTemplateService)this.notificationTemplateService).findNotificationTemplateById(arg_0, arg_1), Operation.READ) : request.getTemplate();
        if (template == null) {
            throw new IllegalArgumentException("Template is missing");
        }
        request.setOriginatorEntityId((EntityId)user.getId());
        List<NotificationTarget> targets = request.getTargets().stream().map(NotificationTargetId::new).map(targetId -> {
            NotificationTarget target = this.notificationTargetService.findNotificationTargetById(user.getTenantId(), targetId);
            if (target == null) {
                throw new IllegalArgumentException("Notification target for id " + String.valueOf(targetId) + " not found");
            }
            return target;
        }).sorted(Comparator.comparing(target -> target.getConfiguration().getType())).toList();
        NotificationRequestPreview preview = new NotificationRequestPreview();
        LinkedHashSet<String> recipientsPreview = new LinkedHashSet<String>();
        LinkedHashMap<String, Integer> recipientsCountByTarget = new LinkedHashMap<String, Integer>();
        HashMap<NotificationTargetType, NotificationRecipient> firstRecipient = new HashMap<NotificationTargetType, NotificationRecipient>();
        for (NotificationTarget target2 : targets) {
            int recipientsCount;
            this.checkEntity(this.getCurrentUser(), (HasId)target2, Operation.READ);
            NotificationTargetType targetType = target2.getConfiguration().getType();
            List<Object> recipientsPart = switch (1.$SwitchMap$org$thingsboard$server$common$data$notification$targets$NotificationTargetType[targetType.ordinal()]) {
                case 1 -> {
                    PageData recipients = this.notificationTargetService.findRecipientsForNotificationTargetConfig(user.getTenantId(), (PlatformUsersNotificationTargetConfig)target2.getConfiguration(), new PageLink(recipientsPreviewSize, 0, null, SortOrder.BY_CREATED_TIME_DESC));
                    recipientsCount = (int)recipients.getTotalElements();
                    yield recipients.getData().stream().map(r -> r).collect(Collectors.toList());
                }
                case 2 -> {
                    recipientsCount = 1;
                    yield List.of(((SlackNotificationTargetConfig)target2.getConfiguration()).getConversation());
                }
                case 3 -> {
                    recipientsCount = 1;
                    yield List.of((MicrosoftTeamsNotificationTargetConfig)target2.getConfiguration());
                }
                default -> throw new IllegalArgumentException("Target type " + String.valueOf(targetType) + " not supported");
            };
            firstRecipient.putIfAbsent(targetType, !recipientsPart.isEmpty() ? (NotificationRecipient)recipientsPart.get(0) : null);
            for (NotificationRecipient notificationRecipient : recipientsPart) {
                if (recipientsPreview.size() >= recipientsPreviewSize) break;
                Object title = notificationRecipient.getTitle();
                if (notificationRecipient instanceof SlackConversation) {
                    title = ((SlackConversation)notificationRecipient).getPointer() + (String)title;
                } else if (notificationRecipient instanceof User && !((String)title).equals(notificationRecipient.getEmail())) {
                    title = (String)title + " (" + notificationRecipient.getEmail() + ")";
                }
                recipientsPreview.add((String)title);
            }
            recipientsCountByTarget.put(target2.getName(), recipientsCount);
        }
        preview.setRecipientsPreview(recipientsPreview);
        preview.setRecipientsCountByTarget(recipientsCountByTarget);
        preview.setTotalRecipientsCount(recipientsCountByTarget.values().stream().mapToInt(Integer::intValue).sum());
        Set deliveryMethods = template.getConfiguration().getDeliveryMethodsTemplates().entrySet().stream().filter(entry -> ((DeliveryMethodNotificationTemplate)entry.getValue()).isEnabled()).map(Map.Entry::getKey).collect(Collectors.toSet());
        NotificationProcessingContext ctx = NotificationProcessingContext.builder().tenantId(user.getTenantId()).request(request).deliveryMethods(deliveryMethods).template(template).settings(null).translationProvider(locale -> this.translationService.getFullTranslation(user.getTenantId(), null, locale)).build();
        Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> processedTemplates = ctx.getDeliveryMethods().stream().collect(Collectors.toMap(m -> m, deliveryMethod -> {
            NotificationTargetType targetType = NotificationTargetType.forDeliveryMethod((NotificationDeliveryMethod)deliveryMethod);
            return ctx.getProcessedTemplate(deliveryMethod, (NotificationRecipient)firstRecipient.get(targetType));
        }));
        preview.setProcessedTemplates(processedTemplates);
        return preview;
    }

    @ApiOperation(value="Get notification request by id (getNotificationRequestById)", notes="Fetches notification request info by request id.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/notification/request/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationRequestInfo getNotificationRequestById(@PathVariable UUID id) throws ThingsboardException {
        NotificationRequestId notificationRequestId = new NotificationRequestId(id);
        return (NotificationRequestInfo)this.checkEntityId((EntityId)notificationRequestId, (arg_0, arg_1) -> ((NotificationRequestService)this.notificationRequestService).findNotificationRequestInfoById(arg_0, arg_1), Operation.READ);
    }

    @ApiOperation(value="Get notification requests (getNotificationRequests)", notes="Returns the page of notification requests submitted by users of this tenant or sysadmins.\n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/notification/requests"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PageData<NotificationRequestInfo> getNotificationRequests(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filed based on the used template name") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.NOTIFICATION, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.notificationRequestService.findNotificationRequestsInfosByTenantIdAndOriginatorType(user.getTenantId(), EntityType.USER, pageLink);
    }

    @ApiOperation(value="Delete notification request (deleteNotificationRequest)", notes="Deletes notification request by its id.\n\nIf the request has status `SENT` - all sent notifications for this request will be deleted. If it is `SCHEDULED`, the request will be cancelled.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @DeleteMapping(value={"/notification/request/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public void deleteNotificationRequest(@PathVariable UUID id) throws Exception {
        NotificationRequestId notificationRequestId = new NotificationRequestId(id);
        NotificationRequest notificationRequest = (NotificationRequest)this.checkEntityId((EntityId)notificationRequestId, (arg_0, arg_1) -> ((NotificationRequestService)this.notificationRequestService).findNotificationRequestById(arg_0, arg_1), Operation.DELETE);
        this.doDeleteAndLog(EntityType.NOTIFICATION_REQUEST, (HasName)notificationRequest, (arg_0, arg_1) -> ((NotificationCenter)this.notificationCenter).deleteNotificationRequest(arg_0, arg_1));
    }

    @ApiOperation(value="Save notification settings (saveNotificationSettings)", notes="Saves notification settings for this tenant or sysadmin.\n`deliveryMethodsConfigs` of the settings must be specified.\n\nHere is an example of the notification settings with Slack configuration:\n```json\n{\n  \"deliveryMethodsConfigs\": {\n    \"SLACK\": {\n      \"method\": \"SLACK\",\n      \"botToken\": \"xoxb-....\"\n    }\n  }\n}\n```\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/notification/settings"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationSettings saveNotificationSettings(@RequestBody @Valid NotificationSettings notificationSettings, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        if (user.isSystemAdmin()) {
            this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.WRITE);
        } else {
            this.accessControlService.checkPermission(user, Resource.WHITE_LABELING, Operation.WRITE);
        }
        this.notificationSettingsService.saveNotificationSettings(user.getTenantId(), notificationSettings);
        return notificationSettings;
    }

    @ApiOperation(value="Get notification settings (getNotificationSettings)", notes="Retrieves notification settings for this tenant or sysadmin.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/notification/settings"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationSettings getNotificationSettings(@AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        if (user.isSystemAdmin()) {
            this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.READ);
        } else {
            this.accessControlService.checkPermission(user, Resource.WHITE_LABELING, Operation.READ);
        }
        return this.notificationSettingsService.findNotificationSettings(user.getTenantId());
    }

    @ApiOperation(value="Get available delivery methods (getAvailableDeliveryMethods)", notes="Returns the list of delivery methods that are properly configured and are allowed to be used for sending notifications.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/notification/deliveryMethods"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public List<NotificationDeliveryMethod> getAvailableDeliveryMethods(@AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        return this.notificationCenter.getAvailableDeliveryMethods(user.getTenantId());
    }

    @PostMapping(value={"/notification/settings/user"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public UserNotificationSettings saveUserNotificationSettings(@RequestBody @Valid UserNotificationSettings settings, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.PROFILE, Operation.WRITE);
        return this.notificationSettingsService.saveUserNotificationSettings(user.getTenantId(), user.getId(), settings);
    }

    @GetMapping(value={"/notification/settings/user"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    public UserNotificationSettings getUserNotificationSettings(@AuthenticationPrincipal SecurityUser user) {
        return this.notificationSettingsService.getUserNotificationSettings(user.getTenantId(), user.getId(), true);
    }

    @ConstructorProperties(value={"notificationService", "notificationRequestService", "notificationTemplateService", "notificationTargetService", "notificationCenter", "notificationSettingsService", "translationService"})
    @Generated
    public NotificationController(NotificationService notificationService, NotificationRequestService notificationRequestService, NotificationTemplateService notificationTemplateService, NotificationTargetService notificationTargetService, NotificationCenter notificationCenter, NotificationSettingsService notificationSettingsService, TranslationService translationService) {
        this.notificationService = notificationService;
        this.notificationRequestService = notificationRequestService;
        this.notificationTemplateService = notificationTemplateService;
        this.notificationTargetService = notificationTargetService;
        this.notificationCenter = notificationCenter;
        this.notificationSettingsService = notificationSettingsService;
        this.translationService = translationService;
    }
}

