/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.mail.TbMailConfigTemplateService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/mail/config/template"})
public class MailConfigTemplateController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailConfigTemplateController.class);
    private static final String MAIL_CONFIG_TEMPLATE_DEFINITION = "Mail configuration template is set of default smtp settings for mail server that specific provider supports";
    private final TbMailConfigTemplateService mailConfigTemplateService;

    @ApiOperation(value="Get the list of all OAuth2 client registration templates (getClientRegistrationTemplates)\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.", notes="Mail configuration template is set of default smtp settings for mail server that specific provider supports")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonNode getClientRegistrationTemplates() throws ThingsboardException, IOException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.READ);
        return this.mailConfigTemplateService.findAllMailConfigTemplates();
    }

    @ConstructorProperties(value={"mailConfigTemplateService"})
    @Generated
    public MailConfigTemplateController(TbMailConfigTemplateService mailConfigTemplateService) {
        this.mailConfigTemplateService = mailConfigTemplateService;
    }
}

