/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.IntegrationConvertersInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.integration.IntegrationInfo;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AutoCommitController;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.exception.ThingsboardRuntimeException;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.integration.TbIntegrationService;
import org.thingsboard.server.service.integration.IntegrationManagerService;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class IntegrationController
extends AutoCommitController {
    private final IntegrationManagerService integrationManagerService;
    private final TbIntegrationService tbIntegrationService;
    private final SecretConfigurationService secretConfigurationService;
    private static final String INTEGRATION_ID = "integrationId";

    @ApiOperation(value="Get Integration (getIntegrationById)", notes="Fetch the Integration object based on the provided Integration Id. The server checks that the integration is owned by the same tenant. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/integration/{integrationId}"})
    public Integration getIntegrationById(@Parameter(required=true, description="A string value representing the integration id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="integrationId") String strIntegrationId) throws Exception {
        this.checkParameter(INTEGRATION_ID, strIntegrationId);
        IntegrationId integrationId = new IntegrationId(this.toUUID(strIntegrationId));
        return this.checkIntegrationId(integrationId, Operation.READ);
    }

    @ApiOperation(value="Get Integration by Routing Key (getIntegrationByRoutingKey)", notes="Fetch the Integration object based on the provided routing key. The server checks that the integration is owned by the same tenant. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/integration/routingKey/{routingKey}"})
    public Integration getIntegrationByRoutingKey(@Parameter(required=true, description="A string value representing the integration routing key. For example, '542047e6-c1b2-112e-a87e-e49247c09d4b'") @PathVariable(value="routingKey") String routingKey) throws Exception {
        Integration integration = (Integration)this.checkNotNull(this.integrationService.findIntegrationByRoutingKey(this.getTenantId(), routingKey));
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.INTEGRATION, Operation.READ, (EntityId)integration.getId(), (TenantEntity)integration);
        return integration;
    }

    @ApiOperation(value="Create Or Update Integration (saveIntegration)", notes="Create or update the Integration. When creating integration, platform generates Integration Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created integration id will be present in the response. Specify existing Integration id to update the integration. Referencing non-existing integration Id will cause 'Not Found' error. Integration configuration is validated for each type of the integration before it can be created. \n\n# Integration Configuration\n\nIntegration configuration (**'configuration'** field) is the JSON object representing the special configuration per integration type with the connectivity fields and other important parameters dependent on the specific integration type. Let's review the configuration object for the MQTT Integration type below. \n\n```json\n{\n   \"clientConfiguration\":{\n      \"host\":\"broker.hivemq.com\",\n      \"port\":1883,\n      \"cleanSession\":false,\n      \"ssl\":false,\n      \"connectTimeoutSec\":10,\n      \"clientId\":\"\",\n      \"maxBytesInMessage\":32368,\n      \"credentials\":{\n         \"type\":\"anonymous\"\n      }\n   },\n   \"downlinkTopicPattern\":\"${topic}\",\n   \"topicFilters\":[\n      {\n         \"filter\":\"tb/mqtt-integration-tutorial/sensors/+/temperature\",\n         \"qos\":0\n      }\n   ],\n   \"metadata\":{\n   }\n}\n```\n\nRemove 'id', 'tenantId' from the request body example (below) to create new Integration entity. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/integration"})
    public Integration saveIntegration(@Parameter(required=true, description="A JSON value representing the integration.") @RequestBody Integration integration) throws Exception {
        SecurityUser currentUser = this.getCurrentUser();
        try {
            TenantId tenantId = this.getTenantId();
            integration.setTenantId(tenantId);
            boolean created = integration.getId() == null;
            this.checkEntity((EntityId)integration.getId(), (TenantEntity)integration, Resource.INTEGRATION, null);
            if (!integration.isEdgeTemplate()) {
                try {
                    Integration copy = new Integration(integration);
                    this.secretConfigurationService.replaceSecretUsages(tenantId, copy.getConfiguration());
                    this.integrationManagerService.validateIntegrationConfiguration(copy).get(20L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    this.throwRealCause(e);
                }
            }
            Integration result = (Integration)this.checkNotNull((Object)this.integrationService.saveIntegration(integration));
            this.autoCommit((User)currentUser, (EntityId)result.getId());
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)result.getId(), (HasName)result, created ? ActionType.ADDED : ActionType.UPDATED, (User)currentUser, new Object[0]);
            return result;
        }
        catch (TimeoutException e) {
            throw new ThingsboardRuntimeException("Timeout to validate the configuration!", ThingsboardErrorCode.GENERAL);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.INTEGRATION), (HasName)integration, integration.getId() == null ? ActionType.ADDED : ActionType.UPDATED, (User)currentUser, e, new Object[0]);
            throw e;
        }
    }

    @ApiOperation(value="Get Integrations (getIntegrations)", notes="Returns a page of integrations owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/integrations"}, params={"pageSize", "page"})
    public PageData<Integration> getIntegrations(@Parameter(description="Fetch edge template integrations") @RequestParam(value="isEdgeTemplate", required=false, defaultValue="false") boolean isEdgeTemplate, @Parameter(required=true, description="Maximum amount of entities in a one page", schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(required=true, description="Sequence number of page starting from 0", schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the integration name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "debugMode", "allowCreateDevicesOrAssets", "enabled", "remote", "routingKey", "secret"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.INTEGRATION, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (isEdgeTemplate) {
            return (PageData)this.checkNotNull((Object)this.integrationService.findTenantEdgeTemplateIntegrations(tenantId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.integrationService.findTenantIntegrations(tenantId, pageLink));
    }

    @ApiOperation(value="Get Integration Infos (getIntegrationInfos)", notes="Returns a page of integration infos owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/integrationInfos"}, params={"pageSize", "page"})
    public PageData<IntegrationInfo> getIntegrationInfos(@Parameter(description="Fetch edge template integrations") @RequestParam(value="isEdgeTemplate", required=false, defaultValue="false") boolean isEdgeTemplate, @Parameter(required=true, description="Maximum amount of entities in a one page", schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(required=true, description="Sequence number of page starting from 0", schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the integration name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "debugMode", "allowCreateDevicesOrAssets", "enabled", "remote", "routingKey", "secret"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.INTEGRATION, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.tbIntegrationService.findTenantIntegrationInfos(tenantId, pageLink, isEdgeTemplate);
    }

    @ApiOperation(value="Check integration connectivity (checkIntegrationConnection)", notes="Checks if the connection to the integration is established. Throws an error if the connection is not established. Example: Failed to connect to MQTT broker at host:port.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/integration/check"})
    public void checkIntegrationConnection(@Parameter(required=true, description="A JSON value representing the integration.") @RequestBody Integration integration) throws Exception {
        try {
            this.checkNotNull((Object)integration);
            TenantId tenantId = this.getCurrentUser().getTenantId();
            integration.setTenantId(tenantId);
            try {
                Integration copy = new Integration(integration);
                this.secretConfigurationService.replaceSecretUsages(tenantId, copy.getConfiguration());
                this.integrationManagerService.checkIntegrationConnection(copy).get((long)this.integrationManagerService.getIntegrationConnectionCheckApiRequestTimeoutSec(), TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                this.throwRealCause(e);
            }
        }
        catch (TimeoutException e) {
            throw new ThingsboardRuntimeException("Timeout to process the request!", ThingsboardErrorCode.GENERAL);
        }
    }

    @ApiOperation(value="Delete integration (deleteIntegration)", notes="Deletes the integration and all the relations (from and to the integration). Referencing non-existing integration Id will cause an error. \n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/integration/{integrationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteIntegration(@Parameter(required=true, description="A string value representing the integration id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="integrationId") String strIntegrationId) throws Exception {
        this.checkParameter(INTEGRATION_ID, strIntegrationId);
        try {
            IntegrationId integrationId = new IntegrationId(this.toUUID(strIntegrationId));
            Integration integration = this.checkIntegrationId(integrationId, Operation.DELETE);
            this.integrationService.deleteIntegration(this.getTenantId(), integrationId);
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)integrationId, (HasName)integration, ActionType.DELETED, (User)this.getCurrentUser(), new Object[]{strIntegrationId});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.INTEGRATION), ActionType.DELETED, (User)this.getCurrentUser(), e, new Object[]{strIntegrationId});
            throw e;
        }
    }

    @ApiOperation(value="Get Integrations By Ids (getIntegrationsByIds)", notes="Requested integrations must be owned by tenant which is performing the request. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/integrations"}, params={"integrationIds"})
    public List<Integration> getIntegrationsByIds(@Parameter(description="A list of integration ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="integrationIds") String[] strIntegrationIds) throws Exception {
        this.checkArrayParameter("integrationIds", strIntegrationIds);
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.INTEGRATION, Operation.READ)) {
            return Collections.emptyList();
        }
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<IntegrationId> integrationIds = new ArrayList<IntegrationId>();
        for (String strIntegrationId : strIntegrationIds) {
            integrationIds.add(new IntegrationId(this.toUUID(strIntegrationId)));
        }
        List integrations = (List)this.checkNotNull((Object)((List)this.integrationService.findIntegrationsByIdsAsync(tenantId, integrationIds).get()));
        return this.filterIntegrationsByReadPermission(integrations);
    }

    private List<Integration> filterIntegrationsByReadPermission(List<Integration> integrations) {
        return integrations.stream().filter(integration -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.INTEGRATION, Operation.READ, (EntityId)integration.getId(), (TenantEntity)integration);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    @ApiOperation(value="Assign integration to edge (assignIntegrationToEdge)", notes="Creates assignment of an existing integration edge template to an instance of The Edge. Assignment works in async way - first, notification event pushed to edge service queue on platform. Second, remote edge service will receive a copy of assignment integration (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once integration will be delivered to edge service, it's going to start locally. \n\nOnly integration edge template can be assigned to edge.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/edge/{edgeId}/integration/{integrationId}"})
    public Integration assignIntegrationToEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="integrationId") String strIntegrationId) throws Exception {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(INTEGRATION_ID, strIntegrationId);
        try {
            EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
            Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
            IntegrationId integrationId = new IntegrationId(this.toUUID(strIntegrationId));
            this.checkIntegrationId(integrationId, Operation.READ);
            Integration savedIntegration = (Integration)this.checkNotNull((Object)this.integrationService.assignIntegrationToEdge(this.getCurrentUser().getTenantId(), integrationId, edgeId));
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)integrationId, (HasName)savedIntegration, ActionType.ASSIGNED_TO_EDGE, (User)this.getCurrentUser(), new Object[]{strIntegrationId, strEdgeId, edge.getName()});
            return savedIntegration;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.INTEGRATION), ActionType.ASSIGNED_TO_EDGE, (User)this.getCurrentUser(), e, new Object[]{strIntegrationId, strEdgeId});
            throw e;
        }
    }

    @ApiOperation(value="Unassign integration from edge (unassignIntegrationFromEdge)", notes="Clears assignment of the integration to the edge. Unassignment works in async way - first, 'unassign' notification event pushed to edge queue on platform. Second, remote edge service will receive an 'unassign' command to remove integration (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once 'unassign' command will be delivered to edge service, it's going to remove integration locally.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/edge/{edgeId}/integration/{integrationId}"})
    public Integration unassignIntegrationFromEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="integrationId") String strIntegrationId) throws Exception {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(INTEGRATION_ID, strIntegrationId);
        try {
            EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
            Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
            IntegrationId integrationId = new IntegrationId(this.toUUID(strIntegrationId));
            Integration integration = this.checkIntegrationId(integrationId, Operation.READ);
            Integration savedIntegration = (Integration)this.checkNotNull((Object)this.integrationService.unassignIntegrationFromEdge(this.getCurrentUser().getTenantId(), integrationId, edgeId, false));
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)integrationId, (HasName)integration, ActionType.UNASSIGNED_FROM_EDGE, (User)this.getCurrentUser(), new Object[]{strIntegrationId, strEdgeId, edge.getName()});
            return savedIntegration;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.INTEGRATION), ActionType.UNASSIGNED_FROM_EDGE, (User)this.getCurrentUser(), e, new Object[]{strIntegrationId, strEdgeId});
            throw e;
        }
    }

    @ApiOperation(value="Get Edge Integrations (getEdgeIntegrations)", notes="Returns a page of Integrations assigned to the specified edge. The integration object contains information about the Integration, including the heavyweight configuration object. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/{edgeId}/integrations"}, params={"pageSize", "page"})
    public PageData<Integration> getEdgeIntegrations(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the integration name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "debugMode", "allowCreateDevicesOrAssets", "enabled", "remote", "routingKey", "secret"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.integrationService.findIntegrationsByTenantIdAndEdgeId(tenantId, edgeId, pageLink));
    }

    @ApiOperation(value="Get Edge Integrations (getEdgeIntegrationInfos)", notes="Returns a page of Integrations assigned to the specified edge. The integration object contains information about the Integration, including the heavyweight configuration object. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/{edgeId}/integrationInfos"}, params={"pageSize", "page"})
    public PageData<IntegrationInfo> getEdgeIntegrationInfos(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'startsWith' filter based on the integration name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "debugMode", "allowCreateDevicesOrAssets", "enabled", "remote", "routingKey", "secret"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.tbIntegrationService.findIntegrationInfosByTenantIdAndEdgeId(tenantId, edgeId, pageLink));
    }

    @ApiOperation(value="Find edge missing attributes for assigned integrations (findEdgeMissingAttributes)", notes="Returns list of edge attribute names that are missing in assigned integrations.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/integration/{edgeId}/missingAttributes"}, params={"integrationIds"})
    public String findEdgeMissingAttributes(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="A list of assigned integration ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="integrationIds") String[] strIntegrationIds) throws Exception {
        this.checkArrayParameter("integrationIds", strIntegrationIds);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        edgeId = (EdgeId)this.checkNotNull((Object)edgeId);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<IntegrationId> integrationIds = new ArrayList<IntegrationId>();
        for (String strIntegrationId : strIntegrationIds) {
            integrationIds.add(new IntegrationId(this.toUUID(strIntegrationId)));
        }
        return this.edgeService.findEdgeMissingAttributes(tenantId, edgeId, integrationIds);
    }

    @ApiOperation(value="Find missing attributes for all related edges (findAllRelatedEdgesMissingAttributes)", notes="Returns list of attribute names of all related edges that are missing in the integration configuration.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/integration/{integrationId}/allMissingAttributes"})
    public String findAllRelatedEdgesMissingAttributes(@Parameter(description="A string value representing the integration id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="integrationId") String strIntegrationId) throws Exception {
        this.checkParameter(INTEGRATION_ID, strIntegrationId);
        IntegrationId integrationId = new IntegrationId(this.toUUID(strIntegrationId));
        integrationId = (IntegrationId)this.checkNotNull((Object)integrationId);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        return this.edgeService.findAllRelatedEdgesMissingAttributes(tenantId, integrationId);
    }

    @ApiOperation(value="Get Integrations Converters info (getIntegrationsConvertersInfo)", notes="Returns a JSON object containing information about existing tenant converters and converters available in library. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/integrations/converters/info"})
    public Map<IntegrationType, IntegrationConvertersInfo> getIntegrationsConvertersInfo() throws ThingsboardException {
        return this.tbIntegrationService.getIntegrationsConvertersInfo(this.getTenantId());
    }

    @ConstructorProperties(value={"integrationManagerService", "tbIntegrationService", "secretConfigurationService"})
    @Generated
    public IntegrationController(IntegrationManagerService integrationManagerService, TbIntegrationService tbIntegrationService, SecretConfigurationService secretConfigurationService) {
        this.integrationManagerService = integrationManagerService;
        this.tbIntegrationService = tbIntegrationService;
        this.secretConfigurationService = secretConfigurationService;
    }
}

