/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.permission.GroupPermissionInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class GroupPermissionController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupPermissionController.class);
    public static final String GROUP_PERMISSION_ID = "groupPermissionId";
    public static final String GROUP_PERMISSION_DESCRIPTION = "Group permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n";
    public static final String GROUP_PERMISSION_INFO_DESCRIPTION = "Group permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n Group Permission Info object extends the Group Permissions with the full information about Role and User and/or Entity Groups. ";

    @ApiOperation(value="Get Group Permission (getGroupPermissionById)", notes="Fetch the Group Permission object based on the provided Group Permission Id. Group permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/groupPermission/{groupPermissionId}"})
    public GroupPermission getGroupPermissionById(@Parameter(description="A string value representing the group permission id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="groupPermissionId") String strGroupPermissionId) throws ThingsboardException {
        this.checkParameter(GROUP_PERMISSION_ID, strGroupPermissionId);
        return this.checkGroupPermissionId(new GroupPermissionId(this.toUUID(strGroupPermissionId)), Operation.READ);
    }

    @ApiOperation(value="Get Group Permission Info (getGroupPermissionInfoById)", notes="Fetch the Group Permission Info object based on the provided Group Permission Id and the flag that controls what additional information to load: User or Entity Group. Group permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n Group Permission Info object extends the Group Permissions with the full information about Role and User and/or Entity Groups.  Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/groupPermission/info/{groupPermissionId}"})
    public GroupPermissionInfo getGroupPermissionInfoById(@Parameter(description="A string value representing the group permission id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="groupPermissionId") String strGroupPermissionId, @Parameter(description="Load additional information about User('true') or Entity Group('false).", required=true) @RequestParam boolean isUserGroup) throws ThingsboardException {
        this.checkParameter(GROUP_PERMISSION_ID, strGroupPermissionId);
        return this.checkGroupPermissionInfoId(new GroupPermissionId(this.toUUID(strGroupPermissionId)), Operation.READ, isUserGroup);
    }

    @ApiOperation(value="Create Or Update Group Permission (saveGroupPermission)", notes="Creates or Updates the Group Permission. When creating group permission, platform generates Group Permission Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Group Permission id will be present in the response. Specify existing Group Permission id to update the permission. Referencing non-existing Group Permission Id will cause 'Not Found' error.\n\nGroup permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/groupPermission"})
    public GroupPermission saveGroupPermission(@Parameter(description="A JSON value representing the group permission.", required=true) @RequestBody GroupPermission groupPermission) throws ThingsboardException {
        try {
            boolean alreadyAssigned;
            groupPermission.setTenantId(this.getCurrentUser().getTenantId());
            GroupPermission oldGroupPermission = null;
            if (groupPermission.getId() == null) {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.GROUP_PERMISSION, Operation.CREATE, null, (TenantEntity)groupPermission);
            } else {
                oldGroupPermission = this.checkGroupPermissionId(groupPermission.getId(), Operation.WRITE);
            }
            if (groupPermission.isPublic()) {
                throw this.permissionDenied();
            }
            Role role = this.checkRoleId(groupPermission.getRoleId(), Operation.READ);
            if (groupPermission.getUserGroupId() != null && !groupPermission.getUserGroupId().isNullUid()) {
                this.checkEntityGroupId(groupPermission.getUserGroupId(), Operation.WRITE);
            }
            if (groupPermission.getEntityGroupId() != null && !groupPermission.getEntityGroupId().isNullUid()) {
                if (role.getType() == RoleType.GENERIC) {
                    throw new IllegalArgumentException("Can't assign Generic Role to entity group!");
                }
                this.checkEntityGroupId(groupPermission.getEntityGroupId(), Operation.WRITE);
            }
            if (alreadyAssigned = this.isAlreadyAssigned(this.getTenantId(), groupPermission)) {
                throw new ThingsboardException("Such group permission already exists!", ThingsboardErrorCode.INVALID_ARGUMENTS);
            }
            GroupPermission savedGroupPermission = (GroupPermission)this.checkNotNull((Object)this.groupPermissionService.saveGroupPermission(this.getTenantId(), groupPermission));
            if (oldGroupPermission != null && !oldGroupPermission.getUserGroupId().equals((Object)savedGroupPermission.getUserGroupId())) {
                this.userPermissionsService.onGroupPermissionUpdated(oldGroupPermission);
            }
            this.userPermissionsService.onGroupPermissionUpdated(savedGroupPermission);
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)savedGroupPermission.getId(), (HasName)savedGroupPermission, groupPermission.getId() == null ? ActionType.ADDED : ActionType.UPDATED, (User)this.getCurrentUser(), new Object[0]);
            return savedGroupPermission;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.GROUP_PERMISSION), (HasName)groupPermission, groupPermission.getId() == null ? ActionType.ADDED : ActionType.UPDATED, (User)this.getCurrentUser(), e, new Object[0]);
            throw e;
        }
    }

    @ApiOperation(value="Delete group permission (deleteGroupPermission)", notes="Deletes the group permission. Referencing non-existing group permission Id will cause an error.\n\n Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/groupPermission/{groupPermissionId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteGroupPermission(@Parameter(description="A string value representing the group permission id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="groupPermissionId") String strGroupPermissionId) throws ThingsboardException {
        this.checkParameter(GROUP_PERMISSION_ID, strGroupPermissionId);
        try {
            GroupPermissionId groupPermissionId = new GroupPermissionId(this.toUUID(strGroupPermissionId));
            GroupPermission groupPermission = this.checkGroupPermissionId(groupPermissionId, Operation.DELETE);
            if (groupPermission.isPublic()) {
                throw this.permissionDenied();
            }
            this.checkRoleId(groupPermission.getRoleId(), Operation.READ);
            if (groupPermission.getUserGroupId() != null && !groupPermission.getUserGroupId().isNullUid()) {
                this.checkEntityGroupId(groupPermission.getUserGroupId(), Operation.WRITE);
            }
            if (groupPermission.getEntityGroupId() != null && !groupPermission.getEntityGroupId().isNullUid()) {
                this.checkEntityGroupId(groupPermission.getEntityGroupId(), Operation.WRITE);
            }
            this.groupPermissionService.deleteGroupPermission(this.getTenantId(), groupPermissionId);
            this.userPermissionsService.onGroupPermissionDeleted(groupPermission);
            this.logEntityActionService.logEntityAction(this.getTenantId(), (EntityId)groupPermissionId, (HasName)groupPermission, ActionType.DELETED, (User)this.getCurrentUser(), new Object[]{strGroupPermissionId});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(EntityType.GROUP_PERMISSION), ActionType.DELETED, (User)this.getCurrentUser(), e, new Object[]{strGroupPermissionId});
            throw e;
        }
    }

    @ApiOperation(value="Get group permissions by User Group Id (getUserGroupPermissions)", notes="Returns a list of group permission objects that belongs to specified User Group Id. Group permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n Group Permission Info object extends the Group Permissions with the full information about Role and User and/or Entity Groups. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/userGroup/{userGroupId}/groupPermissions"})
    public List<GroupPermissionInfo> getUserGroupPermissions(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="userGroupId") String strUserGroupId) throws ThingsboardException, ExecutionException, InterruptedException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EntityGroupId userGroupId = new EntityGroupId(UUID.fromString(strUserGroupId));
        this.checkEntityGroupId(userGroupId, Operation.READ);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.GROUP_PERMISSION, Operation.READ);
        List groupPermissions = (List)this.groupPermissionService.findGroupPermissionInfoListByTenantIdAndUserGroupIdAsync(tenantId, userGroupId).get();
        return this.applyPermissionInfo(groupPermissions);
    }

    @ApiOperation(value="Load User Group Permissions (loadUserGroupPermissionInfos)", notes="Enrich a list of group permission objects with the information about Role, User and Entity Groups. Group permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n Group Permission Info object extends the Group Permissions with the full information about Role and User and/or Entity Groups. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/userGroup/groupPermissions/info"})
    public List<GroupPermissionInfo> loadUserGroupPermissionInfos(@Parameter(description="JSON array of group permission objects", required=true) @RequestBody List<GroupPermission> permissions) throws ThingsboardException, ExecutionException, InterruptedException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.GROUP_PERMISSION, Operation.READ);
        List permissionInfoList = (List)this.groupPermissionService.loadUserGroupPermissionInfoListAsync(tenantId, permissions).get();
        return this.applyPermissionInfo(permissionInfoList);
    }

    @ApiOperation(value="Get group permissions by Entity Group Id (getEntityGroupPermissions)", notes="Returns a list of group permission objects that is assigned for the specified Entity Group Id. Group permission entity represents list of allowed operations for certain User Group to perform against certain Entity Group. Basically, this entity wires three other entities: \n\n * Role that defines set of allowed operations;\n * User Group that defines set of users who may perform the operations; \n * Entity Group that defines set of entities which will be accessible to users;\n\n Group Permission Info object extends the Group Permissions with the full information about Role and User and/or Entity Groups. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{entityGroupId}/groupPermissions"})
    public List<GroupPermissionInfo> getEntityGroupPermissions(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId) throws ThingsboardException, ExecutionException, InterruptedException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EntityGroupId entityGroupId = new EntityGroupId(UUID.fromString(strEntityGroupId));
        this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.GROUP_PERMISSION, Operation.READ);
        List<GroupPermissionInfo> groupPermissions = (List<GroupPermissionInfo>)this.groupPermissionService.findGroupPermissionInfoListByTenantIdAndEntityGroupIdAsync(tenantId, entityGroupId).get();
        if (this.getCurrentUser().isCustomerUser()) {
            CustomerId customerId = this.getCurrentUser().getCustomerId();
            Set owners = this.ownersCacheService.getChildOwners(tenantId, (EntityId)customerId);
            groupPermissions = groupPermissions.stream().filter(gp -> owners.contains(gp.getUserGroupOwnerId())).toList();
        }
        return this.applyPermissionInfo((List)groupPermissions);
    }

    private List<GroupPermissionInfo> applyPermissionInfo(List<GroupPermissionInfo> groupPermissions) throws ThingsboardException {
        groupPermissions = groupPermissions.stream().filter(gp -> gp != null && gp.getRole() != null).collect(Collectors.toList());
        for (GroupPermissionInfo groupPermissionInfo : groupPermissions) {
            Role role = groupPermissionInfo.getRole();
            groupPermissionInfo.setReadOnly(!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.ROLE, Operation.READ, (EntityId)role.getId(), (TenantEntity)role));
            if (!groupPermissionInfo.isPublic()) continue;
            groupPermissionInfo.setReadOnly(true);
        }
        return groupPermissions;
    }

    private boolean isAlreadyAssigned(TenantId tenantId, GroupPermission groupPermission) {
        if (groupPermission.getEntityGroupId() != null) {
            return this.groupPermissionService.findGroupPermissionByTenantIdAndEntityGroupIdAndUserGroupIdAndRoleId(tenantId, groupPermission.getEntityGroupId(), groupPermission.getUserGroupId(), groupPermission.getRoleId(), new PageLink(1)).getTotalElements() > 0L;
        }
        return this.groupPermissionService.findGroupPermissionByTenantIdAndUserGroupIdAndRoleId(tenantId, groupPermission.getUserGroupId(), groupPermission.getRoleId(), new PageLink(1)).getTotalElements() > 0L;
    }
}

