/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.rule.engine.flow.TbRuleChainInputNode;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeInfo;
import org.thingsboard.server.common.data.edge.EdgeInstructions;
import org.thingsboard.server.common.data.edge.EdgeSearchQuery;
import org.thingsboard.server.common.data.edge.EdgeSettings;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportRequest;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportResult;
import org.thingsboard.server.common.msg.edge.FromEdgeSyncResponse;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeBulkImportService;
import org.thingsboard.server.service.edge.instructions.EdgeInstallInstructionsService;
import org.thingsboard.server.service.edge.instructions.EdgeUpgradeInstructionsService;
import org.thingsboard.server.service.edge.rpc.EdgeRpcService;
import org.thingsboard.server.service.entitiy.edge.TbEdgeService;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EdgeController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeController.class);
    private final EdgeBulkImportService edgeBulkImportService;
    private final TbEdgeService tbEdgeService;
    private final Optional<EdgeRpcService> edgeRpcServiceOpt;
    private final Optional<EdgeInstallInstructionsService> edgeInstallServiceOpt;
    private final Optional<EdgeUpgradeInstructionsService> edgeUpgradeServiceOpt;
    public static final String EDGE_ID = "edgeId";
    public static final String EDGE_SECURITY_CHECK = "If the user has the authority of 'Tenant Administrator', the server checks that the edge is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the edge is assigned to the same customer.";

    @ApiOperation(value="Is edges support enabled (isEdgesSupportEnabled)", notes="Returns 'true' if edges support enabled on server, 'false' - otherwise.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edges/enabled"})
    public boolean isEdgesSupportEnabled() {
        return this.edgesEnabled;
    }

    @ApiOperation(value="Get Edge (getEdgeById)", notes="Get the Edge object based on the provided Edge Id. If the user has the authority of 'Tenant Administrator', the server checks that the edge is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the edge is assigned to the same customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/{edgeId}"})
    public Edge getEdgeById(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId) throws ThingsboardException {
        this.checkParameter(EDGE_ID, strEdgeId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.READ);
        SecurityUser user = this.getCurrentUser();
        if (!this.hasPermissionEdgeCreateOrWrite(user)) {
            this.cleanUpLicenseKey(edge);
        }
        return edge;
    }

    @ApiOperation(value="Get Edge Info (getEdgeInfoById)", notes="Get the Edge info object based on the provided Edge Id. If the user has the authority of 'Tenant Administrator', the server checks that the edge is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the edge is assigned to the same customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/info/{edgeId}"})
    public EdgeInfo getEdgeInfoById(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId) throws ThingsboardException {
        this.checkParameter(EDGE_ID, strEdgeId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        EdgeInfo edge = this.checkEdgeInfoId(edgeId, Operation.READ);
        SecurityUser user = this.getCurrentUser();
        if (!this.hasPermissionEdgeCreateOrWrite(user)) {
            this.cleanUpLicenseKey((Edge)edge);
        }
        return edge;
    }

    @ApiOperation(value="Create Or Update Edge (saveEdge)", notes="Create or update the Edge. When creating edge, platform generates Edge Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created edge id will be present in the response. Specify existing Edge id to update the edge. Referencing non-existing Edge Id will cause 'Not Found' error.\n\nEdge name is unique in the scope of tenant. Use unique identifiers like MAC or IMEI for the edge names and non-unique 'label' field for user-friendly visualization purposes.Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Edge entity. ")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/edge"})
    public Edge saveEdge(@Parameter(description="A JSON value representing the edge.", required=true) @RequestBody Edge edge, @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of entity group ids, separated by comma ','", array=@ArraySchema(schema=@Schema)) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds) throws Exception {
        Operation operation;
        TenantId tenantId = this.getCurrentUser().getTenantId();
        edge.setTenantId(tenantId);
        boolean created = edge.getId() == null;
        RuleChain edgeTemplateRootRuleChain = null;
        if (created && (edgeTemplateRootRuleChain = this.ruleChainService.getEdgeTemplateRootRuleChain(tenantId)) == null) {
            throw new DataValidationException("Root edge rule chain is not available!");
        }
        ArrayList<EntityGroupId> entityGroupIds = new ArrayList<EntityGroupId>();
        ArrayList<EntityGroupInfo> entityGroups = new ArrayList<EntityGroupInfo>();
        String[] groupIds = null;
        if (!StringUtils.isEmpty((String)strEntityGroupId)) {
            groupIds = new String[]{strEntityGroupId};
        } else if (strEntityGroupIds != null && strEntityGroupIds.length > 0) {
            groupIds = strEntityGroupIds;
        }
        if (groupIds != null) {
            for (String id : groupIds) {
                EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(id));
                EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
                entityGroupIds.add(entityGroupId);
                entityGroups.add(entityGroup);
            }
        }
        Operation operation2 = operation = created ? Operation.CREATE : Operation.WRITE;
        if (!entityGroupIds.isEmpty()) {
            for (EntityGroupId entityGroupId : entityGroupIds) {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.EDGE, operation, (EntityId)edge.getId(), (TenantEntity)edge, entityGroupId);
            }
        } else {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.EDGE, operation, (EntityId)edge.getId(), (TenantEntity)edge, null);
        }
        return this.tbEdgeService.save(edge, edgeTemplateRootRuleChain, entityGroups, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete edge (deleteEdge)", notes="Deletes the edge. Referencing non-existing edge Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/edge/{edgeId}"})
    public void deleteEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId) throws ThingsboardException {
        this.checkParameter(EDGE_ID, strEdgeId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.DELETE);
        this.tbEdgeService.delete(edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Edges (getEdges)", notes="Returns a page of edges owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edges"}, params={"pageSize", "page"})
    public PageData<Edge> getEdges(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the edge name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (PageData)this.checkNotNull((Object)this.edgeService.findEdgesByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Edges (getTenantEdges)", notes="Returns a page of edges owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/tenant/edges"}, params={"pageSize", "page"})
    public PageData<Edge> getTenantEdges(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="A string value representing the edge type. For example, 'default'") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the edge name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.edgeService.findEdgesByTenantIdAndType(tenantId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.edgeService.findEdgesByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Edge (getTenantEdge)", notes="Requested edge must be owned by tenant or customer that the user belongs to. Edge name is an unique property of edge. So it can be used to identify the edge.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/tenant/edges"}, params={"edgeName"})
    public Edge getTenantEdge(@Parameter(description="Unique name of the edge", required=true) @RequestParam String edgeName) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (Edge)this.checkNotNull((Object)this.edgeService.findEdgeByTenantIdAndName(tenantId, edgeName));
    }

    @ApiOperation(value="Set root rule chain for provided edge (setEdgeRootRuleChain)", notes="Change root rule chain of the edge to the new provided rule chain. \nThis operation will send a notification to update root rule chain on remote edge service.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/edge/{edgeId}/{ruleChainId}/root"})
    public Edge setEdgeRootRuleChain(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="ruleChainId") String strRuleChainId) throws Exception {
        this.checkParameter(EDGE_ID, strEdgeId);
        this.checkParameter("ruleChainId", strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        this.checkRuleChain(ruleChainId, Operation.READ);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
        return this.tbEdgeService.setEdgeRootRuleChain(edge, ruleChainId, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Customer Edges (getCustomerEdges)", notes="Returns a page of edges objects assigned to customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customer/{customerId}/edges"}, params={"pageSize", "page"})
    public PageData<Edge> getCustomerEdges(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="A string value representing the edge type. For example, 'default'") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the edge name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.EDGE, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        PageData result = type != null && type.trim().length() > 0 ? this.edgeService.findEdgesByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink) : this.edgeService.findEdgesByTenantIdAndCustomerId(tenantId, customerId, pageLink);
        if (!this.hasPermissionEdgeCreateOrWrite(user)) {
            for (Edge edge : result.getData()) {
                this.cleanUpLicenseKey(edge);
            }
        }
        return (PageData)this.checkNotNull((Object)result);
    }

    @ApiOperation(value="Get Edges (getUserEdges)", notes="Returns a page of edges available for current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/user/edges"}, params={"pageSize", "page"})
    public PageData<Edge> getUserEdges(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="A string value representing the edge type. For example, 'default'") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the edge name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        return this.entityService.findUserEntities(currentUser.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, EntityType.EDGE, Operation.READ, type, pageLink);
    }

    @ApiOperation(value="Get All Edge Infos for current user (getAllEdgeInfos)", notes="Returns a page of edge info objects owned by the tenant or the customer of a current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edgeInfos/all"}, params={"pageSize", "page"})
    public PageData<EdgeInfo> getAllEdgeInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="A string value representing the edge type. For example, 'default'") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the edge name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.EDGE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (includeCustomers != null && includeCustomers.booleanValue()) {
                if (type != null && type.length() > 0) {
                    return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndType(tenantId, type, pageLink));
                }
                return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantId(tenantId, pageLink));
            }
            if (type != null && type.length() > 0) {
                return (PageData)this.checkNotNull((Object)this.edgeService.findTenantEdgeInfosByTenantIdAndType(tenantId, type, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.edgeService.findTenantEdgeInfosByTenantId(tenantId, pageLink));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            if (type != null && type.length() > 0) {
                return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerIdAndTypeIncludingSubCustomers(tenantId, customerId, type, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        if (type != null && type.length() > 0) {
            return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer Edge Infos (getCustomerEdgeInfos)", notes="Returns a page of edge info objects owned by the specified customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customer/{customerId}/edgeInfos"}, params={"pageSize", "page"})
    public PageData<EdgeInfo> getCustomerEdgeInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="A string value representing the edge type. For example, 'default'") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the edge name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.EDGE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            if (type != null && type.length() > 0) {
                return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerIdAndTypeIncludingSubCustomers(tenantId, customerId, type, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        if (type != null && type.length() > 0) {
            return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.edgeService.findEdgeInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Edges By Ids (getEdgesByIds)", notes="Requested edges must be owned by tenant or assigned to customer which user is performing the request.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edges"}, params={"edgeIds"})
    public List<Edge> getEdgesByIds(@Parameter(description="A list of edges ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="edgeIds") String[] strEdgeIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("edgeIds", strEdgeIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        CustomerId customerId = user.getCustomerId();
        ArrayList<EdgeId> edgeIds = new ArrayList<EdgeId>();
        for (String strEdgeId : strEdgeIds) {
            edgeIds.add(new EdgeId(this.toUUID(strEdgeId)));
        }
        ListenableFuture edgesFuture = customerId == null || customerId.isNullUid() ? this.edgeService.findEdgesByTenantIdAndIdsAsync(tenantId, edgeIds) : this.edgeService.findEdgesByTenantIdCustomerIdAndIdsAsync(tenantId, customerId, edgeIds);
        List edges = (List)edgesFuture.get();
        if (!this.hasPermissionEdgeCreateOrWrite(user)) {
            for (Edge edge : edges) {
                this.cleanUpLicenseKey(edge);
            }
        }
        return (List)this.checkNotNull((Object)edges);
    }

    @ApiOperation(value="Find related edges (findByQuery)", notes="Returns all edges that are related to the specific entity. The entity id, relation type, edge types, depth of the search, and other query parameters defined using complex 'EdgeSearchQuery' object. See 'Model' tab of the Parameters for more info.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/edges"})
    public List<Edge> findByQuery(@RequestBody EdgeSearchQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query);
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getEdgeTypes());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        List<Edge> edges = (List<Edge>)this.checkNotNull((Object)((List)this.edgeService.findEdgesByQuery(tenantId, query).get()));
        edges = edges.stream().filter(edge -> {
            try {
                this.accessControlService.checkPermission(user, Resource.EDGE, Operation.READ, (EntityId)edge.getId(), (TenantEntity)edge);
                return true;
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
        if (!this.hasPermissionEdgeCreateOrWrite(user)) {
            for (Edge edge2 : edges) {
                this.cleanUpLicenseKey(edge2);
            }
        }
        return edges;
    }

    @ApiOperation(value="Get edges by Entity Group Id (getEdgesByEntityGroupId)", notes="Returns a page of Edge objects that belongs to specified Entity Group Id. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/entityGroup/{entityGroupId}/edges"}, params={"pageSize", "page"})
    public PageData<Edge> getEdgesByEntityGroupId(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="1")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the edge name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("entityGroupId", strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.checkEntityGroupType(EntityType.EDGE, entityGroup.getType());
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.edgeService.findEdgesByEntityGroupId(entityGroupId, pageLink));
    }

    @ApiOperation(value="Get Edge Types (getEdgeTypes)", notes="Returns a set of unique edge types based on edges that are either owned by the tenant or assigned to the customer which user is performing the request.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/types"})
    public List<EntitySubtype> getEdgeTypes() throws ThingsboardException, ExecutionException, InterruptedException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ListenableFuture edgeTypes = this.edgeService.findEdgeTypesByTenantId(tenantId);
        return (List)this.checkNotNull((Object)((List)edgeTypes.get()));
    }

    @ApiOperation(value="Sync edge (syncEdge)", notes="Starts synchronization process between edge and cloud. \nAll entities that are assigned to particular edge are going to be send to remote edge service.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/edge/sync/{edgeId}"})
    public DeferredResult<ResponseEntity> syncEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId) throws ThingsboardException {
        this.checkParameter(EDGE_ID, strEdgeId);
        DeferredResult response = new DeferredResult();
        if (!this.isEdgesEnabled() || !this.edgeRpcServiceOpt.isPresent()) {
            throw new ThingsboardException("Edges support disabled", ThingsboardErrorCode.GENERAL);
        }
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        edgeId = (EdgeId)this.checkNotNull((Object)edgeId);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ((EdgeRpcService)this.edgeRpcServiceOpt.get()).processSyncRequest(tenantId, edgeId, fromEdgeSyncResponse -> this.reply(response, fromEdgeSyncResponse));
        return response;
    }

    private void reply(DeferredResult<ResponseEntity> response, FromEdgeSyncResponse fromEdgeSyncResponse) {
        if (fromEdgeSyncResponse.isSuccess()) {
            response.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
        } else {
            response.setErrorResult((Object)new ThingsboardException(fromEdgeSyncResponse.getError(), ThingsboardErrorCode.GENERAL));
        }
    }

    @ApiOperation(value="Find missing rule chains (findMissingToRelatedRuleChains)", notes="Returns list of rule chains ids that are not assigned to particular edge, but these rule chains are present in the already assigned rule chains to edge.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/missingToRelatedRuleChains/{edgeId}"})
    public String findMissingToRelatedRuleChains(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId) throws ThingsboardException {
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        edgeId = (EdgeId)this.checkNotNull((Object)edgeId);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        return this.edgeService.findMissingToRelatedRuleChains(tenantId, edgeId, TbRuleChainInputNode.class.getName());
    }

    @ApiOperation(value="Import the bulk of edges (processEdgesBulkImport)", notes="There's an ability to import the bulk of edges using the only .csv file.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/edge/bulk_import"})
    public BulkImportResult<Edge> processEdgesBulkImport(@RequestBody BulkImportRequest request) throws Exception {
        SecurityUser user = this.getCurrentUser();
        RuleChain edgeTemplateRootRuleChain = this.ruleChainService.getEdgeTemplateRootRuleChain(user.getTenantId());
        if (edgeTemplateRootRuleChain == null) {
            throw new DataValidationException("Root edge rule chain is not available!");
        }
        return this.edgeBulkImportService.processBulkImport(request, user, (edge, savingFunction) -> {
            try {
                EntityGroupInfo entityGroup = null;
                if (!StringUtils.isEmpty((String)request.getEntityGroupId())) {
                    EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(request.getEntityGroupId()));
                    entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
                }
                savingFunction.apply(edge, entityGroup);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @ApiOperation(value="Check edge license (checkInstance)", notes="Checks license request from edge service by forwarding request to license portal.")
    @PostMapping(value={"/license/checkInstance"})
    public ResponseEntity<JsonNode> checkInstance(@RequestBody JsonNode request) throws ThingsboardException {
        log.debug("Checking instance [{}]", (Object)request);
        try {
            return this.edgeLicenseService.checkInstance(request);
        }
        catch (Exception e) {
            log.error("Error occurred: [{}]", (Object)e.getMessage(), (Object)e);
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.SUBSCRIPTION_VIOLATION);
        }
    }

    @ApiOperation(value="Activate edge instance (activateInstance)", notes="Activates edge license on license portal.")
    @PostMapping(value={"/license/activateInstance"}, params={"licenseSecret", "releaseDate"})
    public ResponseEntity<JsonNode> activateInstance(@RequestParam String licenseSecret, @RequestParam String releaseDate) throws ThingsboardException {
        log.debug("Activating instance [{}], [{}]", (Object)licenseSecret, (Object)releaseDate);
        try {
            return this.edgeLicenseService.activateInstance(licenseSecret, releaseDate);
        }
        catch (Exception e) {
            log.error("Error occurred: [{}]", (Object)e.getMessage(), (Object)e);
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.SUBSCRIPTION_VIOLATION);
        }
    }

    private void cleanUpLicenseKey(Edge edge) {
        edge.setEdgeLicenseKey(null);
    }

    private boolean hasPermissionEdgeCreateOrWrite(SecurityUser user) throws ThingsboardException {
        return this.accessControlService.hasPermission(user, Resource.EDGE, Operation.CREATE) || this.accessControlService.hasPermission(user, Resource.EDGE, Operation.WRITE);
    }

    @ApiOperation(value="Get Edge Install Instructions (getEdgeInstallInstructions)", notes="Get an install instructions for provided edge id.If the user has the authority of 'Tenant Administrator', the server checks that the edge is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the edge is assigned to the same customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/instructions/install/{edgeId}/{method}"})
    public EdgeInstructions getEdgeInstallInstructions(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Installation method ('docker', 'ubuntu' or 'centos')", schema=@Schema(allowableValues={"docker", "ubuntu", "centos"})) @PathVariable(value="method") String installationMethod, HttpServletRequest request) throws ThingsboardException {
        if (this.isEdgesEnabled() && this.edgeInstallServiceOpt.isPresent()) {
            EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
            edgeId = (EdgeId)this.checkNotNull((Object)edgeId);
            Edge edge = this.checkEdgeId(edgeId, Operation.READ);
            return (EdgeInstructions)this.checkNotNull((Object)((EdgeInstallInstructionsService)this.edgeInstallServiceOpt.get()).getInstallInstructions(edge, installationMethod, request));
        }
        throw new ThingsboardException("Edges support disabled", ThingsboardErrorCode.GENERAL);
    }

    @ApiOperation(value="Get Edge Upgrade Instructions (getEdgeUpgradeInstructions)", notes="Get an upgrade instructions for provided edge version.If the user has the authority of 'Tenant Administrator', the server checks that the edge is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the edge is assigned to the same customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/instructions/upgrade/{edgeVersion}/{method}"})
    public EdgeInstructions getEdgeUpgradeInstructions(@Parameter(description="Edge version", required=true) @PathVariable(value="edgeVersion") String edgeVersion, @Parameter(description="Upgrade method ('docker', 'ubuntu' or 'centos')", schema=@Schema(allowableValues={"docker", "ubuntu", "centos"})) @PathVariable(value="method") String method) throws Exception {
        if (this.isEdgesEnabled() && this.edgeUpgradeServiceOpt.isPresent()) {
            return (EdgeInstructions)this.checkNotNull((Object)((EdgeUpgradeInstructionsService)this.edgeUpgradeServiceOpt.get()).getUpgradeInstructions(edgeVersion, method));
        }
        throw new ThingsboardException("Edges support disabled", ThingsboardErrorCode.GENERAL);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/settings"})
    public EdgeSettings getEdgeSettings() throws ThingsboardException {
        try {
            return (EdgeSettings)this.checkNotNull((Object)this.edgeSettingsService.findEdgeSettings());
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/events"})
    public PageData<CloudEvent> getCloudEvents(@RequestParam int pageSize, @RequestParam int page, @RequestParam(required=false) String textSearch, @RequestParam(required=false) String sortProperty, @RequestParam(required=false) String sortOrder, @RequestParam(required=false) Long startTime, @RequestParam(required=false) Long endTime) throws ThingsboardException {
        try {
            TenantId tenantId = this.getCurrentUser().getTenantId();
            TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
            return (PageData)this.checkNotNull((Object)this.cloudEventService.findCloudEvents(tenantId, Long.valueOf(0L), null, pageLink));
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/edge/events/timeseries"})
    public PageData<CloudEvent> getTimeseriesCloudEvents(@RequestParam int pageSize, @RequestParam int page, @RequestParam(required=false) String textSearch, @RequestParam(required=false) String sortProperty, @RequestParam(required=false) String sortOrder, @RequestParam(required=false) Long startTime, @RequestParam(required=false) Long endTime) throws ThingsboardException {
        try {
            TenantId tenantId = this.getCurrentUser().getTenantId();
            TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
            return (PageData)this.checkNotNull((Object)this.cloudEventService.findTsKvCloudEvents(tenantId, Long.valueOf(0L), null, pageLink));
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @ApiOperation(value="Is edge upgrade enabled (isEdgeUpgradeAvailable)", notes="Returns 'true' if upgrade available for connected edge, 'false' - otherwise.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/{edgeId}/upgrade/available"})
    public boolean isEdgeUpgradeAvailable(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId) throws Exception {
        if (this.isEdgesEnabled() && this.edgeUpgradeServiceOpt.isPresent()) {
            EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
            edgeId = (EdgeId)this.checkNotNull((Object)edgeId);
            Edge edge = this.checkEdgeId(edgeId, Operation.READ);
            return ((EdgeUpgradeInstructionsService)this.edgeUpgradeServiceOpt.get()).isUpgradeAvailable(edge.getTenantId(), edge.getId());
        }
        throw new ThingsboardException("Edges support disabled", ThingsboardErrorCode.GENERAL);
    }

    @ConstructorProperties(value={"edgeBulkImportService", "tbEdgeService", "edgeRpcServiceOpt", "edgeInstallServiceOpt", "edgeUpgradeServiceOpt"})
    @Generated
    public EdgeController(EdgeBulkImportService edgeBulkImportService, TbEdgeService tbEdgeService, Optional<EdgeRpcService> edgeRpcServiceOpt, Optional<EdgeInstallInstructionsService> edgeInstallServiceOpt, Optional<EdgeUpgradeInstructionsService> edgeUpgradeServiceOpt) {
        this.edgeBulkImportService = edgeBulkImportService;
        this.tbEdgeService = tbEdgeService;
        this.edgeRpcServiceOpt = edgeRpcServiceOpt;
        this.edgeInstallServiceOpt = edgeInstallServiceOpt;
        this.edgeUpgradeServiceOpt = edgeUpgradeServiceOpt;
    }
}

