/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DeviceGroupOtaPackageController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceGroupOtaPackageController.class);

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/deviceGroupOtaPackage/{groupId}/{firmwareType}"})
    public DeviceGroupOtaPackage getFirmwareById(@PathVariable(value="groupId") String strGroupId, @PathVariable(value="firmwareType") String strFirmwareType) throws ThingsboardException {
        this.checkParameter("groupId", strGroupId);
        this.checkParameter("firmwareType", strFirmwareType);
        EntityGroupId groupId = new EntityGroupId(this.toUUID(strGroupId));
        this.checkEntityGroupId(groupId, Operation.READ);
        return this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupIdAndType(groupId, OtaPackageType.valueOf((String)strFirmwareType));
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/deviceGroupOtaPackage"})
    public DeviceGroupOtaPackage saveDeviceGroupOtaPackage(@RequestBody DeviceGroupOtaPackage deviceGroupOtaPackage) throws Exception {
        this.checkEntityGroupId(deviceGroupOtaPackage.getGroupId(), Operation.WRITE);
        return this.tbDeviceGroupOtaPackageService.saveDeviceGroupOtaPackage(this.getTenantId(), deviceGroupOtaPackage, (User)this.getCurrentUser());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/deviceGroupOtaPackage/{id}"})
    public void deleteDeviceGroupOtaPackage(@PathVariable(value="id") String strId) throws ThingsboardException {
        this.checkParameter("deviceGroupOtaPackageId", strId);
        UUID id = this.toUUID(strId);
        DeviceGroupOtaPackage deviceGroupOtaPackage = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageById(id);
        this.checkEntityGroupId(deviceGroupOtaPackage.getGroupId(), Operation.WRITE);
        this.tbDeviceGroupOtaPackageService.deleteDeviceGroupOtaPackage(this.getTenantId(), deviceGroupOtaPackage);
    }
}

