/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.server.common.data.ClaimRequest;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceInfo;
import org.thingsboard.server.common.data.DeviceInfoFilter;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.SaveDeviceWithCredentialsRequest;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportRequest;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportResult;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.device.DeviceBulkImportService;
import org.thingsboard.server.service.entitiy.device.TbDeviceService;
import org.thingsboard.server.service.gateway_device.GatewayNotificationsService;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DeviceController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceController.class);
    protected static final String DEVICE_NAME = "deviceName";
    protected static final String RBAC_READ_CREDENTIALS_CHECK = " Security check is performed to verify that the user has 'READ_CREDENTIALS' permission for the entity (entities).";
    protected static final String RBAC_WRITE_CREDENTIALS_CHECK = " Security check is performed to verify that the user has 'WRITE_CREDENTIALS' permission for the entity (entities).";
    protected static final String RBAC_CLAIM_CHECK = " Security check is performed to verify that the user has 'CLAIM_DEVICES' permission for the entity (entities).";
    protected static final String RBAC_ASSIGN_TO_TENANT_CHECK = " Security check is performed to verify that the user has 'ASSIGN_TO_TENANT' permission for the entity (entities).";
    private final DeviceBulkImportService deviceBulkImportService;
    private final GatewayNotificationsService gatewayNotificationsService;
    private final TbDeviceService tbDeviceService;

    @ApiOperation(value="Get Device (getDeviceById)", notes="Fetch the Device object based on the provided Device Id. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device/{deviceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Device getDeviceById(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String strDeviceId) throws ThingsboardException {
        this.checkParameter("deviceId", strDeviceId);
        DeviceId deviceId = new DeviceId(this.toUUID(strDeviceId));
        return this.checkDeviceId(deviceId, Operation.READ);
    }

    @ApiOperation(value="Get Device (getDeviceInfoById)", notes="Fetch the Device info object based on the provided Device Id. Device Info is an extension of the default Device object that contains information about the owner name. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device/info/{deviceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public DeviceInfo getDeviceInfoById(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String strDeviceId) throws ThingsboardException {
        this.checkParameter("deviceId", strDeviceId);
        DeviceId deviceId = new DeviceId(this.toUUID(strDeviceId));
        return this.checkDeviceInfoId(deviceId, Operation.READ);
    }

    @ApiOperation(value="Create Or Update Device (saveDevice)", notes="Create or update the Device. When creating device, platform generates Device Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). Device credentials are also generated if not provided in the 'accessToken' request parameter. The newly created device id will be present in the response. Specify existing Device id to update the device. Referencing non-existing device Id will cause 'Not Found' error.\n\nDevice name is unique in the scope of tenant. Use unique identifiers like MAC or IMEI for the device names and non-unique 'label' field for user-friendly visualization purposes.Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Device entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device"}, method={RequestMethod.POST})
    @ResponseBody
    public Device saveDevice(@RequestBody(description="A JSON value representing the device.", required=true) @org.springframework.web.bind.annotation.RequestBody Device device, @Parameter(description="Optional value of the device credentials to be used during device creation. If omitted, access token will be auto-generated.") @RequestParam(name="accessToken", required=false) String accessToken, @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of entity group ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        return (Device)this.saveGroupEntity((GroupEntity)device, strEntityGroupId, strEntityGroupIds, (device1, entityGroups) -> {
            try {
                return this.tbDeviceService.save(device1, accessToken, entityGroups, (User)user);
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
        });
    }

    @ApiOperation(value="Create Device (saveDevice) with credentials ", notes="Create or update the Device. When creating device, platform generates Device Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). Requires to provide the Device Credentials object as well as an existing device profile ID or use \"default\".\nYou may find the example of device with different type of credentials below: \n\n- Credentials type: <b>\"Access token\"</b> with <b>device profile ID</b> below: \n\n```json\n{\n  \"device\": {\n    \"name\":\"Name_DeviceWithCredantial_AccessToken\",\n    \"label\":\"Label_DeviceWithCredantial_AccessToken\",\n    \"deviceProfileId\":{\n      \"id\":\"5636aba0-1022-11ee-9631-51fb57f69174\",\n      \"entityType\":\"DEVICE_PROFILE\"\n     }\n   },\n  \"credentials\": {\n    \"credentialsType\": \"ACCESS_TOKEN\",\n    \"credentialsId\": \"6hmxew8pmmzng4e3une2\"\n   }\n}\n```\n\n- Credentials type: <b>\"Access token\"</b> with  <b>device profile default</b> below: \n\n```json\n{\n  \"device\": {\n    \"name\":\"Name_DeviceWithCredantial_AccessToken_Default\",\n    \"label\":\"Label_DeviceWithCredantial_AccessToken_Default\",\n    \"type\": \"default\"\n   },\n  \"credentials\": {\n    \"credentialsType\": \"ACCESS_TOKEN\",\n    \"credentialsId\": \"6hmxew8pmmzng4e3une3\"\n   }\n}\n```\n\n- Credentials type: <b>\"X509\"</b> with <b>device profile ID</b> below: \n\nNote: <b>credentialsId</b> -  format <b>Sha3Hash</b>, <b>certificateValue</b> - format <b>PEM</b> (with \"--BEGIN CERTIFICATE----\" and  -\"----END CERTIFICATE-\").\n\n```json\n{\n  \"device\": {\n    \"name\":\"Name_DeviceWithCredantial_X509_Certificate\",\n    \"label\":\"Label_DeviceWithCredantial_X509_Certificate\",\n    \"deviceProfileId\":{\n      \"id\":\"9d9588c0-06c9-11ee-b618-19be30fdeb60\",\n      \"entityType\":\"DEVICE_PROFILE\"\n     }\n   },\n  \"credentials\": {\n    \"credentialsType\": \"X509_CERTIFICATE\",\n    \"credentialsId\": \"84f5911765abba1f96bf4165604e9e90338fc6214081a8e623b6ff9669aedb27\",\n    \"credentialsValue\": \"-----BEGIN CERTIFICATE----- MIICMTCCAdegAwIBAgIUI9dBuwN6pTtK6uZ03rkiCwV4wEYwCgYIKoZIzj0EAwIwbjELMAkGA1UEBhMCVVMxETAPBgNVBAgMCE5ldyBZb3JrMRowGAYDVQQKDBFUaGluZ3NCb2FyZCwgSW5jLjEwMC4GA1UEAwwnZGV2aWNlQ2VydGlmaWNhdGVAWDUwOVByb3Zpc2lvblN0cmF0ZWd5MB4XDTIzMDMyOTE0NTYxN1oXDTI0MDMyODE0NTYxN1owbjELMAkGA1UEBhMCVVMxETAPBgNVBAgMCE5ldyBZb3JrMRowGAYDVQQKDBFUaGluZ3NCb2FyZCwgSW5jLjEwMC4GA1UEAwwnZGV2aWNlQ2VydGlmaWNhdGVAWDUwOVByb3Zpc2lvblN0cmF0ZWd5MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE9Zo791qKQiGNBm11r4ZGxh+w+ossZL3xc46ufq5QckQHP7zkD2XDAcmP5GvdkM1sBFN9AWaCkQfNnWmfERsOOKNTMFEwHQYDVR0OBBYEFFFc5uyCyglQoZiKhzXzMcQ3BKORMB8GA1UdIwQYMBaAFFFc5uyCyglQoZiKhzXzMcQ3BKORMA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwIDSAAwRQIhANbA9CuhoOifZMMmqkpuld+65CR+ItKdXeRAhLMZuccuAiB0FSQB34zMutXrZj1g8Gl5OkE7YryFHbei1z0SveHR8g== -----END CERTIFICATE-----\"\n   }\n}\n```\n\n- Credentials type: <b>\"MQTT_BASIC\"</b> with <b>device profile ID</b> below: \n\n```json\n{\n  \"device\": {\n    \"name\":\"Name_DeviceWithCredantial_MQTT_Basic\",\n    \"label\":\"Label_DeviceWithCredantial_MQTT_Basic\",\n    \"deviceProfileId\":{\n      \"id\":\"9d9588c0-06c9-11ee-b618-19be30fdeb60\",\n      \"entityType\":\"DEVICE_PROFILE\"\n     }\n   },\n  \"credentials\": {\n    \"credentialsType\": \"MQTT_BASIC\",\n    \"credentialsValue\": \"{\\\"clientId\\\":\\\"5euh5nzm34bjjh1efmlt\\\",\\\"userName\\\":\\\"onasd1lgwasmjl7v2v7h\\\",\\\"password\\\":\\\"b9xtm4ny8kt9zewaga5o\\\"}\"\n   }\n}\n```\n\n- You may find the example of <b>LwM2M</b> device and <b>RPK</b> credentials below: \n\nNote: LwM2M device - only existing device profile ID (Transport configuration -> Transport type: \"LWM2M\".\n\n```json\n{\n  \"device\": {\n    \"name\":\"Name_LwRpk00000000\",\n    \"label\":\"Label_LwRpk00000000\",\n    \"deviceProfileId\":{\n      \"id\":\"a660bd50-10ef-11ee-8737-b5634e73c779\",\n      \"entityType\":\"DEVICE_PROFILE\"\n     }\n   },\n  \"credentials\": {\n    \"credentialsType\": \"LWM2M_CREDENTIALS\",\n    \"credentialsId\": \"LwRpk00000000\",\n    \"credentialsValue\":\n       \"{\\\"client\\\":{ \\\"endpoint\\\":\\\"LwRpk00000000\\\", \\\"securityConfigClientMode\\\":\\\"RPK\\\", \\\"key\\\":\\\"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEUEBxNl/RcYJNm8mk91CyVXoIJiROYDlXcSSqK6e5bDHwOW4ZiN2lNnXalyF0Jxw8MbAytnDMERXyAja5VEMeVQ==\\\"   }, \\\"bootstrap\\\":{ \\\"bootstrapServer\\\":{ \\\"securityMode\\\":\\\"RPK\\\", \\\"clientPublicKeyOrId\\\":\\\"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEUEBxNl/RcYJNm8mk91CyVXoIJiROYDlXcSSqK6e5bDHwOW4ZiN2lNnXalyF0Jxw8MbAytnDMERXyAja5VEMeVQ==\\\", \\\"clientSecretKey\\\":\\\"MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgd9GAx7yZW37autew5KZykn4IgRpge/tZSjnudnZJnMahRANCAARQQHE2X9Fxgk2byaT3ULJVeggmJE5gOVdxJKorp7lsMfA5bhmI3aU2ddqXIXQnHDwxsDK2cMwRFfICNrlUQx5V\\\"}, \\\"lwm2mServer\\\":{ \\\"securityMode\\\":\\\"RPK\\\", \\\"clientPublicKeyOrId\\\":\\\"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEUEBxNl/RcYJNm8mk91CyVXoIJiROYDlXcSSqK6e5bDHwOW4ZiN2lNnXalyF0Jxw8MbAytnDMERXyAja5VEMeVQ==\\\", \\\"clientSecretKey\\\":\\\"MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgd9GAx7yZW37autew5KZykn4IgRpge/tZSjnudnZJnMahRANCAARQQHE2X9Fxgk2byaT3ULJVeggmJE5gOVdxJKorp7lsMfA5bhmI3aU2ddqXIXQnHDwxsDK2cMwRFfICNrlUQx5V\\\"}} }\"\n   }\n}\n```\n\nRemove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Device entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device-with-credentials"}, method={RequestMethod.POST})
    @ResponseBody
    public Device saveDeviceWithCredentials(@Parameter(description="The JSON object with device and credentials. See method description above for example.") @Valid @org.springframework.web.bind.annotation.RequestBody SaveDeviceWithCredentialsRequest deviceAndCredentials, @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of entity group ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds) throws ThingsboardException {
        Device device = deviceAndCredentials.getDevice();
        DeviceCredentials credentials = deviceAndCredentials.getCredentials();
        SecurityUser user = this.getCurrentUser();
        return (Device)this.saveGroupEntity((GroupEntity)device, strEntityGroupId, strEntityGroupIds, (device1, entityGroup) -> this.tbDeviceService.saveDeviceWithCredentials(device1, credentials, entityGroup, (User)user));
    }

    @ApiOperation(value="Delete device (deleteDevice)", notes="Deletes the device, it's credentials and all the relations (from and to the device). Referencing non-existing device Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device/{deviceId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteDevice(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String strDeviceId) throws Exception {
        this.checkParameter("deviceId", strDeviceId);
        DeviceId deviceId = new DeviceId(this.toUUID(strDeviceId));
        Device device = this.checkDeviceId(deviceId, Operation.DELETE);
        this.tbDeviceService.delete(device, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Device Credentials (getDeviceCredentialsByDeviceId)", notes="If during device creation there wasn't specified any credentials, platform generates random 'ACCESS_TOKEN' credentials.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ_CREDENTIALS' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device/{deviceId}/credentials"}, method={RequestMethod.GET})
    @ResponseBody
    public DeviceCredentials getDeviceCredentialsByDeviceId(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String strDeviceId) throws ThingsboardException {
        this.checkParameter("deviceId", strDeviceId);
        DeviceId deviceId = new DeviceId(this.toUUID(strDeviceId));
        Device device = this.checkDeviceId(deviceId, Operation.READ_CREDENTIALS);
        return this.tbDeviceService.getDeviceCredentialsByDeviceId(device, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Update device credentials (updateDeviceCredentials)", notes="During device creation, platform generates random 'ACCESS_TOKEN' credentials.\nUse this method to update the device credentials. First use 'getDeviceCredentialsByDeviceId' to get the credentials id and value.\nThen use current method to update the credentials type and value. It is not possible to create multiple device credentials for the same device.\nThe structure of device credentials id and value is simple for the 'ACCESS_TOKEN' but is much more complex for the 'MQTT_BASIC' or 'LWM2M_CREDENTIALS'.\nYou may find the example of device with different type of credentials below: \n\n- Credentials type: <b>\"Access token\"</b> with <b>device ID</b> and with <b>device ID</b> below: \n\n```json\n{\n  \"id\": {\n    \"id\":\"c886a090-168d-11ee-87c9-6f157dbc816a\"\n   },\n  \"deviceId\": {\n    \"id\":\"c5fb3ac0-168d-11ee-87c9-6f157dbc816a\",\n    \"entityType\":\"DEVICE\"\n   },\n  \"credentialsType\": \"ACCESS_TOKEN\",\n  \"credentialsId\": \"6hmxew8pmmzng4e3une4\"\n}\n```\n\n- Credentials type: <b>\"X509\"</b> with <b>device profile ID</b> below: \n\nNote: <b>credentialsId</b> -  format <b>Sha3Hash</b>, <b>certificateValue</b> - format <b>PEM</b> (with \"--BEGIN CERTIFICATE----\" and  -\"----END CERTIFICATE-\").\n\n```json\n{\n  \"id\": {\n    \"id\":\"309bd9c0-14f4-11ee-9fc9-d9b7463abb63\"\n   },\n  \"deviceId\": {\n    \"id\":\"3092b200-14f4-11ee-9fc9-d9b7463abb63\",\n    \"entityType\":\"DEVICE\"\n   },\n  \"credentialsType\": \"X509_CERTIFICATE\",\n  \"credentialsId\": \"6b8adb49015500e51a527acd332b51684ab9b49b4ade03a9582a44c455e2e9b6\",\n  \"credentialsValue\": \"-----BEGIN CERTIFICATE----- MIICMTCCAdegAwIBAgIUUEKxS9hTz4l+oLUMF0LV6TC/gCIwCgYIKoZIzj0EAwIwbjELMAkGA1UEBhMCVVMxETAPBgNVBAgMCE5ldyBZb3JrMRowGAYDVQQKDBFUaGluZ3NCb2FyZCwgSW5jLjEwMC4GA1UEAwwnZGV2aWNlUHJvZmlsZUNlcnRAWDUwOVByb3Zpc2lvblN0cmF0ZWd5MB4XDTIzMDMyOTE0NTczNloXDTI0MDMyODE0NTczNlowbjELMAkGA1UEBhMCVVMxETAPBgNVBAgMCE5ldyBZb3JrMRowGAYDVQQKDBFUaGluZ3NCb2FyZCwgSW5jLjEwMC4GA1UEAwwnZGV2aWNlUHJvZmlsZUNlcnRAWDUwOVByb3Zpc2lvblN0cmF0ZWd5MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAECMlWO72krDoUL9FQjUmSCetkhaEGJUfQkdSfkLSNa0GyAEIMbfmzI4zITeapunu4rGet3EMyLydQzuQanBicp6NTMFEwHQYDVR0OBBYEFHpZ78tPnztNii4Da/yCw6mhEIL3MB8GA1UdIwQYMBaAFHpZ78tPnztNii4Da/yCw6mhEIL3MA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwIDSAAwRQIgJ7qyMFqNcwSYkH6o+UlQXzLWfwZbNjVk+aR7foAZNGsCIQDsd7v3WQIGHiArfZeDs1DLEDuV/2h6L+ZNoGNhEKL+1A== -----END CERTIFICATE-----\"\n}\n```\n\n- Credentials type: <b>\"MQTT_BASIC\"</b> with <b>device profile ID</b> below: \n\n```json\n{\n  \"id\": {\n    \"id\":\"d877ffb0-14f5-11ee-9fc9-d9b7463abb63\"\n   },\n  \"deviceId\": {\n    \"id\":\"d875dcd0-14f5-11ee-9fc9-d9b7463abb63\",\n    \"entityType\":\"DEVICE\"\n   },\n  \"credentialsType\": \"MQTT_BASIC\",\n  \"credentialsValue\": \"{\\\"clientId\\\":\\\"juy03yv4owqxcmqhqtvk\\\",\\\"userName\\\":\\\"ov19fxca0cyjn7lm7w7u\\\",\\\"password\\\":\\\"twy94he114dfi9usyk1o\\\"}\"\n}\n```\n\n- You may find the example of <b>LwM2M</b> device and <b>RPK</b> credentials below: \n\nNote: LwM2M device - only existing device profile ID (Transport configuration -> Transport type: \"LWM2M\".\n\n```json\n{\n  \"id\": {\n    \"id\":\"e238d4d0-1689-11ee-98c6-1713c1be5a8e\"\n   },\n  \"deviceId\": {\n    \"id\":\"e232e160-1689-11ee-98c6-1713c1be5a8e\",\n    \"entityType\":\"DEVICE\"\n   },\n  \"credentialsType\": \"LWM2M_CREDENTIALS\",\n  \"credentialsId\": \"LwRpk00000000\",\n  \"credentialsValue\":\n       \"{\\\"client\\\":{ \\\"endpoint\\\":\\\"LwRpk00000000\\\", \\\"securityConfigClientMode\\\":\\\"RPK\\\", \\\"key\\\":\\\"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEdvBZZ2vQRK9wgDhctj6B1c7bxR3Z0wYg1+YdoYFnVUKWb+rIfTTyYK9tmQJx5Vlb5fxdLnVv1RJOPiwsLIQbAA==\\\"   }, \\\"bootstrap\\\":{ \\\"bootstrapServer\\\":{ \\\"securityMode\\\":\\\"RPK\\\", \\\"clientPublicKeyOrId\\\":\\\"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEUEBxNl/RcYJNm8mk91CyVXoIJiROYDlXcSSqK6e5bDHwOW4ZiN2lNnXalyF0Jxw8MbAytnDMERXyAja5VEMeVQ==\\\", \\\"clientSecretKey\\\":\\\"MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgd9GAx7yZW37autew5KZykn4IgRpge/tZSjnudnZJnMahRANCAARQQHE2X9Fxgk2byaT3ULJVeggmJE5gOVdxJKorp7lsMfA5bhmI3aU2ddqXIXQnHDwxsDK2cMwRFfICNrlUQx5V\\\"}, \\\"lwm2mServer\\\":{ \\\"securityMode\\\":\\\"RPK\\\", \\\"clientPublicKeyOrId\\\":\\\"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEUEBxNl/RcYJNm8mk91CyVXoIJiROYDlXcSSqK6e5bDHwOW4ZiN2lNnXalyF0Jxw8MbAytnDMERXyAja5VEMeVQ==\\\", \\\"clientSecretKey\\\":\\\"MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgd9GAx7yZW37autew5KZykn4IgRpge/tZSjnudnZJnMahRANCAARQQHE2X9Fxgk2byaT3ULJVeggmJE5gOVdxJKorp7lsMfA5bhmI3aU2ddqXIXQnHDwxsDK2cMwRFfICNrlUQx5V\\\"}} }\"\n}\n```\n\nUpdate to real value:\n - 'id' (this is id of Device Credentials ->  \"Get Device Credentials (getDeviceCredentialsByDeviceId)\",\n - 'deviceId.id' (this is id of Device).\nRemove 'tenantId' and optionally 'customerId' from the request body example (below) to create new Device entity.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device/credentials"}, method={RequestMethod.POST})
    @ResponseBody
    public DeviceCredentials updateDeviceCredentials(@Parameter(description="A JSON value representing the device credentials.") @org.springframework.web.bind.annotation.RequestBody DeviceCredentials deviceCredentials) throws ThingsboardException {
        this.checkNotNull((Object)deviceCredentials);
        Device device = this.checkDeviceId(deviceCredentials.getDeviceId(), Operation.WRITE_CREDENTIALS);
        return this.tbDeviceService.updateDeviceCredentials(device, deviceCredentials, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Devices (getTenantDevices)", notes="Returns a page of devices owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/devices"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Device> getTenantDevices(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Device type as the name of the device profile") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the device name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deviceProfileName", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DEVICE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.deviceService.findDevicesByTenantIdAndType(tenantId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.deviceService.findDevicesByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Device (getTenantDevice)", notes="Requested device must be owned by tenant that the user belongs to. Device name is an unique property of device. So it can be used to identify the device.\n\nAvailable for users with 'TENANT_ADMIN' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/devices"}, params={"deviceName"}, method={RequestMethod.GET})
    @ResponseBody
    public Device getTenantDevice(@Parameter(description="A string value representing the Device name.") @RequestParam String deviceName) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DEVICE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (Device)this.checkNotNull((Object)this.deviceService.findDeviceByTenantIdAndName(tenantId, deviceName));
    }

    @ApiOperation(value="Get Customer Devices (getCustomerDevices)", notes="Returns a page of devices objects assigned to customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/devices"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Device> getCustomerDevices(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Device type as the name of the device profile") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the device name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deviceProfileName", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DEVICE, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.deviceService.findDevicesByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.deviceService.findDevicesByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Devices (getUserDevices)", notes="Returns a page of devices that are available for the current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/devices"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Device> getUserDevices(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="Device type as the name of the device profile") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the device name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deviceProfileName", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        return this.entityService.findUserEntities(currentUser.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, EntityType.DEVICE, Operation.READ, type, pageLink);
    }

    @ApiOperation(value="Get All Device Infos for current user (getAllDeviceInfos)", notes="Returns a page of device info objects owned by the tenant or the customer of a current user. Device Info is an extension of the default Device object that contains information about the owner name.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/deviceInfos/all"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DeviceInfo> getAllDeviceInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String deviceProfileId, @Parameter(description="A boolean value representing the device active flag.") @RequestParam(required=false) Boolean active, @Parameter(description="The case insensitive 'substring' filter based on the device name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deviceProfileName", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DEVICE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        DeviceInfoFilter.DeviceInfoFilterBuilder filter = DeviceInfoFilter.builder();
        filter.tenantId(tenantId);
        filter.active(active);
        filter.includeCustomers(includeCustomers != null && includeCustomers != false);
        if (deviceProfileId != null && deviceProfileId.length() > 0) {
            filter.deviceProfileId(new DeviceProfileId(this.toUUID(deviceProfileId)));
        }
        if (Authority.CUSTOMER_USER.equals((Object)this.getCurrentUser().getAuthority())) {
            filter.customerId(this.getCurrentUser().getCustomerId());
        }
        return (PageData)this.checkNotNull((Object)this.deviceService.findDeviceInfosByFilter(filter.build(), pageLink));
    }

    @ApiOperation(value="Get Customer Device Infos (getCustomerDeviceInfos)", notes="Returns a page of device info objects owned by the specified customer. Device Info is an extension of the default Device object that contains information about the owner name.  You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/deviceInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DeviceInfo> getCustomerDeviceInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String deviceProfileId, @Parameter(description="A boolean value representing the device active flag.") @RequestParam(required=false) Boolean active, @Parameter(description="The case insensitive 'substring' filter based on the device name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deviceProfileName", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DEVICE, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        DeviceInfoFilter.DeviceInfoFilterBuilder filter = DeviceInfoFilter.builder();
        filter.tenantId(tenantId);
        filter.active(active);
        filter.includeCustomers(includeCustomers != null && includeCustomers != false);
        filter.customerId(customerId);
        if (deviceProfileId != null && deviceProfileId.length() > 0) {
            filter.deviceProfileId(new DeviceProfileId(this.toUUID(deviceProfileId)));
        }
        return (PageData)this.checkNotNull((Object)this.deviceService.findDeviceInfosByFilter(filter.build(), pageLink));
    }

    @ApiOperation(value="Get Devices By Ids (getDevicesByIds)", notes="Requested devices must be owned by tenant or assigned to customer which user is performing the request. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/devices"}, params={"deviceIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Device> getDevicesByIds(@Parameter(description="A list of devices ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(value="deviceIds") String[] strDeviceIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("deviceIds", strDeviceIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<DeviceId> deviceIds = new ArrayList<DeviceId>();
        for (String strDeviceId : strDeviceIds) {
            deviceIds.add(new DeviceId(this.toUUID(strDeviceId)));
        }
        List devices = (List)this.checkNotNull((Object)((List)this.deviceService.findDevicesByTenantIdAndIdsAsync(tenantId, deviceIds).get()));
        return this.filterDevicesByReadPermission(devices);
    }

    @ApiOperation(value="Find related devices (findByQuery)", notes="Returns all devices that are related to the specific entity. The entity id, relation type, device types, depth of the search, and other query parameters defined using complex 'DeviceSearchQuery' object. See 'Model' tab of the Parameters for more info.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/devices"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Device> findByQuery(@Parameter(description="The device search query JSON") @org.springframework.web.bind.annotation.RequestBody DeviceSearchQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query);
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getDeviceTypes());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        List devices = (List)this.checkNotNull((Object)((List)this.deviceService.findDevicesByQuery(this.getCurrentUser().getTenantId(), query).get()));
        return this.filterDevicesByReadPermission(devices);
    }

    @ApiOperation(value="Get devices by Entity Group Id (getDevicesByEntityGroupId)", notes="Returns a page of Device objects that belongs to specified Entity Group Id. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityGroup/{entityGroupId}/devices"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Device> getDevicesByEntityGroupId(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the device name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "deviceProfileName", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("entityGroupId", strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.checkEntityGroupType(EntityType.DEVICE, entityGroup.getType());
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.deviceService.findDevicesByEntityGroupId(entityGroupId, pageLink));
    }

    private List<Device> filterDevicesByReadPermission(List<Device> devices) {
        return devices.stream().filter(device -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.DEVICE, Operation.READ, (EntityId)device.getId(), (TenantEntity)device);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    @ApiOperation(value="Get Device Types (getDeviceTypes)", notes="Deprecated. See 'getDeviceProfileNames' API from Device Profile Controller instead.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/device/types"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated(since="3.6.2")
    public List<EntitySubtype> getDeviceTypes() throws ThingsboardException, ExecutionException, InterruptedException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ListenableFuture deviceTypes = this.deviceService.findDeviceTypesByTenantId(tenantId);
        return (List)this.checkNotNull((Object)((List)deviceTypes.get()));
    }

    @ApiOperation(value="Claim device (claimDevice)", notes="Claiming makes it possible to assign a device to the specific customer using device/server side claiming data (in the form of secret key).To make this happen you have to provide unique device name and optional claiming data (it is needed only for device-side claiming).Once device is claimed, the customer becomes its owner and customer users may access device data as well as control the device. \nIn order to enable claiming devices feature a system parameter security.claim.allowClaimingByDefault should be set to true, otherwise a server-side claimingAllowed attribute with the value true is obligatory for provisioned devices. \nSee official documentation for more details regarding claiming.\n\nAvailable for users with 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'CLAIM_DEVICES' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('CUSTOMER_USER')")
    @RequestMapping(value={"/customer/device/{deviceName}/claim"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> claimDevice(@Parameter(description="Unique name of the device which is going to be claimed") @PathVariable(value="deviceName") String deviceName, @Parameter(description="Claiming request which can optionally contain secret key") @org.springframework.web.bind.annotation.RequestBody(required=false) ClaimRequest claimRequest, @RequestParam(required=false) String subCustomerId) throws ThingsboardException {
        CustomerId customerId;
        this.checkParameter(DEVICE_NAME, deviceName);
        DeferredResult deferredResult = new DeferredResult();
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        CustomerId parentCustomerId = user.getCustomerId();
        Device device = (Device)this.checkNotNull((Object)this.deviceService.findDeviceByTenantIdAndName(tenantId, deviceName));
        this.accessControlService.checkPermission(user, Resource.DEVICE, Operation.CLAIM_DEVICES, (EntityId)device.getId(), (TenantEntity)device);
        String secretKey = this.getSecretKey(claimRequest);
        if (StringUtils.isEmpty((String)subCustomerId)) {
            customerId = parentCustomerId;
        } else {
            Customer subCustomer = (Customer)this.checkNotNull((Object)this.customerService.findCustomerById(tenantId, new CustomerId(UUID.fromString(subCustomerId))));
            customerId = subCustomer.getId();
            if (!this.ownersCacheService.isChildOwner(tenantId, parentCustomerId, customerId)) {
                throw new ThingsboardException("Requested sub-customer wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
            }
        }
        ListenableFuture future = this.tbDeviceService.claimDevice(tenantId, device, customerId, secretKey, (User)user);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        return deferredResult;
    }

    @ApiOperation(value="Reclaim device (reClaimDevice)", notes="Reclaiming means the device will be unassigned from the customer and the device will be available for claiming again.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'CLAIM_DEVICES' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/device/{deviceName}/claim"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public DeferredResult<ResponseEntity> reClaimDevice(@Parameter(description="Unique name of the device which is going to be reclaimed") @PathVariable(value="deviceName") String deviceName) throws ThingsboardException {
        this.checkParameter(DEVICE_NAME, deviceName);
        DeferredResult deferredResult = new DeferredResult();
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        Device device = (Device)this.checkNotNull((Object)this.deviceService.findDeviceByTenantIdAndName(tenantId, deviceName));
        this.accessControlService.checkPermission(user, Resource.DEVICE, Operation.CLAIM_DEVICES, (EntityId)device.getId(), (TenantEntity)device);
        ListenableFuture result = this.tbDeviceService.reclaimDevice(tenantId, device, (User)user);
        Futures.addCallback((ListenableFuture)result, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        return deferredResult;
    }

    private String getSecretKey(ClaimRequest claimRequest) {
        String secretKey = claimRequest.getSecretKey();
        if (secretKey != null) {
            return secretKey;
        }
        return "";
    }

    @ApiOperation(value="Assign device to tenant (assignDeviceToTenant)", notes="Creates assignment of the device to tenant. Thereafter tenant will be able to reassign the device to a customer.\n\nAvailable for users with 'TENANT_ADMIN' authority. Security check is performed to verify that the user has 'ASSIGN_TO_TENANT' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/{tenantId}/device/{deviceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Device assignDeviceToTenant(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="tenantId") String strTenantId, @Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String strDeviceId) throws ThingsboardException {
        this.checkParameter("tenantId", strTenantId);
        this.checkParameter("deviceId", strDeviceId);
        DeviceId deviceId = new DeviceId(this.toUUID(strDeviceId));
        Device device = this.checkDeviceId(deviceId, Operation.ASSIGN_TO_TENANT);
        TenantId newTenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        Tenant newTenant = this.tenantService.findTenantById(newTenantId);
        if (newTenant == null) {
            throw new ThingsboardException("Could not find the specified Tenant!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return this.tbDeviceService.assignDeviceToTenant(device, newTenant, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Count devices by device profile  (countByDeviceProfileAndEmptyOtaPackage)", notes="The platform gives an ability to load OTA (over-the-air) packages to devices. It can be done in two different ways: device scope or device profile scope.In the response you will find the number of devices with specified device profile, but without previously defined device scope OTA package. It can be useful when you want to define number of devices that will be affected with future OTA package\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/devices/count/{otaPackageType}/{deviceProfileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Long countByDeviceProfileAndEmptyOtaPackage(@Parameter(description="OTA package type", schema=@Schema(allowableValues={"FIRMWARE", "SOFTWARE"})) @PathVariable(value="otaPackageType") String otaPackageType, @Parameter(description="Device Profile Id. I.g. '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceProfileId") String deviceProfileId) throws ThingsboardException {
        this.checkParameter("OtaPackageType", otaPackageType);
        this.checkParameter("DeviceProfileId", deviceProfileId);
        return this.deviceService.countByDeviceProfileAndEmptyOtaPackage(this.getTenantId(), new DeviceProfileId(UUID.fromString(deviceProfileId)), OtaPackageType.valueOf((String)otaPackageType));
    }

    @ApiOperation(value="Count devices by device profile  (countByDeviceProfileAndEmptyOtaPackage)", notes="The platform gives an ability to load OTA (over-the-air) packages to devices. It can be done in two different ways: device scope or device profile scope.In the response you will find the number of devices with specified device profile, but without previously defined device scope OTA package. It can be useful when you want to define number of devices that will be affected with future OTA package\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/devices/count/{otaPackageType}/{otaPackageId}/{entityGroupId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Long countByDeviceGroupAndEmptyOtaPackage(@Parameter(description="OTA package type", schema=@Schema(allowableValues={"FIRMWARE", "SOFTWARE"})) @PathVariable(value="otaPackageType") String otaPackageType, @PathVariable(value="otaPackageId") String otaPackageId, @PathVariable(value="entityGroupId") String deviceGroupId) throws ThingsboardException {
        this.checkParameter("OtaPackageType", otaPackageType);
        this.checkParameter("OtaPackageId", otaPackageId);
        this.checkParameter("EntityGroupId", deviceGroupId);
        this.checkParameter("DeviceGroupId", deviceGroupId);
        return this.deviceService.countByEntityGroupAndEmptyOtaPackage(new EntityGroupId(UUID.fromString(deviceGroupId)), new OtaPackageId(UUID.fromString(otaPackageId)), OtaPackageType.valueOf((String)otaPackageType));
    }

    @ApiOperation(value="Import the bulk of devices (processDevicesBulkImport)", notes="There's an ability to import the bulk of devices using the only .csv file. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/device/bulk_import"})
    public BulkImportResult<Device> processDevicesBulkImport(@org.springframework.web.bind.annotation.RequestBody BulkImportRequest request) throws Exception {
        return this.deviceBulkImportService.processBulkImport(request, this.getCurrentUser(), (device, savingFunction) -> {
            try {
                this.saveGroupEntity((GroupEntity)device, request.getEntityGroupId(), savingFunction);
            }
            catch (ThingsboardException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @ConstructorProperties(value={"deviceBulkImportService", "gatewayNotificationsService", "tbDeviceService"})
    @Generated
    public DeviceController(DeviceBulkImportService deviceBulkImportService, GatewayNotificationsService gatewayNotificationsService, TbDeviceService tbDeviceService) {
        this.deviceBulkImportService = deviceBulkImportService;
        this.gatewayNotificationsService = gatewayNotificationsService;
        this.tbDeviceService = tbDeviceService;
    }
}

