/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import lombok.Generated;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.rule.engine.api.DashboardReportService;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.dashboardreport.DashboardReportConfig;
import org.thingsboard.server.common.data.dashboardreport.DashboardReportData;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.model.token.AccessJwtToken;
import org.thingsboard.server.service.security.system.SystemSecurityService;
import org.thingsboard.server.utils.MiscUtils;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DashboardReportController
extends BaseController {
    private SimpleDateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    private final DashboardReportService dashboardReportService;
    private final SystemSecurityService systemSecurityService;
    public static final String DASHBOARD_ID = "dashboardId";

    @ApiOperation(value="Download dashboard report (downloadDashboardReport)", notes="Generate and download a report from the specified dashboard. The request payload is a JSON object with params of report. For example:\n\n```json\n{\n    \"type\": \"pdf\",\n    \"timezone\": \"Europe/Kiev\",\n    \"timewindow\": {\n        \"displayValue\": \"\",\n        \"hideInterval\": false,\n        \"hideLastInterval\": false,\n        \"hideQuickInterval\": false,\n        \"hideAggregation\": false,\n        \"hideAggInterval\": false,\n        \"hideTimezone\": false,\n        \"selectedTab\": 0,\n        \"realtime\": {\n            \"realtimeType\": 0,\n            \"interval\": 1000,\n            \"timewindowMs\": 60000,\n            \"quickInterval\": \"CURRENT_DAY\"\n        },\n        \"history\": {\n            \"historyType\": 0,\n            \"interval\": 1000,\n            \"timewindowMs\": 60000,\n            \"fixedTimewindow\": {\n                \"startTimeMs\": 1703687976592,\n                \"endTimeMs\": 1703774376592\n            },\n            \"quickInterval\": \"CURRENT_DAY\"\n        },\n        \"aggregation\": {\n            \"type\": \"AVG\",\n            \"limit\": 25000\n        }\n    },\n    \"state\": null\n}\n```\n\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/report/{dashboardId}/download"}, method={RequestMethod.POST}, produces={"application/pdf", "image/jpeg", "image/png"})
    @ResponseBody
    public DeferredResult<ResponseEntity<Resource>> downloadDashboardReport(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="dashboardId") String strDashboardId, @Parameter(example="{\n    \"type\": \"pdf\",\n    \"timezone\": \"Europe/Kiev\",\n    \"timewindow\": {\n        \"displayValue\": \"\",\n        \"hideInterval\": false,\n        \"hideLastInterval\": false,\n        \"hideQuickInterval\": false,\n        \"hideAggregation\": false,\n        \"hideAggInterval\": false,\n        \"hideTimezone\": false,\n        \"selectedTab\": 0,\n        \"realtime\": {\n            \"realtimeType\": 0,\n            \"interval\": 1000,\n            \"timewindowMs\": 60000,\n            \"quickInterval\": \"CURRENT_DAY\"\n        },\n        \"history\": {\n            \"historyType\": 0,\n            \"interval\": 1000,\n            \"timewindowMs\": 60000,\n            \"fixedTimewindow\": {\n                \"startTimeMs\": 1703687976592,\n                \"endTimeMs\": 1703774376592\n            },\n            \"quickInterval\": \"CURRENT_DAY\"\n        },\n        \"aggregation\": {\n            \"type\": \"AVG\",\n            \"limit\": 25000\n        }\n    },\n    \"state\": null\n}", required=true) @RequestBody JsonNode reportParams, HttpServletRequest request) throws ThingsboardException {
        DeferredResult result = new DeferredResult();
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        try {
            AccessJwtToken accessToken;
            DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
            DashboardInfo dashboardInfo = this.checkDashboardInfoId(dashboardId, Operation.READ);
            String baseUrl = MiscUtils.constructBaseUrl((HttpServletRequest)request);
            Object name = dashboardInfo.getTitle();
            name = (String)name + "-" + this.defaultDateFormat.format(new Date());
            SecurityUser currentUser = this.getCurrentUser();
            String publicId = "";
            if (currentUser.getUserPrincipal().getType() == UserPrincipal.Type.PUBLIC_ID) {
                publicId = currentUser.getUserPrincipal().getValue();
            }
            TenantId tenantId = currentUser.getTenantId();
            if (StringUtils.isEmpty((String)publicId)) {
                accessToken = this.systemSecurityService.createUserAccessToken(tenantId, currentUser.getId());
            } else {
                accessToken = this.systemSecurityService.createUserAccessTokenFromPublicId(tenantId, publicId);
                ((ObjectNode)reportParams).put("publicId", publicId);
            }
            this.dashboardReportService.generateDashboardReport(baseUrl, dashboardId, tenantId, currentUser.getId(), (String)name, reportParams, accessToken.getToken(), accessToken.getClaims().getExpiration().getTime(), this.onSuccess(result), arg_0 -> ((DeferredResult)result).setErrorResult(arg_0));
        }
        catch (Exception e) {
            result.setErrorResult((Object)e);
        }
        return result;
    }

    @ApiOperation(value="Download test report (downloadTestReport)", notes="Generate and download test report.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/report/test"}, method={RequestMethod.POST}, produces={"application/pdf", "image/jpeg", "image/png"})
    @ResponseBody
    public DeferredResult<ResponseEntity<Resource>> downloadTestReport(@RequestBody DashboardReportConfig reportConfig, @Parameter(description="A string value representing the report server endpoint.", example="http://localhost:8383") @RequestParam(required=false) String reportsServerEndpointUrl) {
        DeferredResult result = new DeferredResult();
        try {
            String strDashboardId = reportConfig.getDashboardId();
            this.checkParameter(DASHBOARD_ID, strDashboardId);
            DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
            this.checkDashboardInfoId(dashboardId, Operation.READ);
            this.dashboardReportService.generateReport(this.getTenantId(), reportConfig, reportsServerEndpointUrl, this.onSuccess(result), arg_0 -> ((DeferredResult)result).setErrorResult(arg_0));
        }
        catch (Exception e) {
            result.setErrorResult((Object)e);
        }
        return result;
    }

    private Consumer<DashboardReportData> onSuccess(DeferredResult<ResponseEntity<Resource>> result) {
        return reportData -> {
            ByteArrayResource resource = new ByteArrayResource(reportData.getData());
            ContentDisposition cd = ContentDisposition.attachment().filename(reportData.getName(), StandardCharsets.UTF_8).build();
            ResponseEntity response = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{cd.toString()})).header("x-filename", new String[]{reportData.getName()})).contentLength(resource.contentLength()).contentType(this.parseMediaType(reportData.getContentType())).body((Object)resource);
            result.setResult((Object)response);
        };
    }

    @ConstructorProperties(value={"dashboardReportService", "systemSecurityService"})
    @Generated
    public DashboardReportController(DashboardReportService dashboardReportService, SystemSecurityService systemSecurityService) {
        this.dashboardReportService = dashboardReportService;
        this.systemSecurityService = systemSecurityService;
    }
}

