/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.CustomerInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.customer.TbCustomerService;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class CustomerController
extends BaseController {
    private final TbCustomerService tbCustomerService;
    public static final String IS_PUBLIC = "isPublic";
    public static final String CUSTOMER_SECURITY_CHECK = "If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.";

    @ApiOperation(value="Get Customer (getCustomerById)", notes="Get the Customer object based on the provided Customer Id. If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Customer getCustomerById(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        this.checkDashboardInfo(customer.getAdditionalInfo(), "homeDashboardId");
        return customer;
    }

    @ApiOperation(value="Get Customer info (getCustomerInfoById)", notes="Get the Customer info object based on the provided Customer Id. If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/info/{customerId}"}, method={RequestMethod.GET})
    @ResponseBody
    public CustomerInfo getCustomerInfoById(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        CustomerInfo customer = this.checkCustomerInfoId(customerId, Operation.READ);
        this.checkDashboardInfo(customer.getAdditionalInfo(), "homeDashboardId");
        return customer;
    }

    @ApiOperation(value="Get short Customer info (getShortCustomerInfoById)", notes="Get the short customer object that contains only the title and 'isPublic' flag. If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/shortInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonNode getShortCustomerInfoById(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        ObjectNode infoObject = JacksonUtil.newObjectNode();
        infoObject.put("title", customer.getTitle());
        infoObject.put(IS_PUBLIC, customer.isPublic());
        return infoObject;
    }

    @ApiOperation(value="Get Customer Title (getCustomerTitleById)", notes="Get the title of the customer. If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/title"}, method={RequestMethod.GET}, produces={"application/text"})
    @ResponseBody
    public String getCustomerTitleById(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        return customer.getTitle();
    }

    @ApiOperation(value="Create or update Customer (saveCustomer)", notes="Creates or Updates the Customer. When creating customer, platform generates Customer Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Customer Id will be present in the response. Specify existing Customer Id to update the Customer. Referencing non-existing Customer Id will cause 'Not Found' error.Remove 'id', 'tenantId' from the request body example (below) to create new Customer entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer"}, method={RequestMethod.POST})
    @ResponseBody
    public Customer saveCustomer(@RequestBody(description="A JSON value representing the customer.") @org.springframework.web.bind.annotation.RequestBody Customer customer, @Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'. If specified, the entity will be added to the corresponding entity group.") @RequestParam(name="entityGroupId", required=false) String strEntityGroupId, @Parameter(description="A list of string values, separated by comma ',' representing the Entity Group Ids. For example, '784f394c-42b6-435a-983c-b7beff2784f9','a84f394c-42b6-435a-083c-b7beff2784f9'. If specified, the entity will be added to the corresponding entity groups.", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="entityGroupIds", required=false) String[] strEntityGroupIds) throws ThingsboardException {
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.WHITE_LABELING, Operation.WRITE)) {
            JsonNode additionalInfo;
            Customer prevCustomer;
            JsonNode additionalInfo2;
            String prevHomeDashboardId = null;
            boolean prevHideDashboardToolbar = true;
            if (customer.getId() != null && (additionalInfo2 = (prevCustomer = this.customerService.findCustomerById(this.getTenantId(), customer.getId())).getAdditionalInfo()) != null && additionalInfo2.hasNonNull("homeDashboardId")) {
                prevHomeDashboardId = additionalInfo2.get("homeDashboardId").asText();
                if (additionalInfo2.has("homeDashboardHideToolbar")) {
                    prevHideDashboardToolbar = additionalInfo2.get("homeDashboardHideToolbar").asBoolean();
                }
            }
            if ((additionalInfo = customer.getAdditionalInfo()) == null) {
                additionalInfo = JacksonUtil.newObjectNode();
                customer.setAdditionalInfo(additionalInfo);
            }
            ((ObjectNode)additionalInfo).put("homeDashboardId", prevHomeDashboardId);
            ((ObjectNode)additionalInfo).put("homeDashboardHideToolbar", prevHideDashboardToolbar);
        }
        SecurityUser user = this.getCurrentUser();
        return (Customer)this.saveGroupEntity((GroupEntity)customer, strEntityGroupId, strEntityGroupIds, (customer1, entityGroups) -> {
            try {
                return (Customer)this.tbCustomerService.save((Object)customer, entityGroups, user);
            }
            catch (Exception e) {
                throw this.handleException(e);
            }
        });
    }

    @ApiOperation(value="Delete Customer (deleteCustomer)", notes="Deletes the Customer and all customer Users. All assigned Dashboards, Assets, Devices, etc. will be unassigned but not deleted. Referencing non-existing Customer Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'DELETE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteCustomer(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.DELETE);
        this.tbCustomerService.delete((Object)customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Customers (getCustomers)", notes="Returns a page of customers owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customers"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Customer> getCustomers(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "email", "country", "city"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (PageData)this.checkNotNull((Object)this.customerService.findCustomersByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Customer by Customer title (getTenantCustomer)", notes="Get the Customer using Customer Title. \n\nAvailable for users with 'TENANT_ADMIN' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/customers"}, params={"customerTitle"}, method={RequestMethod.GET})
    @ResponseBody
    public Customer getTenantCustomer(@Parameter(description="A string value representing the Customer title.") @RequestParam String customerTitle) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (Customer)this.checkNotNull(this.customerService.findCustomerByTenantIdAndTitle(tenantId, customerTitle), "Customer with title [" + customerTitle + "] is not found");
    }

    @ApiOperation(value="Get Customers (getUserCustomers)", notes="Returns a page of customers available for the user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/user/customers"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Customer> getUserCustomers(@Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "email", "country", "city"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        SecurityUser currentUser = this.getCurrentUser();
        MergedUserPermissions mergedUserPermissions = currentUser.getUserPermissions();
        return this.entityService.findUserEntities(currentUser.getTenantId(), currentUser.getCustomerId(), mergedUserPermissions, EntityType.CUSTOMER, Operation.READ, null, pageLink);
    }

    @ApiOperation(value="Get All Customer Infos for current user (getAllCustomerInfos)", notes="Returns a page of customer info objects owned by the tenant or the customer of a current user. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customerInfos/all"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<CustomerInfo> getAllCustomerInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="The case insensitive 'substring' filter based on the customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "email", "country", "city"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (Authority.TENANT_ADMIN.equals((Object)this.getCurrentUser().getAuthority())) {
            if (includeCustomers != null && includeCustomers.booleanValue()) {
                return (PageData)this.checkNotNull((Object)this.customerService.findCustomerInfosByTenantId(tenantId, pageLink));
            }
            return (PageData)this.checkNotNull((Object)this.customerService.findTenantCustomerInfosByTenantId(tenantId, pageLink));
        }
        CustomerId customerId = this.getCurrentUser().getCustomerId();
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.customerService.findCustomerInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.customerService.findCustomerInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer sub-customers Infos (getCustomerCustomerInfos)", notes="Returns a page of customer info objects owned by the specified customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/customerInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<CustomerInfo> getCustomerCustomerInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Include customer or sub-customer entities") @RequestParam(required=false) Boolean includeCustomers, @Parameter(description="The case insensitive 'substring' filter based on the customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "email", "country", "city"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (includeCustomers != null && includeCustomers.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.customerService.findCustomerInfosByTenantIdAndCustomerIdIncludingSubCustomers(tenantId, customerId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.customerService.findCustomerInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get customers by Customer Ids (getCustomersByEntityGroupId)", notes="Returns a list of Customer objects based on the provided ids. Filters the list based on the user permissions. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority. Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customers"}, params={"customerIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Customer> getCustomersByIds(@Parameter(description="A list of customer ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="customerIds") String[] strCustomerIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("customerIds", strCustomerIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<CustomerId> customerIds = new ArrayList<CustomerId>();
        for (String strCustomerId : strCustomerIds) {
            customerIds.add(new CustomerId(this.toUUID(strCustomerId)));
        }
        List customers = (List)this.checkNotNull((Object)((List)this.customerService.findCustomersByTenantIdAndIdsAsync(tenantId, customerIds).get()));
        return this.filterCustomersByReadPermission(customers);
    }

    @ApiOperation(value="Get customers by Entity Group Id (getCustomersByEntityGroupId)", notes="Returns a page of Customer objects that belongs to specified Entity Group Id. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\n Security check is performed to verify that the user has 'READ' permission for specified group.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityGroup/{entityGroupId}/customers"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Customer> getCustomersByEntityGroupId(@Parameter(description="A string value representing the Entity Group Id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityGroupId") String strEntityGroupId, @Parameter(description="Maximum amount of entities in a one page", required=true, schema=@Schema(minimum="1")) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true, schema=@Schema(minimum="0")) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "email", "country", "city"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("entityGroupId", strEntityGroupId);
        EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(strEntityGroupId));
        EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
        this.checkEntityGroupType(EntityType.CUSTOMER, entityGroup.getType());
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.customerService.findCustomersByEntityGroupId(entityGroupId, pageLink));
    }

    private List<Customer> filterCustomersByReadPermission(List<Customer> customers) {
        return customers.stream().filter(customer -> {
            try {
                return this.accessControlService.hasPermission(this.getCurrentUser(), Resource.CUSTOMER, Operation.READ, (EntityId)customer.getId(), (TenantEntity)customer);
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/customer/public"})
    public Customer createPublicCustomer() throws Exception {
        try {
            TenantId tenantId = this.getTenantId();
            Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(tenantId, this.getCurrentUser().getOwnerId());
            return publicCustomer;
        }
        catch (RuntimeException e) {
            Customer publicCustomer = new Customer();
            publicCustomer.setTenantId(this.getTenantId());
            publicCustomer.setOwnerId(this.getCurrentUser().getOwnerId());
            publicCustomer.setTitle("Public");
            publicCustomer.setAdditionalInfo((JsonNode)JacksonUtil.fromString((String)"{ \"isPublic\": true }", JsonNode.class));
            return this.customerService.saveCustomer(publicCustomer, false);
        }
    }

    @ConstructorProperties(value={"tbCustomerService"})
    @Generated
    public CustomerController(TbCustomerService tbCustomerService) {
        this.tbCustomerService = tbCustomerService;
    }
}

