/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.hash.Hashing;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.CustomMenuDeleteResult;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.Views;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.menu.CMAssigneeType;
import org.thingsboard.server.common.data.menu.CMScope;
import org.thingsboard.server.common.data.menu.CustomMenu;
import org.thingsboard.server.common.data.menu.CustomMenuConfig;
import org.thingsboard.server.common.data.menu.CustomMenuFilter;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.CustomMenuController;
import org.thingsboard.server.dao.menu.CustomMenuCacheKey;
import org.thingsboard.server.dao.menu.CustomMenuService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.custommenu.TbCustomMenuService;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class CustomMenuController
extends BaseController {
    @Autowired
    private TbCustomMenuService tbCustomMenuService;
    @Autowired
    private CustomMenuService customMenuService;

    @ApiOperation(value="Get all custom menus configured at user level (getCustomMenuInfos)", notes="Returns a page of custom menu info objects owned by the tenant or the customer of a current user, scope and assigneeType request parameters can be used to filter the result.\n\nSecurity check is performed to verify that the user has 'READ' permission for the white labeling resource.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customMenu/infos"})
    public PageData<CustomMenuInfo> getCustomMenuInfos(@Parameter(description="Custom menu scope.") @RequestParam(required=false) CMScope scope, @Parameter(description="Custom menu assignee type.") @RequestParam(required=false) CMAssigneeType assigneeType, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the custom menu name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.checkWhiteLabelingPermissions(Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        CustomMenuFilter customMenuFilter = CustomMenuFilter.builder().tenantId(currentUser.getTenantId()).customerId(currentUser.getCustomerId()).scope(scope).assigneeType(assigneeType).build();
        return this.customMenuService.findCustomMenuInfos(currentUser.getTenantId(), customMenuFilter, pageLink);
    }

    @ApiOperation(value="Get end-user Custom Menu configuration (getCustomMenu)", notes="Fetch the Custom Menu configuration object for the authorized user. The custom menu is configured in the white labeling parameters and has one of three user scopes:SYSTEM, TENANT, CUSTOMER and four assignee type: NO_ASSIGN, ALL, CUSTOMERS, USERS.There are three default (assignee type: ALL) menus configured on the system level for each scope and if no other menu is configured for user, system configuration of the corresponding scope will be applied.If a custom menu with assignee type ALL is configured on the tenant level, it overrides the menu configuration of the corresponding scope on the system level. If a custom menu with assignee type CUSTOMERS is configured on tenant level for specific customer, it will be applied to all customer users.If a custom menu with assignee type ALL is configured on the customer level, it overrides the menu assigned on tenant level.If a custom menu is assigned to specific user, it overrides all other configuration.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customMenu"})
    public void getCustomMenu(@RequestHeader(name="If-None-Match", required=false) String etag, HttpServletResponse response) throws ThingsboardException, IOException {
        SecurityUser currentUser = this.getCurrentUser();
        CustomMenuCacheKey cacheKey = CustomMenuCacheKey.forUser((TenantId)currentUser.getTenantId(), (CustomerId)currentUser.getCustomerId(), (UserId)currentUser.getId());
        if (StringUtils.isNotEmpty((CharSequence)etag) && StringUtils.remove((String)etag, (char)'\"').equals(this.tbCustomMenuService.getETag((Object)cacheKey))) {
            response.setStatus(HttpStatus.NOT_MODIFIED.value());
        } else {
            Authority authority = currentUser.getAuthority();
            CustomMenuConfig customMenuConfig = null;
            if (Authority.SYS_ADMIN.equals((Object)authority)) {
                customMenuConfig = this.customMenuService.findSystemAdminCustomMenuConfig();
            } else if (Authority.TENANT_ADMIN.equals((Object)authority)) {
                customMenuConfig = this.customMenuService.findTenantUserCustomMenuConfig(currentUser.getTenantId(), currentUser.getId());
            } else if (Authority.CUSTOMER_USER.equals((Object)authority)) {
                customMenuConfig = this.customMenuService.findCustomerUserCustomMenuConfig(currentUser.getTenantId(), currentUser.getCustomerId(), currentUser.getId());
            }
            String customMenuView = JacksonUtil.writeValueAsViewIgnoringNullFields((Object)customMenuConfig, Views.Public.class);
            String calculatedEtag = this.calculateCustomMenuEtag(customMenuView);
            this.tbCustomMenuService.putETag((Object)cacheKey, calculatedEtag);
            response.setHeader("Etag", calculatedEtag);
            response.setContentType("application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
            response.getWriter().write(customMenuView);
        }
    }

    @ApiOperation(value="Get Custom Menu Info (getCustomMenuInfoById)", notes="Fetch the Custom Menu Info object based on the provided Custom Menu Id. \n\nSecurity check is performed to verify that the user has 'READ' permission for the custom menu with specified id.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customMenu/{customMenuId}/info"})
    public CustomMenuInfo getCustomMenuInfoById(@Parameter(description="A string value representing the custom menu id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customMenuId") UUID id) throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.READ);
        CustomMenuId customMenuId = new CustomMenuId(id);
        return this.checkCustomMenuInfoId(customMenuId, Operation.READ);
    }

    @ApiOperation(value="Get Custom Menu assignee list (getCustomMenuAssigneeList)", notes="Fetch the list of Entity Info objects that represents users or customers, or empty list if custom menu is not assigned or has NO_ASSIGN/ALL assignee type.\n\nSecurity check is performed to verify that the user has 'READ' permission for the custom menu with specified id.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customMenu/{customMenuId}/assigneeList"})
    public List<EntityInfo> getCustomMenuAssigneeList(@Parameter(description="A string value representing the custom menu id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customMenuId") UUID id) throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.READ);
        CustomMenuId customMenuId = new CustomMenuId(id);
        CustomMenuInfo customMenuInfo = this.checkCustomMenuInfoId(customMenuId, Operation.READ);
        return this.customMenuService.findCustomMenuAssigneeList(customMenuInfo);
    }

    @ApiOperation(value="Get Custom Menu configuration by id (getCustomMenuConfig)", notes="Fetch the Custom Menu configuration based on the provided Custom Menu Id. \n\nSecurity check is performed to verify that the user has 'READ' permission for the custom menu with specified id.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/customMenu/{customMenuId}/config"})
    public CustomMenuConfig getCustomMenuConfig(@Parameter(description="A string value representing the custom menu id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customMenuId") UUID id) throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.READ);
        CustomMenuId customMenuId = new CustomMenuId(id);
        return this.checkCustomMenuId(customMenuId, Operation.READ).getConfig();
    }

    @ApiOperation(value="Update Custom Menu configuration based on the provided Custom Menu Id (updateCustomMenuConfig)", notes="\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the custom menu with specified id.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/customMenu/{customMenuId}/config"})
    public CustomMenu updateCustomMenuConfig(@Parameter(description="A string value representing the custom menu id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customMenuId") UUID id, @Parameter(description="A JSON value representing the custom menu configuration") @RequestBody @Valid CustomMenuConfig customMenuConfig) throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.WRITE);
        CustomMenuId customMenuId = new CustomMenuId(id);
        CustomMenu customMenu = (CustomMenu)this.checkNotNull((Object)this.checkCustomMenuId(customMenuId, Operation.WRITE));
        CustomMenu newCustomMenu = new CustomMenu(customMenu);
        newCustomMenu.setConfig(customMenuConfig);
        return this.tbCustomMenuService.updateCustomMenu(newCustomMenu, false);
    }

    @ApiOperation(value="Update Custom Menu name based on the provided Custom Menu Id (updateCustomMenuName)", notes="\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the custom menu with specified id.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/customMenu/{customMenuId}/name"})
    public void updateCustomMenuName(@Parameter(description="A string value representing the custom menu id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customMenuId") UUID id, @Parameter(description="New name of the custom menu") @RequestBody String name) throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.WRITE);
        CustomMenuId customMenuId = new CustomMenuId(id);
        CustomMenu customMenu = (CustomMenu)this.checkNotNull((Object)this.checkCustomMenuId(customMenuId, Operation.WRITE));
        CustomMenu newCustomMenu = new CustomMenu(customMenu);
        newCustomMenu.setName(name);
        this.customMenuService.updateCustomMenu(newCustomMenu, false);
    }

    @ApiOperation(value="Create Custom Menu (createCustomMenu)", notes="The api is designed to create Custom Menu without configuration. Is not applicable for update.\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the custom menu with specified id.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/customMenu"})
    public CustomMenu createCustomMenu(@Parameter(description="A list of entity ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="assignToList", required=false) UUID[] ids, @Parameter(description="Use force if you want to create default menu that conflicts with the existing one (old one will be update NO_ASSIGN assignee type)") @RequestParam(name="force", required=false) boolean force, @Parameter(description="A JSON value representing the custom menu basic info fields") @RequestBody @Valid CustomMenuInfo customMenuInfo) throws ThingsboardException {
        if (customMenuInfo.getId() != null) {
            throw new ThingsboardException("Update is unsupported.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        SecurityUser currentUser = this.getCurrentUser();
        customMenuInfo.setTenantId(currentUser.getTenantId());
        customMenuInfo.setCustomerId(currentUser.getCustomerId());
        List assigneeList = this.getAssigneeList(customMenuInfo.getAssigneeType(), ids);
        this.checkWhiteLabelingPermissions(Operation.WRITE);
        return this.tbCustomMenuService.createCustomMenu(customMenuInfo, assigneeList, force);
    }

    @ApiOperation(value="Update custom menu assignee list (updateCustomMenuAssigneeList)", notes="The api designed to update the list of assignees or assignee type based on the provided Custom Menu Id. To change assignee type, put new assignee type in path parameter.\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the custom menu with specified id.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PutMapping(value={"/customMenu/{id}/assign/{assigneeType}"})
    public void updateCustomMenuAssigneeList(@PathVariable(value="id") UUID id, @PathVariable(value="assigneeType") CMAssigneeType assigneeType, @Parameter(description="Use force if you want to override default menu") @RequestParam(name="force", required=false) boolean force, @RequestBody(required=false) UUID[] entityIds) throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.WRITE);
        CustomMenuId customMenuId = new CustomMenuId(id);
        CustomMenu customMenu = this.checkCustomMenuId(customMenuId, Operation.WRITE);
        List assigneeList = this.getAssigneeList(assigneeType, entityIds);
        this.tbCustomMenuService.updateAssigneeList(customMenu, assigneeType, assigneeList, force);
    }

    @ApiOperation(value="Delete custom menu (deleteCustomMenu)", notes="Deletes the custom menu based on the provided Custom Menu Id. Referencing non-existing custom menu Id will cause an error. If the custom menu is assigned to the list of users or customers bad request is returned.To delete a custom menu that has assignee list set 'force' request param to true ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @DeleteMapping(value={"/customMenu/{customMenuId}"})
    public ResponseEntity<CustomMenuDeleteResult> deleteCustomMenu(@Parameter(required=true, description="A string value representing the custom menu id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customMenuId") UUID id, @Parameter(description="Force set to true will unassign menu before deletion") @RequestParam(name="force", required=false) boolean force) throws ThingsboardException {
        this.checkWhiteLabelingPermissions(Operation.WRITE);
        CustomMenuId customMenuId = new CustomMenuId(id);
        CustomMenu customMenu = (CustomMenu)this.checkNotNull((Object)this.checkCustomMenuId(customMenuId, Operation.DELETE));
        CustomMenuDeleteResult result = this.tbCustomMenuService.deleteCustomMenu(customMenu, force);
        return (result.isSuccess() ? ResponseEntity.ok() : ResponseEntity.badRequest()).body((Object)result);
    }

    protected String calculateCustomMenuEtag(String customMenu) {
        return Hashing.sha256().hashString((CharSequence)customMenu, StandardCharsets.UTF_8).toString();
    }

    private List<EntityId> getAssigneeList(CMAssigneeType type, UUID[] ids) throws ThingsboardException {
        ArrayList<EntityId> assignToList = new ArrayList<EntityId>();
        if (ids == null) {
            return assignToList;
        }
        switch (1.$SwitchMap$org$thingsboard$server$common$data$menu$CMAssigneeType[type.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                for (UUID id : ids) {
                    CustomerId customerId = new CustomerId(id);
                    this.checkCustomerId(customerId, Operation.WRITE);
                    assignToList.add((EntityId)customerId);
                }
                break;
            }
            case 4: {
                for (UUID id : ids) {
                    UserId userId = new UserId(id);
                    this.checkUserId(userId, Operation.WRITE);
                    assignToList.add((EntityId)userId);
                }
                break;
            }
        }
        return assignToList;
    }

    private void checkWhiteLabelingPermissions(Operation operation) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WHITE_LABELING, operation);
    }
}

