/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.mail.MessagingException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.TbBiFunction;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.CustomerInfo;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceInfo;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.EntityViewInfo;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HomeDashboardInfo;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.TenantInfo;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.UserInfo;
import org.thingsboard.server.common.data.ai.AiModel;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetInfo;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.blob.BlobEntity;
import org.thingsboard.server.common.data.blob.BlobEntityWithCustomerInfo;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.domain.Domain;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeInfo;
import org.thingsboard.server.common.data.exception.EntityVersionMismatchException;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.AlarmCommentId;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.MobileAppBundleId;
import org.thingsboard.server.common.data.id.MobileAppId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.ReportId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.SecretId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.menu.CustomMenu;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.common.data.mobile.app.MobileApp;
import org.thingsboard.server.common.data.mobile.bundle.MobileAppBundle;
import org.thingsboard.server.common.data.notification.targets.NotificationTarget;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.permission.GroupPermissionInfo;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.plugin.ComponentDescriptor;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.data.report.Report;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.common.data.report.ReportTemplateInfo;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.common.data.rpc.Rpc;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventWithCustomerInfo;
import org.thingsboard.server.common.data.secret.SecretInfo;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.subscription.SubscriptionException;
import org.thingsboard.server.common.data.util.ThrowingBiFunction;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.widget.WidgetTypeInfo;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.ai.AiModelService;
import org.thingsboard.server.dao.alarm.AlarmCommentService;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.audit.AuditLogService;
import org.thingsboard.server.dao.blob.BlobEntityService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.dao.converter.ConverterService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.ClaimDevicesService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.dao.menu.CustomMenuService;
import org.thingsboard.server.dao.mobile.MobileAppBundleService;
import org.thingsboard.server.dao.mobile.MobileAppService;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.oauth2.OAuth2ConfigTemplateService;
import org.thingsboard.server.dao.ota.DeviceGroupOtaPackageService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.report.ReportService;
import org.thingsboard.server.dao.report.ReportTemplateService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.dao.rpc.RpcService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.scheduler.SchedulerEventService;
import org.thingsboard.server.dao.secret.SecretService;
import org.thingsboard.server.dao.service.ConstraintValidator;
import org.thingsboard.server.dao.service.Validator;
import org.thingsboard.server.dao.subscription.SubscriptionService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantProfileService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.exception.ThingsboardErrorResponseHandler;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.action.EntityActionService;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.edge.EdgeLicenseService;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;
import org.thingsboard.server.service.entitiy.ai.TbAiModelService;
import org.thingsboard.server.service.entitiy.ota.group.TbDeviceGroupOtaPackageService;
import org.thingsboard.server.service.entitiy.user.TbUserSettingsService;
import org.thingsboard.server.service.ota.OtaPackageStateService;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.query.EntityQueryService;
import org.thingsboard.server.service.scheduler.SchedulerService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.security.permission.UserPermissionsService;
import org.thingsboard.server.service.state.DeviceStateService;
import org.thingsboard.server.service.sync.ie.exporting.ExportableEntitiesService;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;
import org.thingsboard.server.service.telemetry.AlarmSubscriptionService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@TbCoreComponent
public abstract class BaseController {
    protected static final String DASHBOARD_ID = "dashboardId";
    protected static final String HOME_DASHBOARD_ID = "homeDashboardId";
    protected static final String HOME_DASHBOARD_HIDE_TOOLBAR = "homeDashboardHideToolbar";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ThingsboardErrorResponseHandler errorResponseHandler;
    @Autowired
    protected AccessControlService accessControlService;
    @Autowired
    protected TenantService tenantService;
    @Autowired
    protected TenantProfileService tenantProfileService;
    @Autowired
    protected CustomerService customerService;
    @Autowired
    protected UserService userService;
    @Autowired
    protected WhiteLabelingService whiteLabelingService;
    @Autowired
    protected TbUserSettingsService userSettingsService;
    @Autowired
    protected DeviceService deviceService;
    @Autowired
    protected DeviceProfileService deviceProfileService;
    @Autowired
    protected AssetService assetService;
    @Autowired
    protected AssetProfileService assetProfileService;
    @Autowired
    protected IntegrationService integrationService;
    @Autowired
    protected ConverterService converterService;
    @Autowired
    protected AlarmSubscriptionService alarmService;
    @Autowired
    protected AlarmCommentService alarmCommentService;
    @Autowired
    protected DeviceCredentialsService deviceCredentialsService;
    @Autowired
    protected WidgetsBundleService widgetsBundleService;
    @Autowired
    protected WidgetTypeService widgetTypeService;
    @Autowired
    protected DashboardService dashboardService;
    @Autowired
    protected OAuth2ClientService oAuth2ClientService;
    @Autowired
    protected DomainService domainService;
    @Autowired
    protected MobileAppService mobileAppService;
    @Autowired
    protected MobileAppBundleService mobileAppBundleService;
    @Autowired
    protected OAuth2ConfigTemplateService oAuth2ConfigTemplateService;
    @Autowired
    protected ComponentDiscoveryService componentDescriptorService;
    @Autowired
    protected RuleChainService ruleChainService;
    @Autowired
    protected TbClusterService tbClusterService;
    @Autowired
    protected RelationService relationService;
    @Autowired
    protected EntityGroupService entityGroupService;
    @Autowired
    protected OwnersCacheService ownersCacheService;
    @Autowired
    protected SchedulerEventService schedulerEventService;
    @Autowired
    protected BlobEntityService blobEntityService;
    @Autowired
    protected ReportTemplateService reportTemplateService;
    @Autowired
    protected ReportService reportService;
    @Autowired
    protected AuditLogService auditLogService;
    @Autowired
    protected DeviceStateService deviceStateService;
    @Autowired
    protected SchedulerService schedulerService;
    @Autowired
    protected SubscriptionService subscriptionService;
    @Autowired
    protected EntityViewService entityViewService;
    @Autowired
    protected RoleService roleService;
    @Autowired
    protected GroupPermissionService groupPermissionService;
    @Autowired
    protected TelemetrySubscriptionService tsSubService;
    @Autowired
    protected AttributesService attributesService;
    @Autowired
    protected UserPermissionsService userPermissionsService;
    @Autowired
    protected CloudEventService cloudEventService;
    @Autowired
    protected EdgeSettingsService edgeSettingsService;
    @Autowired
    protected ClaimDevicesService claimDevicesService;
    @Autowired
    protected PartitionService partitionService;
    @Autowired
    protected TbServiceInfoProvider serviceInfoProvider;
    @Autowired
    protected ResourceService resourceService;
    @Autowired
    protected OtaPackageService otaPackageService;
    @Autowired
    protected OtaPackageStateService otaPackageStateService;
    @Autowired
    protected DeviceGroupOtaPackageService deviceGroupOtaPackageService;
    @Autowired
    protected TbDeviceGroupOtaPackageService tbDeviceGroupOtaPackageService;
    @Autowired
    protected RpcService rpcService;
    @Autowired
    protected TbQueueProducerProvider producerProvider;
    @Autowired
    protected EntityQueryService entityQueryService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected TbTenantProfileCache tenantProfileCache;
    @Autowired
    protected TbDeviceProfileCache deviceProfileCache;
    @Autowired
    protected TbAssetProfileCache assetProfileCache;
    @Autowired(required=false)
    protected EdgeService edgeService;
    @Autowired(required=false)
    protected EdgeLicenseService edgeLicenseService;
    @Autowired
    protected TbLogEntityActionService logEntityActionService;
    @Autowired
    protected EntityActionService entityActionService;
    @Autowired
    protected QueueService queueService;
    @Autowired
    protected EntitiesVersionControlService vcService;
    @Autowired
    protected ExportableEntitiesService entitiesService;
    @Autowired
    protected CustomMenuService customMenuService;
    @Autowired
    protected NotificationTargetService notificationTargetService;
    @Autowired
    protected JobService jobService;
    @Autowired
    protected CalculatedFieldService calculatedFieldService;
    @Autowired
    protected SecretService secretService;
    @Autowired
    protected AiModelService aiModelService;
    @Autowired
    protected TbAiModelService tbAiModelService;
    @Value(value="${server.log_controller_error_stack_trace}")
    private boolean logControllerErrorStackTrace;
    @Value(value="${edges.enabled}")
    protected boolean edgesEnabled;
    protected Comparator<ContactBased<? extends UUIDBased>> entityComparator = (e1, e2) -> {
        int result = e1.getName().compareToIgnoreCase(e2.getName());
        if (result == 0) {
            result = (int)(e2.getCreatedTime() - e1.getCreatedTime());
        }
        return result;
    };

    @ExceptionHandler(value={Exception.class})
    public void handleControllerException(Exception e, HttpServletResponse response) {
        ThingsboardException thingsboardException = this.handleException((Exception)e);
        e = thingsboardException.getErrorCode() == ThingsboardErrorCode.GENERAL && thingsboardException.getCause() instanceof Exception && StringUtils.equals((String)thingsboardException.getCause().getMessage(), (String)thingsboardException.getMessage()) ? (Exception)thingsboardException.getCause() : thingsboardException;
        this.errorResponseHandler.handle((Exception)e, response);
    }

    @ExceptionHandler(value={ThingsboardException.class})
    public void handleThingsboardException(ThingsboardException ex, HttpServletResponse response) {
        this.errorResponseHandler.handle((Exception)((Object)ex), response);
    }

    @Deprecated
    ThingsboardException handleException(Exception exception) {
        return this.handleException((Throwable)exception, true);
    }

    private ThingsboardException handleException(Throwable exception, boolean logException) {
        if (logException && this.logControllerErrorStackTrace) {
            try {
                SecurityUser user = this.getCurrentUser();
                if (exception instanceof SubscriptionException) {
                    this.log.error("[{}][{}] Error [{}]", new Object[]{user.getTenantId(), user.getId(), exception.getMessage()});
                } else {
                    this.log.error("[{}][{}] Error", new Object[]{user.getTenantId(), user.getId(), exception});
                }
            }
            catch (Exception e) {
                this.log.error("Error", exception);
            }
        }
        Throwable cause = exception.getCause();
        if (exception instanceof ExecutionException) {
            exception = cause;
        }
        if (exception instanceof ThingsboardException) {
            return (ThingsboardException)exception;
        }
        if (exception instanceof IllegalArgumentException || exception instanceof IncorrectParameterException || exception instanceof DataValidationException || cause instanceof IncorrectParameterException) {
            return new ThingsboardException(exception.getMessage(), ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        if (exception instanceof MessagingException) {
            return new ThingsboardException("Unable to send mail", ThingsboardErrorCode.GENERAL);
        }
        if (exception instanceof SubscriptionException) {
            return new ThingsboardException(exception, ThingsboardErrorCode.SUBSCRIPTION_VIOLATION);
        }
        if (exception instanceof AsyncRequestTimeoutException) {
            return new ThingsboardException("Request timeout", ThingsboardErrorCode.GENERAL);
        }
        if (exception instanceof DataAccessException) {
            return new ThingsboardException(exception, ThingsboardErrorCode.DATABASE);
        }
        if (exception instanceof EntityVersionMismatchException) {
            return new ThingsboardException(exception.getMessage(), exception, ThingsboardErrorCode.VERSION_CONFLICT);
        }
        if (exception instanceof MethodArgumentTypeMismatchException) {
            return new ThingsboardException(exception.getMessage(), exception, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return new ThingsboardException(exception.getMessage(), exception, ThingsboardErrorCode.GENERAL);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public void handleValidationError(MethodArgumentNotValidException validationError, HttpServletResponse response) {
        List constraintsViolations = validationError.getFieldErrors().stream().map(fieldError -> {
            try {
                return (ConstraintViolation)fieldError.unwrap(ConstraintViolation.class);
            }
            catch (Exception e) {
                this.log.warn("FieldError source is not of type ConstraintViolation");
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        String errorMessage = "Validation error: " + ConstraintValidator.getErrorMessage(constraintsViolations);
        ThingsboardException thingsboardException = new ThingsboardException(errorMessage, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        this.handleControllerException((Exception)((Object)thingsboardException), response);
    }

    <T> T checkNotNull(T reference) throws ThingsboardException {
        return (T)this.checkNotNull(reference, "Requested item wasn't found!");
    }

    <T> T checkNotNull(T reference, String notFoundMessage) throws ThingsboardException {
        if (reference == null) {
            throw new ThingsboardException(notFoundMessage, ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        return reference;
    }

    <T> T checkNotNull(Optional<T> reference) throws ThingsboardException {
        return (T)this.checkNotNull(reference, "Requested item wasn't found!");
    }

    <T> T checkNotNull(Optional<T> reference, String notFoundMessage) throws ThingsboardException {
        if (reference.isPresent()) {
            return reference.get();
        }
        throw new ThingsboardException(notFoundMessage, ThingsboardErrorCode.ITEM_NOT_FOUND);
    }

    void checkParameter(String name, String param) throws ThingsboardException {
        if (StringUtils.isEmpty((String)param.trim())) {
            throw new ThingsboardException("Parameter '" + name + "' can't be empty!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
    }

    void checkArrayParameter(String name, String[] params) throws ThingsboardException {
        if (params == null || params.length == 0) {
            throw new ThingsboardException("Parameter '" + name + "' can't be empty!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        for (String param : params) {
            this.checkParameter(name, param);
        }
    }

    protected <T> T checkEnumParameter(String name, String param, Function<String, T> valueOf) throws ThingsboardException {
        try {
            return valueOf.apply(param.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ThingsboardException(name + " \"" + param + "\" is not supported!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
    }

    RoleType checkStrRoleType(String name, String strGroupType) throws ThingsboardException {
        RoleType groupType;
        this.checkParameter(name, strGroupType);
        try {
            groupType = RoleType.valueOf((String)strGroupType);
        }
        catch (IllegalArgumentException e) {
            throw new ThingsboardException("Unsupported role type '" + strGroupType + "'! Only 'GENERIC' or 'GROUP' types are allowed.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return groupType;
    }

    EntityType checkStrEntityGroupType(String name, String strGroupType) throws ThingsboardException {
        EntityType groupType;
        this.checkParameter(name, strGroupType);
        try {
            groupType = EntityType.valueOf((String)strGroupType);
        }
        catch (IllegalArgumentException e) {
            throw new ThingsboardException("Unsupported entityGroup type '" + strGroupType + "'! Only 'CUSTOMER', 'ASSET', 'DEVICE', 'USER', 'ENTITY_VIEW' or 'DASHBOARD' types are allowed.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return this.checkEntityGroupType(groupType);
    }

    void checkEntityGroupType(EntityType expected, EntityType actual) throws ThingsboardException {
        if (expected == null) {
            throw new RuntimeException("Expected Entitytype is not specified!");
        }
        if (actual == null) {
            throw new ThingsboardException("EntityGroup type is required!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        if (!expected.equals((Object)actual)) {
            throw new ThingsboardException("Expected entity group with type '" + String.valueOf(expected) + "' but received '" + String.valueOf(actual) + "'!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
    }

    EntityType checkEntityGroupType(EntityType groupType) throws ThingsboardException {
        if (groupType == null) {
            throw new ThingsboardException("EntityGroup type is required!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        if (groupType != EntityType.CUSTOMER && groupType != EntityType.ASSET && groupType != EntityType.DEVICE && groupType != EntityType.USER && groupType != EntityType.ENTITY_VIEW && groupType != EntityType.EDGE && groupType != EntityType.DASHBOARD) {
            throw new ThingsboardException("Unsupported entityGroup type '" + String.valueOf(groupType) + "'! Only 'CUSTOMER', 'ASSET', 'DEVICE', 'USER', 'ENTITY_VIEW' or 'DASHBOARD' types are allowed.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return groupType;
    }

    EntityType checkSharableEntityGroupType(EntityType groupType) throws ThingsboardException {
        if (groupType == null) {
            throw new ThingsboardException("EntityGroup type is required!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        if (!Arrays.stream(EntityGroup.sharableGroupTypes).anyMatch(type -> type.equals((Object)groupType))) {
            throw new ThingsboardException("Invalid entityGroup type '" + String.valueOf(groupType) + "'! Only entity groups of types 'CUSTOMER', 'ASSET', 'DEVICE', 'ENTITY_VIEW' or 'DASHBOARD' can be shared.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return groupType;
    }

    UUID toUUID(String id) throws ThingsboardException {
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    PageLink createPageLink(int pageSize, int page, String textSearch, String sortProperty, String sortOrder) throws ThingsboardException {
        if (StringUtils.isNotEmpty((String)sortProperty)) {
            if (!Validator.isValidProperty((String)sortProperty)) {
                throw new IllegalArgumentException("Invalid sort property");
            }
            SortOrder.Direction direction = SortOrder.Direction.ASC;
            if (StringUtils.isNotEmpty((String)sortOrder)) {
                try {
                    direction = SortOrder.Direction.valueOf((String)sortOrder.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new ThingsboardException("Unsupported sort order '" + sortOrder + "'! Only 'ASC' or 'DESC' types are allowed.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
                }
            }
            SortOrder sort = new SortOrder(sortProperty, direction);
            return new PageLink(pageSize, page, textSearch, sort);
        }
        return new PageLink(pageSize, page, textSearch);
    }

    TimePageLink createTimePageLink(int pageSize, int page, String textSearch, String sortProperty, String sortOrder, Long startTime, Long endTime) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return new TimePageLink(pageLink, startTime, endTime);
    }

    protected SecurityUser getCurrentUser() throws ThingsboardException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof SecurityUser) {
            return (SecurityUser)authentication.getPrincipal();
        }
        throw new ThingsboardException("You aren't authorized to perform this operation!", ThingsboardErrorCode.AUTHENTICATION);
    }

    Tenant checkTenantId(TenantId tenantId, Operation operation) throws ThingsboardException {
        return (Tenant)this.checkEntityId((EntityId)tenantId, (t, i) -> this.tenantService.findTenantById(tenantId), operation);
    }

    TenantInfo checkTenantInfoId(TenantId tenantId, Operation operation) throws ThingsboardException {
        return (TenantInfo)this.checkEntityId((EntityId)tenantId, (t, i) -> this.tenantService.findTenantInfoById(tenantId), operation);
    }

    TenantProfile checkTenantProfileId(TenantProfileId tenantProfileId, Operation operation) throws ThingsboardException {
        try {
            Validator.validateId((UUIDBased)tenantProfileId, id -> "Incorrect tenantProfileId " + String.valueOf(id));
            TenantProfile tenantProfile = this.tenantProfileService.findTenantProfileById(this.getTenantId(), tenantProfileId);
            this.checkNotNull((Object)tenantProfile, "Tenant profile with id [" + String.valueOf(tenantProfileId) + "] is not found");
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.TENANT_PROFILE, operation);
            return tenantProfile;
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    protected TenantId getTenantId() throws ThingsboardException {
        return this.getCurrentUser().getTenantId();
    }

    Customer checkCustomerId(CustomerId customerId, Operation operation) throws ThingsboardException {
        return (Customer)this.checkEntityId((EntityId)customerId, (arg_0, arg_1) -> ((CustomerService)this.customerService).findCustomerById(arg_0, arg_1), operation);
    }

    CustomerInfo checkCustomerInfoId(CustomerId customerId, Operation operation) throws ThingsboardException {
        return (CustomerInfo)this.checkEntityId((EntityId)customerId, (arg_0, arg_1) -> ((CustomerService)this.customerService).findCustomerInfoById(arg_0, arg_1), operation);
    }

    CustomMenu checkCustomMenuId(CustomMenuId customMenuId, Operation operation) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        CustomMenu customMenu = this.customMenuService.findCustomMenuById(currentUser.getTenantId(), customMenuId);
        this.checkNotNull((Object)customMenu, "Custom menu not found");
        this.accessControlService.checkCustomMenuPermission(currentUser, operation, (CustomMenuInfo)customMenu);
        return customMenu;
    }

    CustomMenuInfo checkCustomMenuInfoId(CustomMenuId customMenuId, Operation operation) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        CustomMenuInfo customMenuInfo = this.customMenuService.findCustomMenuInfoById(currentUser.getTenantId(), customMenuId);
        this.checkNotNull((Object)customMenuInfo, "Custom menu not found");
        this.accessControlService.checkCustomMenuPermission(currentUser, operation, customMenuInfo);
        return customMenuInfo;
    }

    User checkUserId(UserId userId, Operation operation) throws ThingsboardException {
        try {
            Validator.validateId((UUIDBased)userId, id -> "Incorrect userId " + String.valueOf(id));
            User user = this.userService.findUserById(this.getCurrentUser().getTenantId(), userId);
            this.checkNotNull((Object)user, "User with id [" + String.valueOf(userId) + "] is not found");
            if (operation != Operation.READ || !this.getCurrentUser().getId().equals((Object)userId)) {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.USER, operation, (EntityId)userId, (TenantEntity)user);
            }
            return user;
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    UserInfo checkUserInfoId(UserId userId, Operation operation) throws ThingsboardException {
        try {
            Validator.validateId((UUIDBased)userId, id -> "Incorrect userId " + String.valueOf(id));
            UserInfo user = this.userService.findUserInfoById(this.getCurrentUser().getTenantId(), userId);
            this.checkNotNull((Object)user, "User with id [" + String.valueOf(userId) + "] is not found");
            if (operation != Operation.READ || !this.getCurrentUser().getId().equals((Object)userId)) {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.USER, operation, (EntityId)userId, (TenantEntity)user);
            }
            return user;
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    protected UserId checkAssigneeId(String assigneeId) throws ThingsboardException {
        UserId assigneeUserId = null;
        if (assigneeId != null) {
            assigneeUserId = new UserId(UUID.fromString(assigneeId));
            this.checkUserId(assigneeUserId, Operation.READ);
        }
        return assigneeUserId;
    }

    protected <I extends EntityId, T extends GroupEntity<I>> T saveGroupEntity(T entity, String strEntityGroupId, TbBiFunction<T, EntityGroup, T> saveEntityFunction) throws ThingsboardException {
        return (T)this.saveGroupEntity(entity, strEntityGroupId, null, (t, entityGroups) -> (GroupEntity)saveEntityFunction.apply(t, entityGroups != null && !entityGroups.isEmpty() ? (EntityGroup)entityGroups.get(0) : null));
    }

    protected <I extends EntityId, T extends GroupEntity<I>> T saveGroupEntity(T entity, String strEntityGroupId, String[] strEntityGroupIds, TbBiFunction<T, List<EntityGroup>, T> saveEntityFunction) throws ThingsboardException {
        try {
            entity.setTenantId(this.getCurrentUser().getTenantId());
            ArrayList<EntityGroupId> entityGroupIds = new ArrayList<EntityGroupId>();
            ArrayList<EntityGroupInfo> entityGroups = new ArrayList<EntityGroupInfo>();
            String[] groupIds = null;
            if (!StringUtils.isEmpty((String)strEntityGroupId)) {
                groupIds = new String[]{strEntityGroupId};
            } else if (strEntityGroupIds != null && strEntityGroupIds.length > 0) {
                groupIds = strEntityGroupIds;
            }
            if (groupIds != null) {
                for (String id : groupIds) {
                    EntityGroupId entityGroupId = new EntityGroupId(this.toUUID(id));
                    EntityGroupInfo entityGroup = this.checkEntityGroupId(entityGroupId, Operation.READ);
                    entityGroupIds.add(entityGroupId);
                    entityGroups.add(entityGroup);
                }
            }
            if (entity.getId() == null && (entity.getCustomerId() == null || entity.getCustomerId().isNullUid())) {
                if (!entityGroups.isEmpty() && ((EntityGroup)entityGroups.get(0)).getOwnerId().getEntityType() == EntityType.CUSTOMER) {
                    entity.setOwnerId((EntityId)new CustomerId(((EntityGroup)entityGroups.get(0)).getOwnerId().getId()));
                } else if (this.getCurrentUser().getAuthority() == Authority.CUSTOMER_USER) {
                    entity.setOwnerId((EntityId)this.getCurrentUser().getCustomerId());
                }
            }
            this.checkEntityWithGroupIds((EntityId)entity.getId(), entity, Resource.resourceFromEntityType((EntityType)entity.getEntityType()), entityGroupIds);
            if (entity.getId() != null) {
                EntityId oldOwner = this.ownersCacheService.getOwner(entity.getTenantId(), (EntityId)entity.getId());
                if (!entity.getOwnerId().equals(oldOwner)) {
                    throw new DataValidationException("Entity owner can`t be changed. Please use owner api to change owner");
                }
            }
            return (T)((GroupEntity)saveEntityFunction.apply(entity, entityGroups));
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(this.getTenantId(), this.emptyId(entity.getEntityType()), entity, entity.getId() == null ? ActionType.ADDED : ActionType.UPDATED, (User)this.getCurrentUser(), e, new Object[0]);
            throw this.handleException(e);
        }
    }

    protected <I extends EntityId, T extends TenantEntity> void checkEntityWithGroupIds(I entityId, T entity, Resource resource, List<EntityGroupId> entityGroupIds) throws ThingsboardException {
        if (entityGroupIds != null && !entityGroupIds.isEmpty()) {
            for (EntityGroupId entityGroupId : entityGroupIds) {
                this.checkEntity(entityId, entity, resource, entityGroupId);
            }
        } else {
            this.checkEntity(entityId, entity, resource, null);
        }
    }

    protected <I extends EntityId, T extends TenantEntity> void checkEntity(I entityId, T entity, Resource resource, EntityGroupId entityGroupId) throws ThingsboardException {
        if (entityId == null) {
            if (entityGroupId == null) {
                this.accessControlService.checkPermission(this.getCurrentUser(), resource, Operation.CREATE, null, entity);
            } else {
                this.accessControlService.checkPermission(this.getCurrentUser(), resource, Operation.CREATE, null, entity, entityGroupId);
            }
        } else {
            this.checkEntityId(entityId, Operation.WRITE);
        }
    }

    protected <I extends EntityId, T extends TenantEntity> void checkEntity(I entityId, T entity, Resource resource) throws ThingsboardException {
        this.checkEntity(entityId, entity, resource, null);
    }

    protected HasId<? extends EntityId> checkEntityId(EntityId entityId, Operation operation) throws ThingsboardException {
        try {
            if (entityId == null) {
                throw new ThingsboardException("Parameter entityId can't be empty!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
            }
            Validator.validateId((UUID)entityId.getId(), id -> "Incorrect entityId " + String.valueOf(id));
            return switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
                case 1 -> this.checkAlarmId(new AlarmId(entityId.getId()), operation);
                case 2 -> this.checkDeviceId(new DeviceId(entityId.getId()), operation);
                case 3 -> this.checkDeviceProfileId(new DeviceProfileId(entityId.getId()), operation);
                case 4 -> this.checkCustomerId(new CustomerId(entityId.getId()), operation);
                case 5 -> this.checkTenantId(TenantId.fromUUID((UUID)entityId.getId()), operation);
                case 6 -> this.checkTenantProfileId(new TenantProfileId(entityId.getId()), operation);
                case 7 -> this.checkRuleChain(new RuleChainId(entityId.getId()), operation);
                case 8 -> this.checkRuleNode(new RuleNodeId(entityId.getId()), operation);
                case 9 -> this.checkAssetId(new AssetId(entityId.getId()), operation);
                case 10 -> this.checkAssetProfileId(new AssetProfileId(entityId.getId()), operation);
                case 11 -> this.checkIntegrationId(new IntegrationId(entityId.getId()), operation);
                case 12 -> this.checkConverterId(new ConverterId(entityId.getId()), operation);
                case 13 -> this.checkDashboardId(new DashboardId(entityId.getId()), operation);
                case 14 -> this.checkUserId(new UserId(entityId.getId()), operation);
                case 15 -> this.checkEntityGroupId(new EntityGroupId(entityId.getId()), operation);
                case 16 -> this.checkSchedulerEventInfoId(new SchedulerEventId(entityId.getId()), operation);
                case 17 -> this.checkBlobEntityInfoId(new BlobEntityId(entityId.getId()), operation);
                case 18 -> this.checkEntityViewId(new EntityViewId(entityId.getId()), operation);
                case 19 -> this.checkEdgeId(new EdgeId(entityId.getId()), operation);
                case 20 -> this.checkRoleId(new RoleId(entityId.getId()), operation);
                case 21 -> this.checkWidgetsBundleId(new WidgetsBundleId(entityId.getId()), operation);
                case 22 -> this.checkWidgetTypeId(new WidgetTypeId(entityId.getId()), operation);
                case 23 -> this.checkGroupPermissionId(new GroupPermissionId(entityId.getId()), operation);
                case 24 -> this.checkResourceInfoId(new TbResourceId(entityId.getId()), operation);
                case 25 -> this.checkOtaPackageId(new OtaPackageId(entityId.getId()), operation);
                case 26 -> this.checkQueueId(new QueueId(entityId.getId()), operation);
                case 27 -> this.checkOauth2ClientId(new OAuth2ClientId(entityId.getId()), operation);
                case 28 -> this.checkDomainId(new DomainId(entityId.getId()), operation);
                case 29 -> this.checkMobileAppId(new MobileAppId(entityId.getId()), operation);
                case 30 -> this.checkMobileAppBundleId(new MobileAppBundleId(entityId.getId()), operation);
                case 31 -> this.checkCalculatedFieldId(new CalculatedFieldId(entityId.getId()), operation);
                case 32 -> this.checkSecretId(new SecretId(entityId.getId()), operation);
                case 33 -> this.checkReportTemplateInfoId(new ReportTemplateId(entityId.getId()), operation);
                case 34 -> this.checkAiModelId(new AiModelId(entityId.getId()), operation);
                default -> this.checkEntityId(entityId, (arg_0, arg_1) -> ((ExportableEntitiesService)this.entitiesService).findEntityByTenantIdAndId(arg_0, arg_1), operation);
            };
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    protected <E extends HasId<I> & TenantEntity, I extends EntityId> E checkEntityId(I entityId, ThrowingBiFunction<TenantId, I, E> findingFunction, Operation operation) throws ThingsboardException {
        try {
            Validator.validateId((UUIDBased)((UUIDBased)entityId), (String)"Invalid entity id");
            SecurityUser user = this.getCurrentUser();
            HasId entity = (HasId)findingFunction.apply((Object)user.getTenantId(), entityId);
            this.checkNotNull((Object)entity, entityId.getEntityType().getNormalName() + " with id [" + String.valueOf(entityId) + "] is not found");
            return (E)this.checkEntity(user, entity, operation);
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    protected <E extends HasId<I> & TenantEntity, I extends EntityId> E checkEntity(SecurityUser user, E entity, Operation operation) throws ThingsboardException {
        this.checkNotNull(entity, "Entity not found");
        this.accessControlService.checkPermission(user, Resource.resourceFromEntityType((EntityType)((EntityId)entity.getId()).getEntityType()), operation, (EntityId)entity.getId(), entity);
        return entity;
    }

    Device checkDeviceId(DeviceId deviceId, Operation operation) throws ThingsboardException {
        return (Device)this.checkEntityId((EntityId)deviceId, (arg_0, arg_1) -> ((DeviceService)this.deviceService).findDeviceById(arg_0, arg_1), operation);
    }

    DeviceInfo checkDeviceInfoId(DeviceId deviceId, Operation operation) throws ThingsboardException {
        return (DeviceInfo)this.checkEntityId((EntityId)deviceId, (arg_0, arg_1) -> ((DeviceService)this.deviceService).findDeviceInfoById(arg_0, arg_1), operation);
    }

    DeviceProfile checkDeviceProfileId(DeviceProfileId deviceProfileId, Operation operation) throws ThingsboardException {
        return (DeviceProfile)this.checkEntityId((EntityId)deviceProfileId, (arg_0, arg_1) -> ((DeviceProfileService)this.deviceProfileService).findDeviceProfileById(arg_0, arg_1), operation);
    }

    protected EntityView checkEntityViewId(EntityViewId entityViewId, Operation operation) throws ThingsboardException {
        return (EntityView)this.checkEntityId((EntityId)entityViewId, (arg_0, arg_1) -> ((EntityViewService)this.entityViewService).findEntityViewById(arg_0, arg_1), operation);
    }

    protected EntityViewInfo checkEntityViewInfoId(EntityViewId entityViewId, Operation operation) throws ThingsboardException {
        return (EntityViewInfo)this.checkEntityId((EntityId)entityViewId, (arg_0, arg_1) -> ((EntityViewService)this.entityViewService).findEntityViewInfoById(arg_0, arg_1), operation);
    }

    protected Role checkRoleId(RoleId roleId, Operation operation) throws ThingsboardException {
        return (Role)this.checkEntityId((EntityId)roleId, (arg_0, arg_1) -> ((RoleService)this.roleService).findRoleById(arg_0, arg_1), operation);
    }

    GroupPermission checkGroupPermissionId(GroupPermissionId groupPermissionId, Operation operation) throws ThingsboardException {
        return (GroupPermission)this.checkEntityId((EntityId)groupPermissionId, (arg_0, arg_1) -> ((GroupPermissionService)this.groupPermissionService).findGroupPermissionById(arg_0, arg_1), operation);
    }

    GroupPermissionInfo checkGroupPermissionInfoId(GroupPermissionId groupPermissionId, Operation operation, boolean isUserGroup) throws ThingsboardException {
        return (GroupPermissionInfo)this.checkEntityId((EntityId)groupPermissionId, (tenantId, id) -> (GroupPermissionInfo)this.groupPermissionService.findGroupPermissionInfoByIdAsync(this.getTenantId(), groupPermissionId, isUserGroup).get(), operation);
    }

    Asset checkAssetId(AssetId assetId, Operation operation) throws ThingsboardException {
        return (Asset)this.checkEntityId((EntityId)assetId, (arg_0, arg_1) -> ((AssetService)this.assetService).findAssetById(arg_0, arg_1), operation);
    }

    AssetInfo checkAssetInfoId(AssetId assetId, Operation operation) throws ThingsboardException {
        return (AssetInfo)this.checkEntityId((EntityId)assetId, (arg_0, arg_1) -> ((AssetService)this.assetService).findAssetInfoById(arg_0, arg_1), operation);
    }

    Integration checkIntegrationId(IntegrationId integrationId, Operation operation) throws ThingsboardException {
        return (Integration)this.checkEntityId((EntityId)integrationId, (arg_0, arg_1) -> ((IntegrationService)this.integrationService).findIntegrationById(arg_0, arg_1), operation);
    }

    Converter checkConverterId(ConverterId converterId, Operation operation) throws ThingsboardException {
        return (Converter)this.checkEntityId((EntityId)converterId, (arg_0, arg_1) -> ((ConverterService)this.converterService).findConverterById(arg_0, arg_1), operation);
    }

    AssetProfile checkAssetProfileId(AssetProfileId assetProfileId, Operation operation) throws ThingsboardException {
        return (AssetProfile)this.checkEntityId((EntityId)assetProfileId, (arg_0, arg_1) -> ((AssetProfileService)this.assetProfileService).findAssetProfileById(arg_0, arg_1), operation);
    }

    Alarm checkAlarmId(AlarmId alarmId, Operation operation) throws ThingsboardException {
        return (Alarm)this.checkEntityId((EntityId)alarmId, (arg_0, arg_1) -> ((AlarmSubscriptionService)this.alarmService).findAlarmById(arg_0, arg_1), operation);
    }

    AlarmComment checkAlarmCommentId(AlarmCommentId alarmCommentId, AlarmId alarmId) throws ThingsboardException {
        try {
            Validator.validateId((UUIDBased)alarmCommentId, id -> "Incorrect alarmCommentId " + String.valueOf(id));
            AlarmComment alarmComment = (AlarmComment)this.alarmCommentService.findAlarmCommentByIdAsync(this.getCurrentUser().getTenantId(), alarmCommentId).get();
            this.checkNotNull((Object)alarmComment, "Alarm comment with id [" + String.valueOf(alarmCommentId) + "] is not found");
            if (!alarmId.equals((Object)alarmComment.getAlarmId())) {
                throw new ThingsboardException("Alarm id does not match with comment alarm id", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
            }
            return alarmComment;
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    AlarmInfo checkAlarmInfoId(AlarmId alarmId, Operation operation) throws ThingsboardException {
        return (AlarmInfo)this.checkEntityId((EntityId)alarmId, (arg_0, arg_1) -> ((AlarmSubscriptionService)this.alarmService).findAlarmInfoById(arg_0, arg_1), operation);
    }

    WidgetsBundle checkWidgetsBundleId(WidgetsBundleId widgetsBundleId, Operation operation) throws ThingsboardException {
        return (WidgetsBundle)this.checkEntityId((EntityId)widgetsBundleId, (arg_0, arg_1) -> ((WidgetsBundleService)this.widgetsBundleService).findWidgetsBundleById(arg_0, arg_1), operation);
    }

    WidgetTypeDetails checkWidgetTypeId(WidgetTypeId widgetTypeId, Operation operation) throws ThingsboardException {
        return (WidgetTypeDetails)this.checkEntityId((EntityId)widgetTypeId, (arg_0, arg_1) -> ((WidgetTypeService)this.widgetTypeService).findWidgetTypeDetailsById(arg_0, arg_1), operation);
    }

    WidgetTypeInfo checkWidgetTypeInfoId(WidgetTypeId widgetTypeId, Operation operation) throws ThingsboardException {
        return (WidgetTypeInfo)this.checkEntityId((EntityId)widgetTypeId, (arg_0, arg_1) -> ((WidgetTypeService)this.widgetTypeService).findWidgetTypeInfoById(arg_0, arg_1), operation);
    }

    Dashboard checkDashboardId(DashboardId dashboardId, Operation operation) throws ThingsboardException {
        return (Dashboard)this.checkEntityId((EntityId)dashboardId, (arg_0, arg_1) -> ((DashboardService)this.dashboardService).findDashboardById(arg_0, arg_1), operation);
    }

    Edge checkEdgeId(EdgeId edgeId, Operation operation) throws ThingsboardException {
        return (Edge)this.checkEntityId((EntityId)edgeId, (arg_0, arg_1) -> ((EdgeService)this.edgeService).findEdgeById(arg_0, arg_1), operation);
    }

    EdgeInfo checkEdgeInfoId(EdgeId edgeId, Operation operation) throws ThingsboardException {
        return (EdgeInfo)this.checkEntityId((EntityId)edgeId, (arg_0, arg_1) -> ((EdgeService)this.edgeService).findEdgeInfoById(arg_0, arg_1), operation);
    }

    DashboardInfo checkDashboardInfoId(DashboardId dashboardId, Operation operation) throws ThingsboardException {
        return (DashboardInfo)this.checkEntityId((EntityId)dashboardId, (arg_0, arg_1) -> ((DashboardService)this.dashboardService).findDashboardInfoById(arg_0, arg_1), operation);
    }

    ComponentDescriptor checkComponentDescriptorByClazz(String clazz) throws ThingsboardException {
        try {
            this.log.debug("[{}] Lookup component descriptor", (Object)clazz);
            return (ComponentDescriptor)this.checkNotNull(this.componentDescriptorService.getComponent(clazz));
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    List<ComponentDescriptor> checkComponentDescriptorsByType(ComponentType type, RuleChainType ruleChainType) throws ThingsboardException {
        try {
            this.log.debug("[{}] Lookup component descriptors", (Object)type);
            return this.componentDescriptorService.getComponents(type, ruleChainType);
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    List<ComponentDescriptor> checkComponentDescriptorsByTypes(Set<ComponentType> types, RuleChainType ruleChainType) throws ThingsboardException {
        try {
            this.log.debug("[{}] Lookup component descriptors", types);
            return this.componentDescriptorService.getComponents(types, ruleChainType);
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    protected RuleChain checkRuleChain(RuleChainId ruleChainId, Operation operation) throws ThingsboardException {
        return (RuleChain)this.checkEntityId((EntityId)ruleChainId, (arg_0, arg_1) -> ((RuleChainService)this.ruleChainService).findRuleChainById(arg_0, arg_1), operation);
    }

    protected EntityGroupInfo checkEntityGroupId(EntityGroupId entityGroupId, Operation operation) throws ThingsboardException {
        try {
            Validator.validateId((UUIDBased)entityGroupId, id -> "Incorrect entityGroupId " + String.valueOf(id));
            EntityGroupInfo entityGroup = this.entityGroupService.findEntityGroupInfoById(this.getTenantId(), entityGroupId);
            this.checkNotNull((Object)entityGroup, "Entity group with id [" + String.valueOf(entityGroupId) + "] is not found");
            this.accessControlService.checkEntityGroupInfoPermission(this.getCurrentUser(), operation, entityGroup);
            return entityGroup;
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    SchedulerEvent checkSchedulerEventId(SchedulerEventId schedulerEventId, Operation operation) throws ThingsboardException {
        return (SchedulerEvent)this.checkEntityId((EntityId)schedulerEventId, (arg_0, arg_1) -> ((SchedulerEventService)this.schedulerEventService).findSchedulerEventById(arg_0, arg_1), operation);
    }

    SchedulerEventWithCustomerInfo checkSchedulerEventInfoId(SchedulerEventId schedulerEventId, Operation operation) throws ThingsboardException {
        return (SchedulerEventWithCustomerInfo)this.checkEntityId((EntityId)schedulerEventId, (arg_0, arg_1) -> ((SchedulerEventService)this.schedulerEventService).findSchedulerEventWithCustomerInfoById(arg_0, arg_1), operation);
    }

    BlobEntity checkBlobEntityId(BlobEntityId blobEntityId, Operation operation) throws ThingsboardException {
        return (BlobEntity)this.checkEntityId((EntityId)blobEntityId, (arg_0, arg_1) -> ((BlobEntityService)this.blobEntityService).findBlobEntityById(arg_0, arg_1), operation);
    }

    BlobEntityWithCustomerInfo checkBlobEntityInfoId(BlobEntityId blobEntityId, Operation operation) throws ThingsboardException {
        return (BlobEntityWithCustomerInfo)this.checkEntityId((EntityId)blobEntityId, (arg_0, arg_1) -> ((BlobEntityService)this.blobEntityService).findBlobEntityWithCustomerInfoById(arg_0, arg_1), operation);
    }

    ReportTemplate checkReportTemplateId(ReportTemplateId reportTemplateId, Operation operation) throws ThingsboardException {
        return (ReportTemplate)this.checkEntityId((EntityId)reportTemplateId, (arg_0, arg_1) -> ((ReportTemplateService)this.reportTemplateService).findReportTemplateById(arg_0, arg_1), operation);
    }

    ReportTemplateInfo checkReportTemplateInfoId(ReportTemplateId reportTemplateId, Operation operation) throws ThingsboardException {
        return (ReportTemplateInfo)this.checkEntityId((EntityId)reportTemplateId, (arg_0, arg_1) -> ((ReportTemplateService)this.reportTemplateService).findReportTemplateInfoById(arg_0, arg_1), operation);
    }

    Report checkReportId(ReportId reportId, Operation operation) throws ThingsboardException {
        return (Report)this.checkEntityId((EntityId)reportId, (arg_0, arg_1) -> ((ReportService)this.reportService).findReportById(arg_0, arg_1), operation);
    }

    protected RuleNode checkRuleNode(RuleNodeId ruleNodeId, Operation operation) throws ThingsboardException {
        Validator.validateId((UUIDBased)ruleNodeId, id -> "Incorrect ruleNodeId " + String.valueOf(id));
        RuleNode ruleNode = this.ruleChainService.findRuleNodeById(this.getTenantId(), ruleNodeId);
        this.checkNotNull((Object)ruleNode, "Rule node with id [" + String.valueOf(ruleNodeId) + "] is not found");
        this.checkRuleChain(ruleNode.getRuleChainId(), operation);
        return ruleNode;
    }

    TbResource checkResourceId(TbResourceId resourceId, Operation operation) throws ThingsboardException {
        return (TbResource)this.checkEntityId((EntityId)resourceId, (arg_0, arg_1) -> ((ResourceService)this.resourceService).findResourceById(arg_0, arg_1), operation);
    }

    TbResourceInfo checkResourceInfoId(TbResourceId resourceId, Operation operation) throws ThingsboardException {
        return (TbResourceInfo)this.checkEntityId((EntityId)resourceId, (arg_0, arg_1) -> ((ResourceService)this.resourceService).findResourceInfoById(arg_0, arg_1), operation);
    }

    protected ThingsboardException permissionDenied() {
        return new ThingsboardException("You don't have permission to perform this operation!", ThingsboardErrorCode.PERMISSION_DENIED);
    }

    OtaPackage checkOtaPackageId(OtaPackageId otaPackageId, Operation operation) throws ThingsboardException {
        return (OtaPackage)this.checkEntityId((EntityId)otaPackageId, (arg_0, arg_1) -> ((OtaPackageService)this.otaPackageService).findOtaPackageById(arg_0, arg_1), operation);
    }

    OtaPackageInfo checkOtaPackageInfoId(OtaPackageId otaPackageId, Operation operation) throws ThingsboardException {
        return (OtaPackageInfo)this.checkEntityId((EntityId)otaPackageId, (arg_0, arg_1) -> ((OtaPackageService)this.otaPackageService).findOtaPackageInfoById(arg_0, arg_1), operation);
    }

    Rpc checkRpcId(RpcId rpcId) throws ThingsboardException {
        try {
            Validator.validateId((UUIDBased)rpcId, id -> "Incorrect rpcId " + String.valueOf(id));
            Rpc rpc = this.rpcService.findById(this.getCurrentUser().getTenantId(), rpcId);
            this.checkNotNull((Object)rpc, "RPC with id [" + String.valueOf(rpcId) + "] is not found");
            this.checkDeviceId(rpc.getDeviceId(), Operation.RPC_CALL);
            return rpc;
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e, false);
        }
    }

    protected Queue checkQueueId(QueueId queueId, Operation operation) throws ThingsboardException {
        TenantProfile tenantProfile;
        Queue queue = (Queue)this.checkEntityId((EntityId)queueId, (arg_0, arg_1) -> ((QueueService)this.queueService).findQueueById(arg_0, arg_1), operation);
        TenantId tenantId = this.getTenantId();
        if (queue.getTenantId().isNullUid() && !tenantId.isNullUid() && (tenantProfile = this.tenantProfileCache.get(tenantId)).isIsolatedTbRuleEngine()) {
            throw new ThingsboardException("You don't have permission to perform this operation!", ThingsboardErrorCode.PERMISSION_DENIED);
        }
        return queue;
    }

    OAuth2Client checkOauth2ClientId(OAuth2ClientId oAuth2ClientId, Operation operation) throws ThingsboardException {
        return (OAuth2Client)this.checkEntityId((EntityId)oAuth2ClientId, (arg_0, arg_1) -> ((OAuth2ClientService)this.oAuth2ClientService).findOAuth2ClientById(arg_0, arg_1), operation);
    }

    Domain checkDomainId(DomainId domainId, Operation operation) throws ThingsboardException {
        return (Domain)this.checkEntityId((EntityId)domainId, (arg_0, arg_1) -> ((DomainService)this.domainService).findDomainById(arg_0, arg_1), operation);
    }

    MobileApp checkMobileAppId(MobileAppId mobileAppId, Operation operation) throws ThingsboardException {
        return (MobileApp)this.checkEntityId((EntityId)mobileAppId, (arg_0, arg_1) -> ((MobileAppService)this.mobileAppService).findMobileAppById(arg_0, arg_1), operation);
    }

    MobileAppBundle checkMobileAppBundleId(MobileAppBundleId mobileAppBundleId, Operation operation) throws ThingsboardException {
        return (MobileAppBundle)this.checkEntityId((EntityId)mobileAppBundleId, (arg_0, arg_1) -> ((MobileAppBundleService)this.mobileAppBundleService).findMobileAppBundleById(arg_0, arg_1), operation);
    }

    NotificationTarget checkNotificationTargetId(NotificationTargetId notificationTargetId, Operation operation) throws ThingsboardException {
        return (NotificationTarget)this.checkEntityId((EntityId)notificationTargetId, (arg_0, arg_1) -> ((NotificationTargetService)this.notificationTargetService).findNotificationTargetById(arg_0, arg_1), operation);
    }

    Job checkJobId(JobId jobId, Operation operation) throws ThingsboardException {
        return (Job)this.checkEntityId((EntityId)jobId, (arg_0, arg_1) -> ((JobService)this.jobService).findJobById(arg_0, arg_1), operation);
    }

    SecretInfo checkSecretId(SecretId secretId, Operation operation) throws ThingsboardException {
        return (SecretInfo)this.checkEntityId((EntityId)secretId, (arg_0, arg_1) -> ((SecretService)this.secretService).findSecretInfoById(arg_0, arg_1), operation);
    }

    AiModel checkAiModelId(AiModelId modelId, Operation operation) throws ThingsboardException {
        return (AiModel)this.checkEntityId((EntityId)modelId, (tenantId, id) -> this.aiModelService.findAiModelByTenantIdAndId(tenantId, id).orElse(null), operation);
    }

    protected <I extends EntityId> I emptyId(EntityType entityType) {
        return (I)EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)ModelConstants.NULL_UUID);
    }

    public static Exception toException(Throwable error) {
        return error != null ? (Exception.class.isInstance(error) ? (Exception)error : new Exception(error)) : null;
    }

    protected <E extends HasName & HasId<? extends EntityId>> void logEntityAction(SecurityUser user, EntityType entityType, E savedEntity, ActionType actionType) {
        this.logEntityAction(user, entityType, null, savedEntity, actionType, null);
    }

    protected <E extends HasName & HasId<? extends EntityId>> void logEntityAction(SecurityUser user, EntityType entityType, E entity, E savedEntity, ActionType actionType, Exception e) {
        EntityId entityId;
        EntityId entityId2 = entityId = savedEntity != null ? (EntityId)((HasId<? extends EntityId>)savedEntity).getId() : this.emptyId(entityType);
        if (!user.isSystemAdmin()) {
            this.entityActionService.logEntityAction((User)user, entityId, savedEntity != null ? savedEntity : entity, user.getCustomerId(), actionType, e, new Object[0]);
        }
    }

    protected MergedUserPermissions getMergedUserPermissions(User user, boolean isPublic) {
        try {
            return this.userPermissionsService.getMergedPermissions(user, isPublic);
        }
        catch (Exception e) {
            throw new BadCredentialsException("Failed to get user permissions", (Throwable)e);
        }
    }

    protected <E> PageData<E> toPageData(List<E> entities, PageLink pageLink) {
        int totalElements = entities.size();
        int totalPages = pageLink.getPageSize() > 0 ? (int)Math.ceil((float)totalElements / (float)pageLink.getPageSize()) : 1;
        boolean hasNext = false;
        if (pageLink.getPageSize() > 0) {
            int startIndex = pageLink.getPageSize() * pageLink.getPage();
            int endIndex = startIndex + pageLink.getPageSize();
            if (entities.size() <= startIndex) {
                entities = Collections.emptyList();
            } else {
                if (endIndex > entities.size()) {
                    endIndex = entities.size();
                }
                entities = new ArrayList<Object>(entities.subList(startIndex, endIndex));
            }
            hasNext = totalElements > startIndex + entities.size();
        }
        return new PageData(entities, totalPages, (long)totalElements, hasNext);
    }

    protected <E extends HasName & HasId<? extends EntityId>> E doSaveAndLog(EntityType entityType, E entity, BiFunction<TenantId, E, E> savingFunction) throws Exception {
        ActionType actionType = ((HasId<? extends EntityId>)entity).getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        SecurityUser user = this.getCurrentUser();
        try {
            HasName savedEntity = (HasName)savingFunction.apply(user.getTenantId(), entity);
            this.logEntityAction(user, entityType, savedEntity, actionType);
            return (E)savedEntity;
        }
        catch (Exception e) {
            this.logEntityAction(user, entityType, entity, null, actionType, e);
            throw e;
        }
    }

    protected <E extends HasName & HasId<I>, I extends EntityId> void doDeleteAndLog(EntityType entityType, E entity, BiConsumer<TenantId, I> deleteFunction) throws Exception {
        SecurityUser user = this.getCurrentUser();
        try {
            deleteFunction.accept(user.getTenantId(), (EntityId)((HasId<I>)entity).getId());
            this.logEntityAction(user, entityType, entity, ActionType.DELETED);
        }
        catch (Exception e) {
            this.logEntityAction(user, entityType, entity, entity, ActionType.DELETED, e);
            throw e;
        }
    }

    protected void checkUserInfo(User user) throws ThingsboardException {
        ObjectNode info;
        JsonNode jsonNode = user.getAdditionalInfo();
        if (jsonNode instanceof ObjectNode) {
            ObjectNode additionalInfo;
            info = additionalInfo = (ObjectNode)jsonNode;
            this.checkDashboardInfo((JsonNode)info);
        } else {
            info = JacksonUtil.newObjectNode();
            user.setAdditionalInfo((JsonNode)info);
        }
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(user.getTenantId(), user.getId());
        info.put("userCredentialsEnabled", userCredentials.isEnabled());
        info.put("userActivated", userCredentials.getActivateToken() == null);
        info.put("lastLoginTs", userCredentials.getLastLoginTs());
    }

    protected void checkDashboardInfo(JsonNode additionalInfo) throws ThingsboardException {
        this.checkDashboardInfo(additionalInfo, "defaultDashboardId");
        this.checkDashboardInfo(additionalInfo, HOME_DASHBOARD_ID);
    }

    protected void checkDashboardInfo(JsonNode node, String dashboardField) throws ThingsboardException {
        ObjectNode additionalInfo;
        DashboardId dashboardId;
        if (node instanceof ObjectNode && (dashboardId = (DashboardId)Optional.ofNullable((additionalInfo = (ObjectNode)node).get(dashboardField)).filter(JsonNode::isTextual).map(JsonNode::asText).map(id -> {
            try {
                return new DashboardId(UUID.fromString(id));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).orElse(null)) != null && !this.dashboardService.existsById(this.getTenantId(), dashboardId)) {
            additionalInfo.remove(dashboardField);
        }
    }

    private CalculatedField checkCalculatedFieldId(CalculatedFieldId calculatedFieldId, Operation operation) throws ThingsboardException {
        Validator.validateId((UUIDBased)calculatedFieldId, (String)"Invalid entity id");
        SecurityUser user = this.getCurrentUser();
        CalculatedField cf = this.calculatedFieldService.findById(user.getTenantId(), calculatedFieldId);
        this.checkNotNull((Object)cf, calculatedFieldId.getEntityType().getNormalName() + " with id [" + String.valueOf(calculatedFieldId) + "] is not found");
        this.checkEntityId(cf.getEntityId(), operation);
        return cf;
    }

    protected HomeDashboardInfo getHomeDashboardInfo(SecurityUser securityUser, JsonNode additionalInfo) {
        HomeDashboardInfo homeDashboardInfo = this.extractHomeDashboardInfoFromAdditionalInfo(additionalInfo);
        if (homeDashboardInfo == null) {
            if (securityUser.isCustomerUser()) {
                Customer customer = this.customerService.findCustomerById(securityUser.getTenantId(), securityUser.getCustomerId());
                homeDashboardInfo = this.extractHomeDashboardInfoFromAdditionalInfo(customer.getAdditionalInfo());
            }
            if (homeDashboardInfo == null) {
                Tenant tenant = this.tenantService.findTenantById(securityUser.getTenantId());
                homeDashboardInfo = this.extractHomeDashboardInfoFromAdditionalInfo(tenant.getAdditionalInfo());
            }
        }
        return homeDashboardInfo;
    }

    private HomeDashboardInfo extractHomeDashboardInfoFromAdditionalInfo(JsonNode additionalInfo) {
        try {
            if (additionalInfo != null && additionalInfo.has(HOME_DASHBOARD_ID) && !additionalInfo.get(HOME_DASHBOARD_ID).isNull()) {
                String strDashboardId = additionalInfo.get(HOME_DASHBOARD_ID).asText();
                DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
                this.checkDashboardId(dashboardId, Operation.READ);
                boolean hideDashboardToolbar = true;
                if (additionalInfo.has(HOME_DASHBOARD_HIDE_TOOLBAR)) {
                    hideDashboardToolbar = additionalInfo.get(HOME_DASHBOARD_HIDE_TOOLBAR).asBoolean();
                }
                return new HomeDashboardInfo(dashboardId, hideDashboardToolbar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected MediaType parseMediaType(String contentType) {
        try {
            return MediaType.parseMediaType((String)contentType);
        }
        catch (Exception e) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }

    protected void throwRealCause(ExecutionException e) throws Exception {
        if (e.getCause() != null && e.getCause() instanceof Exception) {
            throw (Exception)e.getCause();
        }
        throw e;
    }

    protected <T> DeferredResult<T> wrapFuture(ListenableFuture<T> future) {
        DeferredResult deferredResult = new DeferredResult();
        DonAsynchron.withCallback(future, arg_0 -> ((DeferredResult)deferredResult).setResult(arg_0), arg_0 -> ((DeferredResult)deferredResult).setErrorResult(arg_0));
        return deferredResult;
    }

    protected <T> DeferredResult<T> wrapFuture(ListenableFuture<T> future, long timeoutMs) {
        DeferredResult deferredResult = new DeferredResult(Long.valueOf(timeoutMs));
        DonAsynchron.withCallback(future, arg_0 -> ((DeferredResult)deferredResult).setResult(arg_0), arg_0 -> ((DeferredResult)deferredResult).setErrorResult(arg_0));
        return deferredResult;
    }

    protected EntityDataSortOrder createEntityDataSortOrder(String sortProperty, String sortOrder) {
        if (StringUtils.isNotEmpty((String)sortProperty)) {
            EntityDataSortOrder entityDataSortOrder = new EntityDataSortOrder();
            entityDataSortOrder.setKey(new EntityKey(EntityKeyType.ENTITY_FIELD, sortProperty));
            if (StringUtils.isNotEmpty((String)sortOrder)) {
                entityDataSortOrder.setDirection(EntityDataSortOrder.Direction.valueOf((String)sortOrder));
            }
            return entityDataSortOrder;
        }
        return null;
    }

    protected void compressResponseWithGzipIFAccepted(String acceptEncodingHeader, HttpServletResponse response, byte[] content) throws IOException {
        if (StringUtils.isNotEmpty((String)acceptEncodingHeader) && acceptEncodingHeader.contains("gzip")) {
            response.setHeader("Content-Encoding", "gzip");
            response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());){
                gzipOutputStream.write(content);
                gzipOutputStream.finish();
            }
        }
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(content);
            outputStream.flush();
        }
    }

    protected <T> ResponseEntity<T> response(HttpStatus status) {
        return ResponseEntity.status((HttpStatusCode)status).build();
    }

    protected <T> ResponseEntity<T> redirectTo(String location) {
        URI uri;
        try {
            uri = URI.create(location);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Failed to create URI from '{}'", (Object)location, (Object)e);
            throw e;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.SEE_OTHER).location(uri)).build();
    }

    protected List<OAuth2ClientId> getOAuth2ClientIds(UUID[] ids) throws ThingsboardException {
        if (ids == null) {
            return Collections.emptyList();
        }
        ArrayList<OAuth2ClientId> oAuth2ClientIds = new ArrayList<OAuth2ClientId>();
        for (UUID id : ids) {
            OAuth2ClientId oauth2ClientId = new OAuth2ClientId(id);
            this.checkOauth2ClientId(oauth2ClientId, Operation.READ);
            oAuth2ClientIds.add(oauth2ClientId);
        }
        return oAuth2ClientIds;
    }

    @Generated
    public boolean isLogControllerErrorStackTrace() {
        return this.logControllerErrorStackTrace;
    }

    @Generated
    public boolean isEdgesEnabled() {
        return this.edgesEnabled;
    }
}

