/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.asset.AssetProfileInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.asset.profile.TbAssetProfileService;
import org.thingsboard.server.service.security.model.SecurityUser;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class AssetProfileController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetProfileController.class);
    private final TbAssetProfileService tbAssetProfileService;
    private final ImageService imageService;

    @ApiOperation(value="Get Asset Profile (getAssetProfileById)", notes="Fetch the Asset Profile object based on the provided Asset Profile Id. The server checks that the asset profile is owned by the same tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/assetProfile/{assetProfileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AssetProfile getAssetProfileById(@Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetProfileId") String strAssetProfileId, @Parameter(description="Inline images as a data URL (Base64)") @RequestParam(value="inlineImages", required=false) boolean inlineImages) throws ThingsboardException {
        this.checkParameter("assetProfileId", strAssetProfileId);
        AssetProfileId assetProfileId = new AssetProfileId(this.toUUID(strAssetProfileId));
        AssetProfile result = this.checkAssetProfileId(assetProfileId, Operation.READ);
        if (inlineImages) {
            result = (AssetProfile)this.imageService.inlineImage((HasImage)result);
        }
        return result;
    }

    @ApiOperation(value="Get Asset Profile Info (getAssetProfileInfoById)", notes="Fetch the Asset Profile Info object based on the provided Asset Profile Id. Asset Profile Info is a lightweight object that includes main information about Asset Profile. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assetProfileInfo/{assetProfileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AssetProfileInfo getAssetProfileInfoById(@Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetProfileId") String strAssetProfileId) throws ThingsboardException {
        this.checkParameter("assetProfileId", strAssetProfileId);
        AssetProfileId assetProfileId = new AssetProfileId(this.toUUID(strAssetProfileId));
        AssetProfileInfo assetProfileInfo = (AssetProfileInfo)this.checkNotNull((Object)this.assetProfileService.findAssetProfileInfoById(this.getTenantId(), assetProfileId));
        if (!this.getTenantId().equals((Object)assetProfileInfo.getTenantId())) {
            throw this.permissionDenied();
        }
        return assetProfileInfo;
    }

    @ApiOperation(value="Get Default Asset Profile (getDefaultAssetProfileInfo)", notes="Fetch the Default Asset Profile Info object. Asset Profile Info is a lightweight object that includes main information about Asset Profile. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assetProfileInfo/default"}, method={RequestMethod.GET})
    @ResponseBody
    public AssetProfileInfo getDefaultAssetProfileInfo() throws ThingsboardException {
        return (AssetProfileInfo)this.checkNotNull((Object)this.assetProfileService.findDefaultAssetProfileInfo(this.getTenantId()));
    }

    @ApiOperation(value="Create Or Update Asset Profile (saveAssetProfile)", notes="Create or update the Asset Profile. When creating asset profile, platform generates asset profile id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created asset profile id will be present in the response. Specify existing asset profile id to update the asset profile. Referencing non-existing asset profile Id will cause 'Not Found' error. \n\nAsset profile name is unique in the scope of tenant. Only one 'default' asset profile may exist in scope of tenant. Remove 'id', 'tenantId' from the request body example (below) to create new Asset Profile entity. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/assetProfile"}, method={RequestMethod.POST})
    @ResponseBody
    public AssetProfile saveAssetProfile(@Parameter(description="A JSON value representing the asset profile.") @RequestBody AssetProfile assetProfile) throws Exception {
        assetProfile.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)assetProfile.getId(), (TenantEntity)assetProfile, Resource.ASSET_PROFILE, null);
        return this.tbAssetProfileService.save(assetProfile, this.getCurrentUser());
    }

    @ApiOperation(value="Delete asset profile (deleteAssetProfile)", notes="Deletes the asset profile. Referencing non-existing asset profile Id will cause an error. Can't delete the asset profile if it is referenced by existing assets.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/assetProfile/{assetProfileId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteAssetProfile(@Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetProfileId") String strAssetProfileId) throws ThingsboardException {
        this.checkParameter("assetProfileId", strAssetProfileId);
        AssetProfileId assetProfileId = new AssetProfileId(this.toUUID(strAssetProfileId));
        AssetProfile assetProfile = this.checkAssetProfileId(assetProfileId, Operation.DELETE);
        this.tbAssetProfileService.delete(assetProfile, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Make Asset Profile Default (setDefaultAssetProfile)", notes="Marks asset profile as default within a tenant scope.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/assetProfile/{assetProfileId}/default"}, method={RequestMethod.POST})
    @ResponseBody
    public AssetProfile setDefaultAssetProfile(@Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetProfileId") String strAssetProfileId) throws ThingsboardException {
        this.checkParameter("assetProfileId", strAssetProfileId);
        AssetProfileId assetProfileId = new AssetProfileId(this.toUUID(strAssetProfileId));
        AssetProfile assetProfile = this.checkAssetProfileId(assetProfileId, Operation.WRITE);
        AssetProfile previousDefaultAssetProfile = this.assetProfileService.findDefaultAssetProfile(this.getTenantId());
        return this.tbAssetProfileService.setDefaultAssetProfile(assetProfile, previousDefaultAssetProfile, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Asset Profiles (getAssetProfiles)", notes="Returns a page of asset profile objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/assetProfiles"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AssetProfile> getAssetProfiles(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the asset profile name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "description", "isDefault"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET_PROFILE, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.assetProfileService.findAssetProfiles(this.getTenantId(), pageLink));
    }

    @ApiOperation(value="Get Asset Profile infos (getAssetProfileInfos)", notes="Returns a page of asset profile info objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. Asset Profile Info is a lightweight object that includes main information about Asset Profile. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assetProfileInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AssetProfileInfo> getAssetProfileInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the asset profile name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "description", "isDefault"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET_PROFILE, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.assetProfileService.findAssetProfileInfos(this.getTenantId(), pageLink));
    }

    @ApiOperation(value="Get Asset Profiles By Ids (getAssetProfilesByIds)", notes="Requested asset profiles must be owned by tenant which is performing the request. \n\n Security check is performed to verify that the user has 'READ' permission for the entity (entities).")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/assetProfileInfos"}, params={"assetProfileIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AssetProfileInfo> getAssetProfilesByIds(@Parameter(description="A list of asset profile ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string")), required=true) @RequestParam(value="assetProfileIds") String[] strAssetProfileIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("assetProfileIds", strAssetProfileIds);
        if (!this.accessControlService.hasPermission(this.getCurrentUser(), Resource.ASSET_PROFILE, Operation.READ)) {
            return Collections.emptyList();
        }
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ArrayList<AssetProfileId> assetProfileIds = new ArrayList<AssetProfileId>();
        for (String strAssetProfileId : strAssetProfileIds) {
            assetProfileIds.add(new AssetProfileId(this.toUUID(strAssetProfileId)));
        }
        return (List)this.checkNotNull((Object)((List)this.assetProfileService.findAssetProfilesByIdsAsync(tenantId, assetProfileIds).get()));
    }

    @ApiOperation(value="Get Asset Profile names (getAssetProfileNames)", notes="Returns a set of unique asset profile names owned by the tenant.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assetProfile/names"}, method={RequestMethod.GET})
    @ResponseBody
    public List<EntityInfo> getAssetProfileNames(@Parameter(description="Flag indicating whether to retrieve exclusively the names of asset profiles that are referenced by tenant's assets.") @RequestParam(value="activeOnly", required=false, defaultValue="false") boolean activeOnly) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        return (List)this.checkNotNull((Object)this.assetProfileService.findAssetProfileNamesByTenantId(tenantId, activeOnly));
    }

    @ConstructorProperties(value={"tbAssetProfileService", "imageService"})
    @Generated
    public AssetProfileController(TbAssetProfileService tbAssetProfileService, ImageService imageService) {
        this.tbAssetProfileService = tbAssetProfileService;
        this.imageService = imageService;
    }
}

