/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.FeaturesInfo;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.LicenseInfo;
import org.thingsboard.server.common.data.LicenseUsageInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.SystemInfo;
import org.thingsboard.server.common.data.UpdateMessage;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.common.data.security.model.JwtSettings;
import org.thingsboard.server.common.data.security.model.SecuritySettings;
import org.thingsboard.server.common.data.sms.config.TestSmsRequest;
import org.thingsboard.server.common.data.sync.vc.AutoCommitSettings;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.sync.vc.RepositorySettingsInfo;
import org.thingsboard.server.common.data.sync.vc.VcUtils;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.audit.AuditLogService;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.settings.SecuritySettingsService;
import org.thingsboard.server.dao.subscription.SubscriptionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;
import org.thingsboard.server.service.security.auth.oauth2.CookieUtils;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.system.SystemSecurityService;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;
import org.thingsboard.server.service.sync.vc.autocommit.TbAutoCommitSettingsService;
import org.thingsboard.server.service.system.SystemInfoService;
import org.thingsboard.server.service.update.UpdateService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/admin"})
public class AdminController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);
    private final MailService mailService;
    private final SmsService smsService;
    private final AdminSettingsService adminSettingsService;
    private final SystemSecurityService systemSecurityService;
    private final SecuritySettingsService securitySettingsService;
    private final JwtSettingsService jwtSettingsService;
    private final JwtTokenFactory tokenFactory;
    private final EntitiesVersionControlService versionControlService;
    private final TbAutoCommitSettingsService autoCommitSettingsService;
    private final UpdateService updateService;
    private final SystemInfoService systemInfoService;
    private final SubscriptionService subscriptionService;
    private final AuditLogService auditLogService;
    private final SecretConfigurationService secretConfigurationService;
    private final TbTransactionalCache<String, TenantId> oauth2StateCache;
    private static final String PREV_URI_PATH_PARAMETER = "prevUri";
    private static final String PREV_URI_COOKIE_NAME = "prev_uri";
    private static final String STATE_COOKIE_NAME = "state";
    private static final String MAIL_SETTINGS_KEY = "mail";
    protected static final String RESOURCE_READ_CHECK = "\n\nSecurity check is performed to verify that the user has 'READ' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.";
    protected static final String RESOURCE_WRITE_CHECK = "\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.";
    @Value(value="${queue.vc.request-timeout:180000}")
    private int vcRequestTimeout;

    @ApiOperation(value="Get the Administration Settings object using key (getAdminSettings)", notes="Get the Administration Settings object using specified string key. Referencing non-existing key will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'READ' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/settings/{key}"})
    public AdminSettings getAdminSettings(@Parameter(description="A string value of the key (e.g. 'general' or 'mail').") @PathVariable(value="key") String key, @Parameter(description="Use system settings if settings are not defined on tenant level.") @RequestParam(required=false, defaultValue="false") boolean systemByDefault) throws Exception {
        AdminSettings adminSettings;
        Authority authority = this.getCurrentUser().getAuthority();
        if (Authority.SYS_ADMIN.equals((Object)authority)) {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.READ);
            adminSettings = (AdminSettings)this.checkNotNull((Object)this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, key), "No Administration settings found for key: " + key);
        } else {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WHITE_LABELING, Operation.READ);
            adminSettings = this.getTenantAdminSettings(this.getTenantId(), key, systemByDefault);
        }
        if (adminSettings.getKey().equals(MAIL_SETTINGS_KEY)) {
            ((ObjectNode)adminSettings.getJsonValue()).remove("refreshToken");
        }
        return adminSettings;
    }

    @ApiOperation(value="Creates or Updates the Administration Settings (saveAdminSettings)", notes="Creates or Updates the Administration Settings. Platform generates random Administration Settings Id during settings creation. The Administration Settings Id will be present in the response. Specify the Administration Settings Id when you would like to update the Administration Settings. Referencing non-existing Administration Settings Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/settings"})
    public AdminSettings saveAdminSettings(@RequestBody(description="A JSON value representing the Administration Settings.") @org.springframework.web.bind.annotation.RequestBody AdminSettings adminSettings) throws Exception {
        Authority authority = this.getCurrentUser().getAuthority();
        TenantId tenantId = this.getTenantId();
        adminSettings.setTenantId(tenantId);
        if (Authority.SYS_ADMIN.equals((Object)authority)) {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.WRITE);
        } else {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WHITE_LABELING, Operation.WRITE);
        }
        adminSettings = (AdminSettings)this.checkNotNull((Object)this.adminSettingsService.saveAdminSettings(tenantId, adminSettings));
        if (adminSettings.getKey().equals(MAIL_SETTINGS_KEY)) {
            ((ObjectNode)adminSettings.getJsonValue()).remove("refreshToken");
        }
        return adminSettings;
    }

    @ApiOperation(value="Get the Security Settings object (getSecuritySettings)", notes="Get the Security Settings object that contains password policy, etc.\n\nAvailable for users with 'SYS_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'READ' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/securitySettings"})
    public SecuritySettings getSecuritySettings() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.READ);
        return (SecuritySettings)this.checkNotNull((Object)this.securitySettingsService.getSecuritySettings());
    }

    @ApiOperation(value="Update Security Settings (saveSecuritySettings)", notes="Updates the Security Settings object that contains password policy, etc.\n\nAvailable for users with 'SYS_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'WRITE' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @PostMapping(value={"/securitySettings"})
    public SecuritySettings saveSecuritySettings(@Parameter(description="A JSON value representing the Security Settings.") @org.springframework.web.bind.annotation.RequestBody SecuritySettings securitySettings) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.WRITE);
        securitySettings = (SecuritySettings)this.checkNotNull((Object)this.securitySettingsService.saveSecuritySettings(securitySettings));
        return securitySettings;
    }

    @ApiOperation(value="Get the JWT Settings object (getJwtSettings)", notes="Get the JWT Settings object that contains JWT token policy, etc. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/jwtSettings"})
    public JwtSettings getJwtSettings() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.READ);
        return (JwtSettings)this.checkNotNull((Object)this.jwtSettingsService.getJwtSettings());
    }

    @ApiOperation(value="Update JWT Settings (saveJwtSettings)", notes="Updates the JWT Settings object that contains JWT token policy, etc. The tokenSigningKey field is a Base64 encoded string.\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @PostMapping(value={"/jwtSettings"})
    public JwtPair saveJwtSettings(@Parameter(description="A JSON value representing the JWT Settings.") @org.springframework.web.bind.annotation.RequestBody JwtSettings jwtSettings) throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        this.accessControlService.checkPermission(securityUser, Resource.ADMIN_SETTINGS, Operation.WRITE);
        this.checkNotNull((Object)this.jwtSettingsService.saveJwtSettings(jwtSettings));
        return this.tokenFactory.createTokenPair(securityUser);
    }

    @ApiOperation(value="Send test email (sendTestMail)", notes="Attempts to send test email using Mail Settings provided as a parameter. Email is sent to the address specified in the profile of user who is performing the requestYou may change the 'To' email in the user profile of the System/Tenant Administrator. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'READ' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/settings/testMail"})
    public void sendTestMail(@Parameter(description="A JSON value representing the Mail Settings.") @org.springframework.web.bind.annotation.RequestBody AdminSettings adminSettings) throws Exception {
        Authority authority = this.getCurrentUser().getAuthority();
        if (Authority.SYS_ADMIN.equals((Object)authority)) {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.READ);
        } else {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.WHITE_LABELING, Operation.READ);
        }
        adminSettings = (AdminSettings)this.checkNotNull((Object)adminSettings);
        if (adminSettings.getKey().equals(MAIL_SETTINGS_KEY)) {
            AdminSettings mailSettings = Authority.SYS_ADMIN.equals((Object)authority) ? (AdminSettings)this.checkNotNull((Object)this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, MAIL_SETTINGS_KEY)) : this.getTenantAdminSettings(this.getTenantId(), MAIL_SETTINGS_KEY, false);
            if (adminSettings.getJsonValue().has("enableOauth2") && adminSettings.getJsonValue().get("enableOauth2").asBoolean()) {
                JsonNode refreshToken = mailSettings.getJsonValue().get("refreshToken");
                if (refreshToken == null) {
                    throw new ThingsboardException("Refresh token was not generated. Please, generate refresh token.", ThingsboardErrorCode.GENERAL);
                }
                ((ObjectNode)adminSettings.getJsonValue()).put("refreshToken", refreshToken.asText());
            } else if (!adminSettings.getJsonValue().has("password")) {
                ((ObjectNode)adminSettings.getJsonValue()).put("password", mailSettings.getJsonValue().get("password").asText());
            }
            String email = this.getCurrentUser().getEmail();
            try {
                this.mailService.sendTestMail(this.getTenantId(), adminSettings.getJsonValue(), email);
            }
            catch (ThingsboardException e) {
                Object error = e.getMessage();
                if (e.getCause() != null) {
                    error = (String)error + ": " + e.getCause().getMessage();
                }
                throw new ThingsboardException((String)error, e.getErrorCode());
            }
        }
    }

    @ApiOperation(value="Send test sms (sendTestSms)", notes="Attempts to send test sms to the System Administrator User using SMS Settings and phone number provided as a parameters of the request. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.\n\nSecurity check is performed to verify that the user has 'READ' permission for the 'ADMIN_SETTINGS' (for 'SYS_ADMIN' authority) or 'WHITE_LABELING' (for 'TENANT_ADMIN' authority) resource.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/settings/testSms"})
    public void sendTestSms(@Parameter(description="A JSON value representing the Test SMS request.") @org.springframework.web.bind.annotation.RequestBody TestSmsRequest testSmsRequest) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        if (Authority.SYS_ADMIN.equals((Object)user.getAuthority())) {
            this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.READ);
        } else {
            this.accessControlService.checkPermission(user, Resource.WHITE_LABELING, Operation.READ);
        }
        try {
            this.smsService.sendTestSms(user.getTenantId(), testSmsRequest);
            this.auditLogService.logEntityAction(user.getTenantId(), user.getCustomerId(), user.getId(), user.getName(), (EntityId)user.getId(), (HasName)user, ActionType.SMS_SENT, null, new Object[]{testSmsRequest.getNumberTo()});
        }
        catch (ThingsboardException e) {
            this.auditLogService.logEntityAction(user.getTenantId(), user.getCustomerId(), user.getId(), user.getName(), (EntityId)user.getId(), (HasName)user, ActionType.SMS_SENT, (Exception)((Object)e), new Object[]{testSmsRequest.getNumberTo()});
            throw e;
        }
    }

    @ApiOperation(value="Get repository settings (getRepositorySettings)", notes="Get the repository settings object. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/repositorySettings"})
    public RepositorySettings getRepositorySettings() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        return (RepositorySettings)this.checkNotNull((Object)this.versionControlService.getVersionControlSettings(this.getTenantId()));
    }

    @ApiOperation(value="Check repository settings exists (repositorySettingsExists)", notes="Check whether the repository settings exists. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/repositorySettings/exists"})
    public Boolean repositorySettingsExists() throws ThingsboardException {
        if (this.accessControlService.hasPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ)) {
            return this.versionControlService.getVersionControlSettings(this.getTenantId()) != null;
        }
        return false;
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/repositorySettings/info"})
    public RepositorySettingsInfo getRepositorySettingsInfo() throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        RepositorySettings repositorySettings = this.versionControlService.getVersionControlSettings(this.getTenantId());
        if (repositorySettings != null) {
            return RepositorySettingsInfo.builder().configured(true).readOnly(Boolean.valueOf(repositorySettings.isReadOnly())).build();
        }
        return RepositorySettingsInfo.builder().configured(false).build();
    }

    @ApiOperation(value="Creates or Updates the repository settings (saveRepositorySettings)", notes="Creates or Updates the repository settings object. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/repositorySettings"})
    public DeferredResult<RepositorySettings> saveRepositorySettings(@org.springframework.web.bind.annotation.RequestBody RepositorySettings settings) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.WRITE);
        settings.setLocalOnly(false);
        return this.wrapFuture(this.versionControlService.saveVersionControlSettings(this.getTenantId(), settings), (long)this.vcRequestTimeout);
    }

    @ApiOperation(value="Delete repository settings (deleteRepositorySettings)", notes="Deletes the repository settings.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/repositorySettings"})
    @ResponseStatus(value=HttpStatus.OK)
    public DeferredResult<Void> deleteRepositorySettings() throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.DELETE);
        return this.wrapFuture(this.versionControlService.deleteVersionControlSettings(this.getTenantId()), (long)this.vcRequestTimeout);
    }

    @ApiOperation(value="Check repository access (checkRepositoryAccess)", notes="Attempts to check repository access. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/repositorySettings/checkAccess"})
    public DeferredResult<Void> checkRepositoryAccess(@Parameter(description="A JSON value representing the Repository Settings.") @org.springframework.web.bind.annotation.RequestBody RepositorySettings settings) throws Exception {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        settings.setLocalOnly(false);
        return this.wrapFuture(this.versionControlService.checkVersionControlAccess(this.getTenantId(), settings), (long)this.vcRequestTimeout);
    }

    @ApiOperation(value="Get auto commit settings (getAutoCommitSettings)", notes="Get the auto commit settings object. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/autoCommitSettings"})
    public AutoCommitSettings getAutoCommitSettings() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ);
        return (AutoCommitSettings)this.checkNotNull((Object)this.autoCommitSettingsService.get(this.getTenantId()));
    }

    @ApiOperation(value="Check auto commit settings exists (autoCommitSettingsExists)", notes="Check whether the auto commit settings exists. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/autoCommitSettings/exists"})
    public Boolean autoCommitSettingsExists() throws ThingsboardException {
        if (this.accessControlService.hasPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.READ)) {
            return this.autoCommitSettingsService.get(this.getTenantId()) != null;
        }
        return false;
    }

    @ApiOperation(value="Creates or Updates the auto commit settings (saveAutoCommitSettings)", notes="Creates or Updates the auto commit settings object. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/autoCommitSettings"})
    public AutoCommitSettings saveAutoCommitSettings(@org.springframework.web.bind.annotation.RequestBody AutoCommitSettings settings) throws ThingsboardException {
        settings.values().forEach(config -> VcUtils.checkBranchName((String)config.getBranch()));
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.WRITE);
        return this.autoCommitSettingsService.save(this.getTenantId(), settings);
    }

    @ApiOperation(value="Delete auto commit settings (deleteAutoCommitSettings)", notes="Deletes the auto commit settings.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/autoCommitSettings"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteAutoCommitSettings() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.VERSION_CONTROL, Operation.DELETE);
        this.autoCommitSettingsService.delete(this.getTenantId());
    }

    @ApiOperation(value="Check for new Platform Releases (checkUpdates)", notes="Check notifications about new platform releases. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/updates"})
    public UpdateMessage checkUpdates() {
        return this.updateService.checkUpdates();
    }

    @ApiOperation(value="Get license usage info (getLicenseUsageInfo)", notes="Get license usage info. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/licenseUsageInfo"})
    public LicenseUsageInfo getLicenseUsageInfo() throws ThingsboardException {
        LicenseInfo licenseInfo = this.subscriptionService.getLicenseInfo();
        LicenseUsageInfo licenseUsageInfo = new LicenseUsageInfo(licenseInfo);
        licenseUsageInfo.setDevicesCount(this.deviceService.countDevices().longValue());
        licenseUsageInfo.setAssetsCount(this.assetService.countAssets().longValue());
        licenseUsageInfo.setDashboardsCount(this.dashboardService.countDashboards().longValue());
        licenseUsageInfo.setIntegrationsCount(this.integrationService.countCoreIntegrations().longValue());
        return licenseUsageInfo;
    }

    @ApiOperation(value="Get system info (getSystemInfo)", notes="Get main information about system. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/systemInfo"})
    public SystemInfo getSystemInfo() {
        return this.systemInfoService.getSystemInfo();
    }

    @ApiOperation(value="Get features info (getFeaturesInfo)", notes="Get information about enabled/disabled features. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @GetMapping(value={"/featuresInfo"})
    public FeaturesInfo getFeaturesInfo() {
        return this.systemInfoService.getFeaturesInfo();
    }

    @ApiOperation(value="Get OAuth2 log in processing URL (getMailProcessingUrl)", notes="Returns the URL enclosed in double quotes. After successful authentication with OAuth2 provider and user consent for requested scope, it makes a redirect to this path so that the platform can do further log in processing and generating access tokens. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/mail/oauth2/loginProcessingUrl"})
    public String getMailProcessingUrl() throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ADMIN_SETTINGS, Operation.READ);
        return "\"/api/admin/mail/oauth2/code\"";
    }

    @ApiOperation(value="Redirect user to mail provider login page. ", notes="After user logged in and provided accessprovider sends authorization code to specified redirect uri.)")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/mail/oauth2/authorize"}, produces={"application/text"})
    public String getAuthorizationUrl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdminSettings adminSettings;
        SecurityUser currentUser = this.getCurrentUser();
        String state = StringUtils.generateSafeToken();
        if (request.getParameter(PREV_URI_PATH_PARAMETER) != null) {
            CookieUtils.addCookie((HttpServletResponse)response, (String)PREV_URI_COOKIE_NAME, (String)request.getParameter(PREV_URI_PATH_PARAMETER), (int)180);
        }
        CookieUtils.addCookie((HttpServletResponse)response, (String)STATE_COOKIE_NAME, (String)state, (int)180);
        this.oauth2StateCache.put((Serializable)((Object)state), (Serializable)currentUser.getTenantId());
        if (Authority.SYS_ADMIN.equals((Object)currentUser.getAuthority())) {
            this.accessControlService.checkPermission(currentUser, Resource.ADMIN_SETTINGS, Operation.READ);
            adminSettings = (AdminSettings)this.checkNotNull((Object)this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, MAIL_SETTINGS_KEY), "No Administration settings found for key: mail");
        } else {
            this.accessControlService.checkPermission(currentUser, Resource.WHITE_LABELING, Operation.READ);
            adminSettings = this.getTenantAdminSettings(currentUser.getTenantId(), MAIL_SETTINGS_KEY, true);
        }
        JsonNode jsonValue = adminSettings.getJsonValue();
        String clientId = ((JsonNode)this.checkNotNull((Object)jsonValue.get("clientId"), "No clientId was configured")).asText();
        String authUri = ((JsonNode)this.checkNotNull((Object)jsonValue.get("authUri"), "No authorization uri was configured")).asText();
        String redirectUri = ((JsonNode)this.checkNotNull((Object)jsonValue.get("redirectUri"), "No Redirect uri was configured")).asText();
        List scope = (List)JacksonUtil.convertValue((Object)this.checkNotNull((Object)jsonValue.get("scope"), "No scope was configured"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return "\"" + new AuthorizationCodeRequestUrl(authUri, clientId).setScopes((Collection)scope).setState(state).setRedirectUri(redirectUri).build() + "\"";
    }

    @GetMapping(value={"/mail/oauth2/code"}, params={"code", "state"})
    public void codeProcessingUrl(@RequestParam(value="code") String code, @RequestParam(value="state") String state, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TokenResponse tokenResponse;
        Optional prevUrlOpt = CookieUtils.getCookie((HttpServletRequest)request, (String)PREV_URI_COOKIE_NAME);
        Optional cookieState = CookieUtils.getCookie((HttpServletRequest)request, (String)STATE_COOKIE_NAME);
        String baseUrl = this.systemSecurityService.getBaseUrl(TenantId.SYS_TENANT_ID, new CustomerId(EntityId.NULL_UUID), request);
        String prevUri = baseUrl + (prevUrlOpt.isPresent() ? ((Cookie)prevUrlOpt.get()).getValue() : "/settings/outgoing-mail");
        if (cookieState.isEmpty() || !((Cookie)cookieState.get()).getValue().equals(state)) {
            CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)STATE_COOKIE_NAME);
            throw new ThingsboardException("Refresh token was not generated, invalid state param", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        TbCacheValueWrapper tenantWrapper = this.oauth2StateCache.get((Serializable)((Object)state));
        if (tenantWrapper == null) {
            throw new ThingsboardException("State parameter is not valid", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        TenantId tenantId = (TenantId)tenantWrapper.get();
        this.oauth2StateCache.evict((Serializable)((Object)state));
        CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)STATE_COOKIE_NAME);
        CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)PREV_URI_COOKIE_NAME);
        AdminSettings adminSettings = TenantId.SYS_TENANT_ID.equals((Object)tenantId) ? (AdminSettings)this.checkNotNull((Object)this.adminSettingsService.findAdminSettingsByKey(tenantId, MAIL_SETTINGS_KEY), "No Administration mail settings found") : this.getTenantAdminSettings(tenantId, MAIL_SETTINGS_KEY, false);
        JsonNode jsonValue = adminSettings.getJsonValue().deepCopy();
        this.secretConfigurationService.replaceSecretUsages(tenantId, jsonValue);
        String clientId = ((JsonNode)this.checkNotNull((Object)jsonValue.get("clientId"), "No clientId was configured")).asText();
        String clientSecret = ((JsonNode)this.checkNotNull((Object)jsonValue.get("clientSecret"), "No client secret was configured")).asText();
        String clientRedirectUri = ((JsonNode)this.checkNotNull((Object)jsonValue.get("redirectUri"), "No Redirect uri was configured")).asText();
        String tokenUri = ((JsonNode)this.checkNotNull((Object)jsonValue.get("tokenUri"), "No authorization uri was configured")).asText();
        try {
            tokenResponse = new AuthorizationCodeTokenRequest((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), new GenericUrl(tokenUri), code).setRedirectUri(clientRedirectUri).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret)).execute();
        }
        catch (IOException e) {
            log.warn("Unable to retrieve refresh token: {}", (Object)e.getMessage());
            throw new ThingsboardException("Error while requesting access token: " + e.getMessage(), ThingsboardErrorCode.GENERAL);
        }
        ((ObjectNode)adminSettings.getJsonValue()).put("refreshToken", tokenResponse.getRefreshToken());
        ((ObjectNode)adminSettings.getJsonValue()).put("tokenGenerated", true);
        this.adminSettingsService.saveAdminSettings(tenantId, adminSettings);
        response.sendRedirect(prevUri);
    }

    private AdminSettings getTenantAdminSettings(TenantId tenantId, String key, boolean systemByDefault) throws Exception {
        AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, key);
        if (adminSettings == null) {
            if (systemByDefault) {
                return (AdminSettings)this.checkNotNull((Object)this.adminSettingsService.findAdminSettingsByTenantIdAndKey(TenantId.SYS_TENANT_ID, key));
            }
            adminSettings = new AdminSettings();
            adminSettings.setTenantId(tenantId);
            adminSettings.setKey(key);
            adminSettings.setJsonValue((JsonNode)JacksonUtil.newObjectNode());
            return adminSettings;
        }
        return adminSettings;
    }

    @ConstructorProperties(value={"mailService", "smsService", "adminSettingsService", "systemSecurityService", "securitySettingsService", "jwtSettingsService", "tokenFactory", "versionControlService", "autoCommitSettingsService", "updateService", "systemInfoService", "subscriptionService", "auditLogService", "secretConfigurationService", "oauth2StateCache"})
    @Generated
    public AdminController(MailService mailService, SmsService smsService, AdminSettingsService adminSettingsService, SystemSecurityService systemSecurityService, SecuritySettingsService securitySettingsService, JwtSettingsService jwtSettingsService, JwtTokenFactory tokenFactory, EntitiesVersionControlService versionControlService, TbAutoCommitSettingsService autoCommitSettingsService, UpdateService updateService, SystemInfoService systemInfoService, SubscriptionService subscriptionService, AuditLogService auditLogService, SecretConfigurationService secretConfigurationService, TbTransactionalCache<String, TenantId> oauth2StateCache) {
        this.mailService = mailService;
        this.smsService = smsService;
        this.adminSettingsService = adminSettingsService;
        this.systemSecurityService = systemSecurityService;
        this.securitySettingsService = securitySettingsService;
        this.jwtSettingsService = jwtSettingsService;
        this.tokenFactory = tokenFactory;
        this.versionControlService = versionControlService;
        this.autoCommitSettingsService = autoCommitSettingsService;
        this.updateService = updateService;
        this.systemInfoService = systemInfoService;
        this.subscriptionService = subscriptionService;
        this.auditLogService = auditLogService;
        this.secretConfigurationService = secretConfigurationService;
        this.oauth2StateCache = oauth2StateCache;
    }
}

