/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.data.rpc.ToDeviceRpcRequestBody;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.controller.AbstractRpcController;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.HttpValidationCallback;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.rpc.LocalRequestMetaData;
import org.thingsboard.server.service.rpc.TbCoreDeviceRpcService;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.model.SecurityUser;

@TbCoreComponent
public abstract class AbstractRpcController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRpcController.class);
    @Autowired
    protected TbCoreDeviceRpcService deviceRpcService;
    @Autowired
    protected AccessValidator accessValidator;
    @Value(value="${server.rest.server_side_rpc.min_timeout:5000}")
    protected long minTimeout;
    @Value(value="${server.rest.server_side_rpc.default_timeout:10000}")
    private long defaultTimeout;

    protected DeferredResult<ResponseEntity> handleDeviceRPCRequest(boolean oneWay, DeviceId deviceId, String requestBody, HttpStatus timeoutStatus, HttpStatus noActiveConnectionStatus) throws ThingsboardException {
        try {
            JsonNode rpcRequestBody = JacksonUtil.toJsonNode((String)requestBody);
            ToDeviceRpcRequestBody body = new ToDeviceRpcRequestBody(rpcRequestBody.get("method").asText(), JacksonUtil.toString((Object)rpcRequestBody.get("params")));
            SecurityUser currentUser = this.getCurrentUser();
            TenantId tenantId = currentUser.getTenantId();
            DeferredResult response = new DeferredResult();
            long timeout = rpcRequestBody.has("timeout") ? rpcRequestBody.get("timeout").asLong() : this.defaultTimeout;
            long expTime = rpcRequestBody.has("expirationTime") ? rpcRequestBody.get("expirationTime").asLong() : System.currentTimeMillis() + Math.max(this.minTimeout, timeout);
            UUID rpcRequestUUID = rpcRequestBody.has("requestUUID") ? UUID.fromString(rpcRequestBody.get("requestUUID").asText()) : UUID.randomUUID();
            boolean persisted = rpcRequestBody.has("persistent") && rpcRequestBody.get("persistent").asBoolean();
            String additionalInfo = JacksonUtil.toString((Object)rpcRequestBody.get("additionalInfo"));
            Integer retries = rpcRequestBody.has("retries") ? Integer.valueOf(rpcRequestBody.get("retries").asInt()) : null;
            this.accessValidator.validate(currentUser, Operation.RPC_CALL, (EntityId)deviceId, (FutureCallback)new HttpValidationCallback(response, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */));
            return response;
        }
        catch (IllegalArgumentException ioe) {
            throw new ThingsboardException("Invalid request body", (Throwable)ioe, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
    }

    public void reply(LocalRequestMetaData rpcRequest, FromDeviceRpcResponse response, HttpStatus timeoutStatus, HttpStatus noActiveConnectionStatus) {
        Optional rpcError = response.getError();
        DeferredResult responseWriter = rpcRequest.getResponseWriter();
        if (rpcError.isPresent()) {
            this.logRpcCall(rpcRequest, rpcError, null);
            RpcError error = (RpcError)rpcError.get();
            switch (2.$SwitchMap$org$thingsboard$server$common$data$rpc$RpcError[error.ordinal()]) {
                case 1: {
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)timeoutStatus));
                    break;
                }
                case 2: {
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)noActiveConnectionStatus));
                    break;
                }
                default: {
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)timeoutStatus));
                    break;
                }
            }
        } else {
            Optional responseData = response.getResponse();
            if (responseData.isPresent() && !StringUtils.isEmpty((String)((String)responseData.get()))) {
                String data = (String)responseData.get();
                try {
                    this.logRpcCall(rpcRequest, rpcError, null);
                    responseWriter.setResult((Object)new ResponseEntity((Object)JacksonUtil.toJsonNode((String)data), (HttpStatusCode)HttpStatus.OK));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Failed to decode device response: {}", (Object)data, (Object)e);
                    this.logRpcCall(rpcRequest, rpcError, (Throwable)e);
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE));
                }
            } else {
                this.logRpcCall(rpcRequest, rpcError, null);
                responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
            }
        }
    }

    private void logRpcCall(LocalRequestMetaData rpcRequest, Optional<RpcError> rpcError, Throwable e) {
        this.logRpcCall(rpcRequest.getUser(), (EntityId)rpcRequest.getRequest().getDeviceId(), rpcRequest.getRequest().getBody(), rpcRequest.getRequest().isOneway(), rpcError, null);
    }

    private void logRpcCall(SecurityUser user, EntityId entityId, ToDeviceRpcRequestBody body, boolean oneWay, Optional<RpcError> rpcError, Throwable e) {
        Object rpcErrorStr = "";
        if (rpcError.isPresent()) {
            rpcErrorStr = "RPC Error: " + rpcError.get().name();
        }
        String method = body.getMethod();
        String params = body.getParams();
        this.auditLogService.logEntityAction(user.getTenantId(), user.getCustomerId(), user.getId(), user.getName(), (EntityId)((UUIDBased)entityId), null, ActionType.RPC_CALL, BaseController.toException((Throwable)e), new Object[]{rpcErrorStr, oneWay, method, params});
    }
}

