/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.shared;

import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.shared.AbstractContextAwareMsgProcessor;
import org.thingsboard.server.actors.stats.StatsPersistTick;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleState;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.RuleNodeException;

public abstract class ComponentMsgProcessor<T extends EntityId>
extends AbstractContextAwareMsgProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentMsgProcessor.class);
    protected final TenantId tenantId;
    protected final T entityId;
    protected ComponentLifecycleState state;

    protected ComponentMsgProcessor(ActorSystemContext systemContext, TenantId tenantId, T id) {
        super(systemContext);
        this.tenantId = tenantId;
        this.entityId = id;
    }

    protected TenantProfileConfiguration getTenantProfileConfiguration() {
        return this.systemContext.getTenantProfileCache().get(this.tenantId).getProfileData().getConfiguration();
    }

    public abstract String getComponentName();

    public abstract void start(TbActorCtx var1) throws Exception;

    public abstract void stop(TbActorCtx var1) throws Exception;

    public abstract void onPartitionChangeMsg(PartitionChangeMsg var1) throws Exception;

    public void onCreated(TbActorCtx context) throws Exception {
        this.start(context);
    }

    public void onUpdate(TbActorCtx context) throws Exception {
        this.restart(context);
    }

    public void onActivate(TbActorCtx context) throws Exception {
        this.restart(context);
    }

    public void onSuspend(TbActorCtx context) throws Exception {
        this.stop(context);
    }

    public void onStop(TbActorCtx context) throws Exception {
        this.stop(context);
    }

    private void restart(TbActorCtx context) throws Exception {
        this.stop(context);
        this.start(context);
    }

    public ScheduledFuture<?> scheduleStatsPersistTick(TbActorCtx context, long statsPersistFrequency) {
        return this.schedulePeriodicMsgWithDelay(context, (TbActorMsg)StatsPersistTick.INSTANCE, statsPersistFrequency, statsPersistFrequency);
    }

    protected boolean checkMsgValid(TbMsg tbMsg) {
        boolean valid = tbMsg.isValid();
        if (!valid && log.isTraceEnabled()) {
            log.trace("Skip processing of message: {} because it is no longer valid!", (Object)tbMsg);
        }
        return valid;
    }

    protected void checkComponentStateActive(TbMsg tbMsg) throws RuleNodeException {
        if (this.state != ComponentLifecycleState.ACTIVE) {
            log.debug("Component is not active. Current state [{}] for processor [{}][{}] tenant [{}]", new Object[]{this.state, this.entityId.getEntityType(), this.entityId, this.tenantId});
            RuleNodeException ruleNodeException = this.getInactiveException();
            if (tbMsg != null) {
                tbMsg.getCallback().onFailure((RuleEngineException)ruleNodeException);
            }
            throw ruleNodeException;
        }
    }

    protected abstract RuleNodeException getInactiveException();
}

