/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.device;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.device.DeviceActor;
import org.thingsboard.server.actors.device.DeviceActorMessageProcessor;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponseActorMsg;
import org.thingsboard.server.common.msg.rpc.RemoveRpcActorMsg;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequestActorMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceAttributesEventNotificationMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceEdgeUpdateMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceNameOrTypeUpdateMsg;
import org.thingsboard.server.common.msg.timeout.DeviceActorServerSideRpcTimeoutMsg;
import org.thingsboard.server.service.transport.msg.TransportToDeviceActorMsgWrapper;

public class DeviceActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceActor.class);
    private final DeviceActorMessageProcessor processor;

    DeviceActor(ActorSystemContext systemContext, TenantId tenantId, DeviceId deviceId) {
        super(systemContext);
        this.processor = new DeviceActorMessageProcessor(systemContext, tenantId, deviceId);
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        log.debug("[{}][{}] Starting device actor.", (Object)this.processor.tenantId, (Object)this.processor.deviceId);
        try {
            this.processor.init(ctx);
            log.debug("[{}][{}] Device actor started.", (Object)this.processor.tenantId, (Object)this.processor.deviceId);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Unknown failure", new Object[]{this.processor.tenantId, this.processor.deviceId, e});
            throw new TbActorException("Failed to initialize device actor", (Throwable)e);
        }
    }

    protected boolean doProcess(TbActorMsg msg) {
        switch (1.$SwitchMap$org$thingsboard$server$common$msg$MsgType[msg.getMsgType().ordinal()]) {
            case 1: {
                this.processor.process((TransportToDeviceActorMsgWrapper)msg);
                break;
            }
            case 2: {
                this.processor.processAttributesUpdate((DeviceAttributesEventNotificationMsg)msg);
                break;
            }
            case 3: {
                this.ctx.stop(this.ctx.getSelf());
                break;
            }
            case 4: {
                this.processor.processCredentialsUpdate(msg);
                break;
            }
            case 5: {
                this.processor.processNameOrTypeUpdate((DeviceNameOrTypeUpdateMsg)msg);
                break;
            }
            case 6: {
                this.processor.processRpcRequest(this.ctx, (ToDeviceRpcRequestActorMsg)msg);
                break;
            }
            case 7: {
                this.processor.processRpcResponsesFromEdge((FromDeviceRpcResponseActorMsg)msg);
                break;
            }
            case 8: {
                this.processor.processServerSideRpcTimeout((DeviceActorServerSideRpcTimeoutMsg)msg);
                break;
            }
            case 9: {
                this.processor.checkSessionsTimeout();
                break;
            }
            case 10: {
                this.processor.processEdgeUpdate((DeviceEdgeUpdateMsg)msg);
                break;
            }
            case 11: {
                this.processor.processRemoveRpc((RemoveRpcActorMsg)msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

