/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.queue.TbCallback;

public class MultipleTbCallback
implements TbCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultipleTbCallback.class);
    private final UUID id = UUID.randomUUID();
    private final AtomicInteger counter;
    private final TbCallback callback;

    public MultipleTbCallback(int count, TbCallback callback) {
        this.counter = new AtomicInteger(count);
        this.callback = callback;
    }

    public void onSuccess() {
        this.onSuccess(1);
    }

    public void onSuccess(int number) {
        log.trace("[{}][{}] onSuccess({})", new Object[]{this.id, this.callback.getId(), number});
        if (this.counter.addAndGet(-number) <= 0) {
            log.trace("[{}][{}] Done.", (Object)this.id, (Object)this.callback.getId());
            this.callback.onSuccess();
        }
    }

    public void onFailure(Throwable t) {
        log.warn("[{}][{}] onFailure.", (Object)this.id, (Object)this.callback.getId());
        this.callback.onFailure(t);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }
}

