/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbCalculatedFieldEntityActorId;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldArgumentResetMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityActorCreator;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityDeleteMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldManagerMessageProcessor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityInitCalculatedFieldMsg;
import org.thingsboard.server.actors.calculatedField.MultipleTbCallback;
import org.thingsboard.server.actors.shared.AbstractContextAwareMsgProcessor;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ProfileEntityIdInfo;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldCacheInitMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldEntityLifecycleMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.settings.TbQueueCalculatedFieldSettings;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldStateService;
import org.thingsboard.server.service.cf.cache.TenantEntityProfileCache;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.utils.CalculatedFieldUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculatedFieldManagerMessageProcessor
extends AbstractContextAwareMsgProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldManagerMessageProcessor.class);
    private final Map<CalculatedFieldId, CalculatedFieldCtx> calculatedFields = new HashMap();
    private final Map<EntityId, List<CalculatedFieldCtx>> entityIdCalculatedFields = new HashMap();
    private final Map<EntityId, List<CalculatedFieldLink>> entityIdCalculatedFieldLinks = new HashMap();
    private final Map<EntityId, Set<EntityId>> ownerEntities = new HashMap();
    private final CalculatedFieldProcessingService cfExecService;
    private final CalculatedFieldStateService cfStateService;
    private final CalculatedFieldService cfDaoService;
    private final DeviceService deviceService;
    private final AssetService assetService;
    private final TbAssetProfileCache assetProfileCache;
    private final TbDeviceProfileCache deviceProfileCache;
    private final TenantEntityProfileCache entityProfileCache;
    private final OwnersCacheService ownersCacheService;
    private final TbQueueCalculatedFieldSettings cfSettings;
    protected final TenantId tenantId;
    protected TbActorCtx ctx;

    CalculatedFieldManagerMessageProcessor(ActorSystemContext systemContext, TenantId tenantId) {
        super(systemContext);
        this.cfExecService = systemContext.getCalculatedFieldProcessingService();
        this.cfStateService = systemContext.getCalculatedFieldStateService();
        this.cfDaoService = systemContext.getCalculatedFieldService();
        this.deviceService = systemContext.getDeviceService();
        this.assetService = systemContext.getAssetService();
        this.assetProfileCache = systemContext.getAssetProfileCache();
        this.deviceProfileCache = systemContext.getDeviceProfileCache();
        this.entityProfileCache = new TenantEntityProfileCache();
        this.ownersCacheService = systemContext.getOwnersCacheService();
        this.cfSettings = systemContext.getCalculatedFieldSettings();
        this.tenantId = tenantId;
    }

    void init(TbActorCtx ctx) {
        this.ctx = ctx;
    }

    public void stop() {
        log.info("[{}] Stopping CF manager actor.", (Object)this.tenantId);
        this.calculatedFields.values().forEach(CalculatedFieldCtx::stop);
        this.calculatedFields.clear();
        this.entityIdCalculatedFields.clear();
        this.entityIdCalculatedFieldLinks.clear();
        this.ctx.stop(this.ctx.getSelf());
    }

    public void onCacheInitMsg(CalculatedFieldCacheInitMsg msg) {
        log.debug("[{}] Processing CF actor init message.", (Object)msg.getTenantId().getId());
        this.initEntitiesCache();
        this.initCalculatedFields();
        msg.getCallback().onSuccess();
    }

    public void onStateRestoreMsg(CalculatedFieldStateRestoreMsg msg) {
        CalculatedFieldId cfId = msg.getId().cfId();
        CalculatedFieldCtx calculatedField = (CalculatedFieldCtx)this.calculatedFields.get(cfId);
        if (calculatedField != null) {
            if (msg.getState() != null) {
                msg.getState().setRequiredArguments(calculatedField.getArgNames());
            }
            log.debug("[{}] Pushing CF state restore msg to specific actor [{}]", (Object)this.tenantId, (Object)msg.getId().entityId());
            this.getOrCreateActor(msg.getId().entityId()).tell((TbActorMsg)msg);
        } else if (msg.getState() != null) {
            log.debug("[{}] Received CF state restore msg for non-existing CF [{}]. Removing state", (Object)this.tenantId, (Object)cfId);
            this.cfStateService.removeState(msg.getId(), msg.getCallback());
        } else {
            msg.getCallback().onSuccess();
        }
    }

    public void onEntityLifecycleMsg(CalculatedFieldEntityLifecycleMsg msg) throws CalculatedFieldException {
        log.debug("Processing entity lifecycle event: [{}] for entity: [{}]", (Object)msg.getData().getEvent(), (Object)msg.getData().getEntityId());
        EntityType entityType = msg.getData().getEntityId().getEntityType();
        ComponentLifecycleEvent event = msg.getData().getEvent();
        block0 : switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1: {
                switch (1.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[event.ordinal()]) {
                    case 1: {
                        this.onCfCreated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 2: {
                        this.onCfUpdated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 3: {
                        this.onCfDeleted(msg.getData(), msg.getCallback());
                        break block0;
                    }
                }
                msg.getCallback().onSuccess();
                break;
            }
            case 2: 
            case 3: {
                switch (1.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[event.ordinal()]) {
                    case 1: {
                        this.onEntityCreated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 2: {
                        this.onEntityUpdated(msg.getData(), msg.getCallback());
                        break block0;
                    }
                    case 3: {
                        this.onEntityDeleted(msg.getData(), msg.getCallback());
                        break block0;
                    }
                }
                msg.getCallback().onSuccess();
                break;
            }
            case 4: 
            case 5: {
                switch (1.$SwitchMap$org$thingsboard$server$common$data$plugin$ComponentLifecycleEvent[event.ordinal()]) {
                    case 3: {
                        this.onProfileDeleted(msg.getData(), msg.getCallback());
                        break block0;
                    }
                }
                msg.getCallback().onSuccess();
                break;
            }
            default: {
                msg.getCallback().onSuccess();
            }
        }
    }

    private void onProfileDeleted(ComponentLifecycleMsg msg, TbCallback callback) {
        this.entityProfileCache.removeProfileId(msg.getEntityId());
        callback.onSuccess();
    }

    private void onEntityCreated(ComponentLifecycleMsg msg, TbCallback callback) {
        EntityId entityId = msg.getEntityId();
        EntityId profileId = this.getProfileId(this.tenantId, entityId);
        if (profileId != null) {
            this.entityProfileCache.add(profileId, entityId);
        }
        this.updateEntityOwner(entityId);
        if (!this.isMyPartition(entityId, callback)) {
            return;
        }
        List entityIdFields = this.getCalculatedFieldsByEntityId(entityId);
        List profileIdFields = this.getCalculatedFieldsByEntityId(profileId);
        int fieldsCount = entityIdFields.size() + profileIdFields.size();
        if (fieldsCount > 0) {
            MultipleTbCallback multiCallback = new MultipleTbCallback(fieldsCount, callback);
            entityIdFields.forEach(ctx -> this.initCfForEntity(entityId, ctx, true, (TbCallback)multiCallback));
            profileIdFields.forEach(ctx -> this.initCfForEntity(entityId, ctx, true, (TbCallback)multiCallback));
        } else {
            callback.onSuccess();
        }
    }

    private void onEntityUpdated(ComponentLifecycleMsg msg, TbCallback callback) {
        if (msg.getOldProfileId() != null && !msg.getOldProfileId().equals(msg.getProfileId())) {
            this.entityProfileCache.update(msg.getOldProfileId(), msg.getProfileId(), msg.getEntityId());
            if (!this.isMyPartition(msg.getEntityId(), callback)) {
                return;
            }
            List oldProfileCfs = this.getCalculatedFieldsByEntityId(msg.getOldProfileId());
            List newProfileCfs = this.getCalculatedFieldsByEntityId(msg.getProfileId());
            int fieldsCount = oldProfileCfs.size() + newProfileCfs.size();
            if (fieldsCount > 0) {
                MultipleTbCallback multiCallback = new MultipleTbCallback(fieldsCount, callback);
                EntityId entityId = msg.getEntityId();
                oldProfileCfs.forEach(ctx -> this.deleteCfForEntity(entityId, ctx.getCfId(), (TbCallback)multiCallback));
                newProfileCfs.forEach(ctx -> this.initCfForEntity(entityId, ctx, true, (TbCallback)multiCallback));
            } else {
                callback.onSuccess();
            }
        } else if (msg.isOwnerChanged()) {
            this.onEntityOwnerChanged(msg, callback);
        } else {
            callback.onSuccess();
        }
    }

    private void onEntityDeleted(ComponentLifecycleMsg msg, TbCallback callback) {
        this.entityProfileCache.removeEntityId(msg.getEntityId());
        this.ownerEntities.values().forEach(entities -> entities.remove(msg.getEntityId()));
        if (this.isMyPartition(msg.getEntityId(), callback)) {
            log.debug("Pushing entity lifecycle msg to specific actor [{}]", (Object)msg.getEntityId());
            this.getOrCreateActor(msg.getEntityId()).tell((TbActorMsg)new CalculatedFieldEntityDeleteMsg(this.tenantId, msg.getEntityId(), callback));
        }
    }

    private void onCfCreated(ComponentLifecycleMsg msg, TbCallback callback) throws CalculatedFieldException {
        CalculatedFieldId cfId = new CalculatedFieldId(msg.getEntityId().getId());
        if (this.calculatedFields.containsKey(cfId)) {
            log.debug("[{}] CF was already initialized [{}]", (Object)this.tenantId, (Object)cfId);
            callback.onSuccess();
        } else {
            CalculatedField cf = this.cfDaoService.findById(msg.getTenantId(), cfId);
            if (cf == null) {
                log.debug("[{}] Failed to lookup CF by id [{}]", (Object)this.tenantId, (Object)cfId);
                callback.onSuccess();
            } else {
                CalculatedFieldCtx cfCtx = new CalculatedFieldCtx(cf, this.systemContext.getTbelInvokeService(), this.systemContext.getApiLimitService());
                try {
                    cfCtx.init();
                }
                catch (Exception e) {
                    throw CalculatedFieldException.builder().ctx(cfCtx).eventEntity(cf.getEntityId()).cause(e).errorMessage(e.getMessage()).build();
                }
                this.calculatedFields.put(cf.getId(), cfCtx);
                this.entityIdCalculatedFields.computeIfAbsent(cf.getEntityId(), id -> new CopyOnWriteArrayList()).add(cfCtx);
                this.addLinks(cf);
                this.initCf(cfCtx, callback, false);
            }
        }
    }

    private void onCfUpdated(ComponentLifecycleMsg msg, TbCallback callback) throws CalculatedFieldException {
        CalculatedFieldId cfId = new CalculatedFieldId(msg.getEntityId().getId());
        CalculatedFieldCtx oldCfCtx = (CalculatedFieldCtx)this.calculatedFields.get(cfId);
        if (oldCfCtx == null) {
            this.onCfCreated(msg, callback);
        } else {
            CalculatedField newCf = this.cfDaoService.findById(msg.getTenantId(), cfId);
            if (newCf == null) {
                log.debug("[{}] Failed to lookup CF by id [{}]", (Object)this.tenantId, (Object)cfId);
                callback.onSuccess();
            } else {
                CalculatedFieldCtx newCfCtx = new CalculatedFieldCtx(newCf, this.systemContext.getTbelInvokeService(), this.systemContext.getApiLimitService());
                try {
                    newCfCtx.init();
                }
                catch (Exception e) {
                    throw CalculatedFieldException.builder().ctx(newCfCtx).eventEntity(newCfCtx.getEntityId()).cause(e).errorMessage(e.getMessage()).build();
                }
                finally {
                    this.calculatedFields.put(newCf.getId(), newCfCtx);
                    List oldCfList = (List)this.entityIdCalculatedFields.get(newCf.getEntityId());
                    CopyOnWriteArrayList<CalculatedFieldCtx> newCfList = new CopyOnWriteArrayList<CalculatedFieldCtx>();
                    boolean found = false;
                    for (CalculatedFieldCtx oldCtx : oldCfList) {
                        if (oldCtx.getCfId().equals((Object)newCf.getId())) {
                            newCfList.add(newCfCtx);
                            found = true;
                            continue;
                        }
                        newCfList.add(oldCtx);
                    }
                    if (!found) {
                        newCfList.add(newCfCtx);
                    }
                    this.entityIdCalculatedFields.put(newCf.getEntityId(), newCfList);
                    this.deleteLinks(oldCfCtx);
                    this.addLinks(newCf);
                }
                boolean stateChanges = newCfCtx.hasStateChanges(oldCfCtx);
                if (stateChanges || newCfCtx.hasOtherSignificantChanges(oldCfCtx)) {
                    this.initCf(newCfCtx, callback, stateChanges);
                } else {
                    callback.onSuccess();
                }
            }
        }
    }

    private void onCfDeleted(ComponentLifecycleMsg msg, TbCallback callback) {
        CalculatedFieldId cfId = new CalculatedFieldId(msg.getEntityId().getId());
        CalculatedFieldCtx cfCtx = (CalculatedFieldCtx)this.calculatedFields.remove(cfId);
        if (cfCtx == null) {
            log.debug("[{}] CF was already deleted [{}]", (Object)this.tenantId, (Object)cfId);
            callback.onSuccess();
        } else {
            ((List)this.entityIdCalculatedFields.get(cfCtx.getEntityId())).remove(cfCtx);
            this.deleteLinks(cfCtx);
            EntityId entityId = cfCtx.getEntityId();
            EntityType entityType = cfCtx.getEntityId().getEntityType();
            if (CalculatedFieldManagerMessageProcessor.isProfileEntity((EntityType)entityType)) {
                Collection entityIds = this.entityProfileCache.getEntityIdsByProfileId(entityId);
                if (!entityIds.isEmpty()) {
                    MultipleTbCallback multiCallback = new MultipleTbCallback(entityIds.size(), callback);
                    entityIds.forEach(id -> {
                        if (this.isMyPartition(id, (TbCallback)multiCallback)) {
                            this.deleteCfForEntity(id, cfId, (TbCallback)multiCallback);
                        }
                    });
                } else {
                    callback.onSuccess();
                }
            } else if (this.isMyPartition(entityId, callback)) {
                this.deleteCfForEntity(entityId, cfId, callback);
            }
        }
    }

    public void onTelemetryMsg(CalculatedFieldTelemetryMsg msg) {
        EntityId entityId = msg.getEntityId();
        log.debug("Received telemetry msg from entity [{}]", (Object)entityId);
        MultipleTbCallback callback = new MultipleTbCallback(3, msg.getCallback());
        List entityIdFields = this.getCalculatedFieldsByEntityId(entityId);
        List profileIdFields = this.getCalculatedFieldsByEntityId(this.getProfileId(this.tenantId, entityId));
        if (!entityIdFields.isEmpty() || !profileIdFields.isEmpty()) {
            log.debug("Pushing telemetry msg to specific actor [{}]", (Object)entityId);
            this.getOrCreateActor(entityId).tell((TbActorMsg)new EntityCalculatedFieldTelemetryMsg(msg, entityIdFields, profileIdFields, (TbCallback)callback));
        } else {
            callback.onSuccess();
        }
        List linkedCalculatedFields = this.filterCalculatedFieldLinks(msg);
        int linksSize = linkedCalculatedFields.size();
        if (linksSize > 0) {
            this.cfExecService.pushMsgToLinks(msg, linkedCalculatedFields, (TbCallback)callback);
        } else {
            callback.onSuccess();
        }
        if (entityId.getEntityType().isOneOf(new EntityType[]{EntityType.TENANT, EntityType.CUSTOMER})) {
            List ownerCFs = this.filterOwnerEntitiesCFs(msg);
            if (!ownerCFs.isEmpty()) {
                this.cfExecService.pushMsgToLinks(msg, ownerCFs, (TbCallback)callback);
            } else {
                callback.onSuccess();
            }
        } else {
            callback.onSuccess();
        }
    }

    public void onLinkedTelemetryMsg(CalculatedFieldLinkedTelemetryMsg msg) {
        EntityId sourceEntityId = msg.getEntityId();
        log.debug("Received linked telemetry msg from entity [{}]", (Object)sourceEntityId);
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto proto = msg.getProto();
        TbCallback callback = msg.getCallback();
        List linksList = proto.getLinksList();
        if (linksList.isEmpty()) {
            log.debug("[{}] No CF links to process new telemetry.", (Object)msg.getTenantId());
            callback.onSuccess();
        }
        for (TransportProtos.CalculatedFieldEntityCtxIdProto linkProto : linksList) {
            CalculatedFieldEntityCtxId link = CalculatedFieldUtils.fromProto((TransportProtos.CalculatedFieldEntityCtxIdProto)linkProto);
            EntityId targetEntityId = link.entityId();
            EntityType targetEntityType = targetEntityId.getEntityType();
            CalculatedFieldCtx cf = (CalculatedFieldCtx)this.calculatedFields.get(link.cfId());
            if (EntityType.DEVICE_PROFILE.equals((Object)targetEntityType) || EntityType.ASSET_PROFILE.equals((Object)targetEntityType)) {
                Collection entityIds = this.entityProfileCache.getEntityIdsByProfileId(targetEntityId);
                if (!entityIds.isEmpty()) {
                    MultipleTbCallback multipleCallback = new MultipleTbCallback(entityIds.size(), callback);
                    EntityCalculatedFieldLinkedTelemetryMsg newMsg = new EntityCalculatedFieldLinkedTelemetryMsg(this.tenantId, sourceEntityId, proto.getMsg(), cf, (TbCallback)multipleCallback);
                    entityIds.forEach(entityId -> {
                        if (this.isMyPartition(entityId, (TbCallback)multipleCallback)) {
                            log.debug("Pushing linked telemetry msg to specific actor [{}]", entityId);
                            this.getOrCreateActor(entityId).tell((TbActorMsg)newMsg);
                        }
                    });
                    continue;
                }
                callback.onSuccess();
                continue;
            }
            if (!this.isMyPartition(targetEntityId, callback)) continue;
            log.debug("Pushing linked telemetry msg to specific actor [{}]", (Object)targetEntityId);
            EntityCalculatedFieldLinkedTelemetryMsg newMsg = new EntityCalculatedFieldLinkedTelemetryMsg(this.tenantId, sourceEntityId, proto.getMsg(), cf, callback);
            this.getOrCreateActor(targetEntityId).tell((TbActorMsg)newMsg);
        }
    }

    private void onEntityOwnerChanged(ComponentLifecycleMsg msg, TbCallback msgCallback) {
        EntityId entityId = msg.getEntityId();
        log.debug("Received changed owner msg from entity [{}]", (Object)entityId);
        this.updateEntityOwner(entityId);
        ArrayList cfs = new ArrayList();
        cfs.addAll(this.getCalculatedFieldsByEntityId(entityId));
        cfs.addAll(this.getCalculatedFieldsByEntityId(this.getProfileId(this.tenantId, entityId)));
        if (cfs.isEmpty()) {
            msgCallback.onSuccess();
            return;
        }
        MultipleTbCallback callback = new MultipleTbCallback(cfs.size(), msgCallback);
        cfs.forEach(cf -> {
            if (this.isMyPartition(entityId, (TbCallback)callback)) {
                if (cf.hasDynamicSourceArg()) {
                    CalculatedFieldArgumentResetMsg argResetMsg = new CalculatedFieldArgumentResetMsg(this.tenantId, cf, (TbCallback)callback);
                    log.debug("Pushing CF argument reset msg to specific actor [{}]", (Object)entityId);
                    this.getOrCreateActor(entityId).tell((TbActorMsg)argResetMsg);
                } else {
                    callback.onSuccess();
                }
            }
        });
    }

    private List<CalculatedFieldEntityCtxId> filterCalculatedFieldLinks(CalculatedFieldTelemetryMsg msg) {
        EntityId entityId = msg.getEntityId();
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        ArrayList<CalculatedFieldEntityCtxId> result = new ArrayList<CalculatedFieldEntityCtxId>();
        for (CalculatedFieldLink link : this.getCalculatedFieldLinksByEntityId(entityId)) {
            CalculatedFieldCtx ctx = (CalculatedFieldCtx)this.calculatedFields.get(link.getCalculatedFieldId());
            if (!ctx.linkMatches(entityId, proto)) continue;
            result.add(ctx.toCalculatedFieldEntityCtxId());
        }
        return result;
    }

    private List<CalculatedFieldEntityCtxId> filterOwnerEntitiesCFs(CalculatedFieldTelemetryMsg msg) {
        Set entities = this.getOwnerEntities(msg.getEntityId());
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        ArrayList<CalculatedFieldEntityCtxId> result = new ArrayList<CalculatedFieldEntityCtxId>();
        for (EntityId entityId : entities) {
            List ownerEntityCFs = this.getCalculatedFieldsByEntityId(entityId);
            for (CalculatedFieldCtx ctx : ownerEntityCFs) {
                if (!ctx.dynamicSourceMatches(proto)) continue;
                result.add(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), entityId));
            }
            List ownerEntityProfileCFs = this.getCalculatedFieldsByEntityId(this.getProfileId(this.tenantId, entityId));
            for (CalculatedFieldCtx ctx : ownerEntityProfileCFs) {
                if (!ctx.dynamicSourceMatches(proto)) continue;
                result.add(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), entityId));
            }
        }
        return result;
    }

    private List<CalculatedFieldCtx> getCalculatedFieldsByEntityId(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptyList();
        }
        List<CalculatedFieldCtx> result = (List<CalculatedFieldCtx>)this.entityIdCalculatedFields.get(entityId);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<CalculatedFieldLink> getCalculatedFieldLinksByEntityId(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptyList();
        }
        List<CalculatedFieldLink> result = (List<CalculatedFieldLink>)this.entityIdCalculatedFieldLinks.get(entityId);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private Set<EntityId> getOwnerEntities(EntityId entityId) {
        if (entityId == null) {
            return Collections.emptySet();
        }
        Set<EntityId> result = (Set<EntityId>)this.ownerEntities.get(entityId);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private void initCf(CalculatedFieldCtx cfCtx, TbCallback callback, boolean forceStateReinit) {
        EntityId entityId = cfCtx.getEntityId();
        EntityType entityType = cfCtx.getEntityId().getEntityType();
        if (CalculatedFieldManagerMessageProcessor.isProfileEntity((EntityType)entityType)) {
            Collection entityIds = this.entityProfileCache.getEntityIdsByProfileId(entityId);
            if (!entityIds.isEmpty()) {
                MultipleTbCallback multiCallback = new MultipleTbCallback(entityIds.size(), callback);
                entityIds.forEach(id -> {
                    if (this.isMyPartition(id, (TbCallback)multiCallback)) {
                        this.initCfForEntity(id, cfCtx, forceStateReinit, (TbCallback)multiCallback);
                    }
                });
            } else {
                callback.onSuccess();
            }
        } else if (this.isMyPartition(entityId, callback)) {
            this.initCfForEntity(entityId, cfCtx, forceStateReinit, callback);
        }
    }

    private void deleteCfForEntity(EntityId entityId, CalculatedFieldId cfId, TbCallback callback) {
        log.debug("Pushing delete CF msg to specific actor [{}]", (Object)entityId);
        this.getOrCreateActor(entityId).tell((TbActorMsg)new CalculatedFieldEntityDeleteMsg(this.tenantId, (EntityId)cfId, callback));
    }

    private void initCfForEntity(EntityId entityId, CalculatedFieldCtx cfCtx, boolean forceStateReinit, TbCallback callback) {
        log.debug("Pushing entity init CF msg to specific actor [{}]", (Object)entityId);
        this.getOrCreateActor(entityId).tell((TbActorMsg)new EntityInitCalculatedFieldMsg(this.tenantId, cfCtx, callback, forceStateReinit));
    }

    private boolean isMyPartition(EntityId entityId, TbCallback callback) {
        if (!this.systemContext.getPartitionService().resolve(ServiceType.TB_RULE_ENGINE, "CalculatedFields", this.tenantId, entityId).isMyPartition()) {
            log.debug("[{}] Entity belongs to external partition.", (Object)entityId);
            callback.onSuccess();
            return false;
        }
        return true;
    }

    private static boolean isProfileEntity(EntityType entityType) {
        return EntityType.DEVICE_PROFILE.equals((Object)entityType) || EntityType.ASSET_PROFILE.equals((Object)entityType);
    }

    private EntityId getProfileId(TenantId tenantId, EntityId entityId) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 3 -> this.assetProfileCache.get(tenantId, (AssetId)entityId).getId();
            case 2 -> this.deviceProfileCache.get(tenantId, (DeviceId)entityId).getId();
            default -> null;
        };
    }

    private TbActorRef getOrCreateActor(EntityId entityId) {
        return this.ctx.getOrCreateChildActor((TbActorId)new TbCalculatedFieldEntityActorId(entityId), () -> "cf-entity-dispatcher", () -> new CalculatedFieldEntityActorCreator(this.systemContext, this.tenantId, entityId), () -> true);
    }

    private void addLinks(CalculatedField newCf) {
        List newLinks = newCf.getConfiguration().buildCalculatedFieldLinks(this.tenantId, newCf.getEntityId(), newCf.getId());
        newLinks.forEach(link -> this.entityIdCalculatedFieldLinks.computeIfAbsent(link.getEntityId(), id -> new CopyOnWriteArrayList()).add(link));
    }

    private void deleteLinks(CalculatedFieldCtx cfCtx) {
        CalculatedField oldCf = cfCtx.getCalculatedField();
        List oldLinks = oldCf.getConfiguration().buildCalculatedFieldLinks(this.tenantId, oldCf.getEntityId(), oldCf.getId());
        oldLinks.forEach(link -> this.entityIdCalculatedFieldLinks.computeIfAbsent(link.getEntityId(), id -> new CopyOnWriteArrayList()).remove(link));
    }

    public void onPartitionChange(CalculatedFieldPartitionChangeMsg msg) {
        this.ctx.broadcastToChildren((TbActorMsg)msg, true);
    }

    public void initCalculatedFields() {
        PageDataIterable cfs = new PageDataIterable(pageLink -> this.cfDaoService.findCalculatedFieldsByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        cfs.forEach(cf -> {
            log.trace("Processing calculated field record: {}", cf);
            try {
                this.initCalculatedField(cf);
            }
            catch (CalculatedFieldException e) {
                log.error("Failed to process calculated field record: {}", cf, (Object)e);
            }
        });
        PageDataIterable cfls = new PageDataIterable(pageLink -> this.cfDaoService.findAllCalculatedFieldLinksByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        cfls.forEach(link -> {
            log.trace("Processing calculated field link record: {}", link);
            this.initCalculatedFieldLink(link);
        });
    }

    private void initCalculatedField(CalculatedField cf) throws CalculatedFieldException {
        CalculatedFieldCtx cfCtx = new CalculatedFieldCtx(cf, this.systemContext.getTbelInvokeService(), this.systemContext.getApiLimitService());
        try {
            cfCtx.init();
        }
        catch (Exception e) {
            throw CalculatedFieldException.builder().ctx(cfCtx).eventEntity(cf.getEntityId()).cause(e).errorMessage(e.getMessage()).build();
        }
        finally {
            this.calculatedFields.put(cf.getId(), cfCtx);
            this.entityIdCalculatedFields.computeIfAbsent(cf.getEntityId(), id -> new CopyOnWriteArrayList()).add(cfCtx);
        }
    }

    private void initCalculatedFieldLink(CalculatedFieldLink link) {
        this.entityIdCalculatedFieldLinks.computeIfAbsent(link.getEntityId(), id -> new CopyOnWriteArrayList()).add(link);
    }

    private void initEntitiesCache() {
        PageDataIterable deviceIdInfos = new PageDataIterable(pageLink -> this.deviceService.findProfileEntityIdInfosByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        for (ProfileEntityIdInfo idInfo : deviceIdInfos) {
            log.trace("Processing device record: {}", (Object)idInfo);
            try {
                this.entityProfileCache.add(idInfo.getProfileId(), idInfo.getEntityId());
                this.ownerEntities.computeIfAbsent(idInfo.getOwnerId(), ownerId -> new HashSet()).add(idInfo.getEntityId());
            }
            catch (Exception e) {
                log.error("Failed to process device record: {}", (Object)idInfo, (Object)e);
            }
        }
        PageDataIterable assetIdInfos = new PageDataIterable(pageLink -> this.assetService.findProfileEntityIdInfosByTenantId(this.tenantId, pageLink), this.cfSettings.getInitTenantFetchPackSize());
        for (ProfileEntityIdInfo idInfo : assetIdInfos) {
            log.trace("Processing asset record: {}", (Object)idInfo);
            try {
                this.entityProfileCache.add(idInfo.getProfileId(), idInfo.getEntityId());
                this.ownerEntities.computeIfAbsent(idInfo.getOwnerId(), ownerId -> new HashSet()).add(idInfo.getEntityId());
            }
            catch (Exception e) {
                log.error("Failed to process asset record: {}", (Object)idInfo, (Object)e);
            }
        }
    }

    private void updateEntityOwner(EntityId entityId) {
        this.ownerEntities.values().forEach(entities -> entities.remove(entityId));
        EntityId owner = this.ownersCacheService.getOwner(this.tenantId, entityId);
        this.ownerEntities.computeIfAbsent(owner, ownerId -> new HashSet()).add(entityId);
    }
}

