/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.calculatedField.AbstractCalculatedFieldActor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldManagerActor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldManagerMessageProcessor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldTelemetryMsg;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.ToCalculatedFieldSystemMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldCacheInitMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldEntityLifecycleMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;

public class CalculatedFieldManagerActor
extends AbstractCalculatedFieldActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldManagerActor.class);
    private final CalculatedFieldManagerMessageProcessor processor;

    public CalculatedFieldManagerActor(ActorSystemContext systemContext, TenantId tenantId) {
        super(systemContext, tenantId);
        this.processor = new CalculatedFieldManagerMessageProcessor(systemContext, tenantId);
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        log.debug("[{}] Starting CF manager actor.", (Object)this.processor.tenantId);
        try {
            this.processor.init(ctx);
            log.debug("[{}] CF manager actor started.", (Object)this.processor.tenantId);
        }
        catch (Exception e) {
            log.warn("[{}] Unknown failure", (Object)this.processor.tenantId, (Object)e);
            throw new TbActorException("Failed to initialize manager actor", (Throwable)e);
        }
    }

    public void destroy(TbActorStopReason stopReason, Throwable cause) throws TbActorException {
        log.debug("[{}] Stopping CF manager actor.", (Object)this.processor.tenantId);
        this.processor.stop();
    }

    protected boolean doProcessCfMsg(ToCalculatedFieldSystemMsg msg) throws CalculatedFieldException {
        switch (1.$SwitchMap$org$thingsboard$server$common$msg$MsgType[msg.getMsgType().ordinal()]) {
            case 1: {
                this.processor.onPartitionChange((CalculatedFieldPartitionChangeMsg)msg);
                break;
            }
            case 2: {
                this.processor.onCacheInitMsg((CalculatedFieldCacheInitMsg)msg);
                break;
            }
            case 3: {
                this.processor.onStateRestoreMsg((CalculatedFieldStateRestoreMsg)msg);
                break;
            }
            case 4: {
                this.processor.onEntityLifecycleMsg((CalculatedFieldEntityLifecycleMsg)msg);
                break;
            }
            case 5: {
                this.processor.onTelemetryMsg((CalculatedFieldTelemetryMsg)msg);
                break;
            }
            case 6: {
                this.processor.onLinkedTelemetryMsg((CalculatedFieldLinkedTelemetryMsg)msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    void logProcessingException(Exception e) {
        log.warn("[{}] Processing failure", (Object)this.tenantId, (Object)e);
    }
}

