/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.pe.twilio;

import com.google.common.util.concurrent.ListenableFuture;
import com.twilio.exception.ApiException;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.type.PhoneNumber;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.pe.twilio.TbTwilioSmsNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.EXTERNAL, name="twilio sms", configClazz=TbTwilioSmsNodeConfiguration.class, nodeDescription="Sends SMS message via Twilio.", nodeDetails="Will send message payload as SMS message via Twilio.", uiResources={"static/rulenode/twilio-config.js"}, configDirective="tbActionNodeTwilioSmsConfig", icon="sms", docUrl="https://thingsboard.io/docs/user-guide/rule-engine-2-0/nodes/external/twilio-sms/", hasSecrets=true)
public class TbTwilioSmsNode
implements TbNode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbTwilioSmsNode.class);
    private boolean forceAck;
    private TbTwilioSmsNodeConfiguration config;
    private TwilioRestClient twilioRestClient;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.forceAck = ctx.isExternalNodeForceAck();
        this.config = (TbTwilioSmsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbTwilioSmsNodeConfiguration.class);
        this.twilioRestClient = new TwilioRestClient.Builder(this.config.getAccountSid(), this.config.getAccountToken()).build();
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        log.trace("[{}][{}] Msg received: {}", ctx.getTenantId().getId(), ctx.getSelfId().getId(), msg);
        TbMsg tbMsg = this.ackIfNeeded(ctx, msg);
        try {
            DonAsynchron.withCallback((ListenableFuture)ctx.getExternalCallExecutor().executeAsync(() -> {
                this.sendSms(ctx, tbMsg);
                return null;
            }), ok -> {
                log.trace("[{}][{}] Successfully processed msg: {}", ctx.getTenantId().getId(), ctx.getSelfId().getId(), tbMsg);
                if (this.forceAck) {
                    ctx.enqueueForTellNext(tbMsg.copyWithNewCtx(), "Success");
                } else {
                    ctx.tellNext(tbMsg, "Success");
                }
            }, fail -> {
                this.logFailure(ctx, tbMsg, (Throwable)fail);
                if (this.forceAck) {
                    ctx.enqueueForTellFailure(tbMsg.copyWithNewCtx(), fail);
                } else {
                    ctx.tellFailure(tbMsg, fail);
                }
            });
        }
        catch (Exception ex) {
            this.logFailure(ctx, tbMsg, ex);
            ctx.tellFailure(tbMsg, (Throwable)ex);
        }
    }

    private TbMsg ackIfNeeded(TbContext ctx, TbMsg msg) {
        if (this.forceAck) {
            ctx.ack(msg);
            return msg.copyWithNewCtx();
        }
        return msg;
    }

    private void logFailure(TbContext ctx, TbMsg msg, Throwable fail) {
        String errorMsg = String.format("[%s][%s] Failed to process msg: %s", ctx.getTenantId().getId(), ctx.getSelfId().getId(), msg);
        log.error(errorMsg, fail);
    }

    private void sendSms(TbContext ctx, TbMsg msg) {
        String numberFrom = TbNodeUtils.processPattern((String)this.config.getNumberFrom(), (TbMsg)msg);
        String numbersTo = TbNodeUtils.processPattern((String)this.config.getNumbersTo(), (TbMsg)msg);
        String[] numbersToList = numbersTo.split(",");
        if (numbersToList.length == 0) {
            throw new IllegalArgumentException("To numbers list is empty!");
        }
        for (String numberTo : numbersToList) {
            log.trace("[{}][{}][{}] Sending sms for number: {} ...", ctx.getTenantId().getId(), ctx.getSelfId().getId(), msg.getId(), numbersTo);
            try {
                Message.creator(new PhoneNumber(numberTo.trim()), new PhoneNumber(numberFrom.trim()), msg.getData().replaceAll("^\"|\"$", "").replaceAll("\\\\n", "\n")).create(this.twilioRestClient);
                log.trace("[{}][{}][{}] Sms for number: {} sent successfully!", ctx.getTenantId().getId(), ctx.getSelfId().getId(), msg.getId(), numbersTo);
            }
            catch (ApiException e) {
                String apiMsg = String.format("[%s][%s] Failed to send sms from number %s to number %s", ctx.getTenantId().getId(), ctx.getSelfId().getId(), numberFrom, numberTo);
                log.debug(apiMsg, e);
                ctx.tellFailure(msg, (Throwable)new RuntimeException(apiMsg, e));
            }
        }
    }
}

