/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Config;
import com.twilio.twiml.voice.Parameter;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class VirtualAgent
extends TwiML {
    private final String connectorName;
    private final String language;
    private final Boolean sentimentAnalysis;
    private final String statusCallback;
    private final HttpMethod statusCallbackMethod;

    private VirtualAgent() {
        this(new Builder());
    }

    private VirtualAgent(Builder b) {
        super("VirtualAgent", b);
        this.connectorName = b.connectorName;
        this.language = b.language;
        this.sentimentAnalysis = b.sentimentAnalysis;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getConnectorName() != null) {
            attrs.put("connectorName", this.getConnectorName());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage());
        }
        if (this.isSentimentAnalysis() != null) {
            attrs.put("sentimentAnalysis", this.isSentimentAnalysis().toString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        return attrs;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getLanguage() {
        return this.language;
    }

    public Boolean isSentimentAnalysis() {
        return this.sentimentAnalysis;
    }

    public String getStatusCallback() {
        return this.statusCallback;
    }

    public HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String connectorName;
        private String language;
        private Boolean sentimentAnalysis;
        private String statusCallback;
        private HttpMethod statusCallbackMethod;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a VirtualAgent.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="connectorName")
        public Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="language")
        public Builder language(String language) {
            this.language = language;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="sentimentAnalysis")
        public Builder sentimentAnalysis(Boolean sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallback")
        public Builder statusCallback(String statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackMethod")
        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Config")
        public Builder config(Config config) {
            this.children.add(config);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Parameter")
        public Builder parameter(Parameter parameter) {
            this.children.add(parameter);
            return this;
        }

        public VirtualAgent build() {
            return new VirtualAgent(this);
        }
    }
}

