/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Sip
extends TwiML {
    private final String username;
    private final String password;
    private final URI url;
    private final HttpMethod method;
    private final List<Event> statusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String machineDetection;
    private final HttpMethod amdStatusCallbackMethod;
    private final String amdStatusCallback;
    private final Integer machineDetectionTimeout;
    private final Integer machineDetectionSpeechThreshold;
    private final Integer machineDetectionSpeechEndThreshold;
    private final Integer machineDetectionSilenceTimeout;
    private final URI sipUrl;

    private Sip() {
        this(new Builder((URI)null));
    }

    private Sip(Builder b) {
        super("Sip", b);
        this.username = b.username;
        this.password = b.password;
        this.url = b.url;
        this.method = b.method;
        this.statusCallbackEvent = b.statusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.machineDetection = b.machineDetection;
        this.amdStatusCallbackMethod = b.amdStatusCallbackMethod;
        this.amdStatusCallback = b.amdStatusCallback;
        this.machineDetectionTimeout = b.machineDetectionTimeout;
        this.machineDetectionSpeechThreshold = b.machineDetectionSpeechThreshold;
        this.machineDetectionSpeechEndThreshold = b.machineDetectionSpeechEndThreshold;
        this.machineDetectionSilenceTimeout = b.machineDetectionSilenceTimeout;
        this.sipUrl = b.sipUrl;
    }

    @Override
    protected String getElementBody() {
        return this.getSipUrl() == null ? null : this.getSipUrl().toString();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getUsername() != null) {
            attrs.put("username", this.getUsername());
        }
        if (this.getPassword() != null) {
            attrs.put("password", this.getPassword());
        }
        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getMachineDetection() != null) {
            attrs.put("machineDetection", this.getMachineDetection());
        }
        if (this.getAmdStatusCallbackMethod() != null) {
            attrs.put("amdStatusCallbackMethod", this.getAmdStatusCallbackMethod().toString());
        }
        if (this.getAmdStatusCallback() != null) {
            attrs.put("amdStatusCallback", this.getAmdStatusCallback());
        }
        if (this.getMachineDetectionTimeout() != null) {
            attrs.put("machineDetectionTimeout", this.getMachineDetectionTimeout().toString());
        }
        if (this.getMachineDetectionSpeechThreshold() != null) {
            attrs.put("machineDetectionSpeechThreshold", this.getMachineDetectionSpeechThreshold().toString());
        }
        if (this.getMachineDetectionSpeechEndThreshold() != null) {
            attrs.put("machineDetectionSpeechEndThreshold", this.getMachineDetectionSpeechEndThreshold().toString());
        }
        if (this.getMachineDetectionSilenceTimeout() != null) {
            attrs.put("machineDetectionSilenceTimeout", this.getMachineDetectionSilenceTimeout().toString());
        }
        return attrs;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Event> getStatusCallbackEvents() {
        return this.statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public String getMachineDetection() {
        return this.machineDetection;
    }

    public HttpMethod getAmdStatusCallbackMethod() {
        return this.amdStatusCallbackMethod;
    }

    public String getAmdStatusCallback() {
        return this.amdStatusCallback;
    }

    public Integer getMachineDetectionTimeout() {
        return this.machineDetectionTimeout;
    }

    public Integer getMachineDetectionSpeechThreshold() {
        return this.machineDetectionSpeechThreshold;
    }

    public Integer getMachineDetectionSpeechEndThreshold() {
        return this.machineDetectionSpeechEndThreshold;
    }

    public Integer getMachineDetectionSilenceTimeout() {
        return this.machineDetectionSilenceTimeout;
    }

    public URI getSipUrl() {
        return this.sipUrl;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String username;
        private String password;
        private URI url;
        private HttpMethod method;
        private List<Event> statusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private String machineDetection;
        private HttpMethod amdStatusCallbackMethod;
        private String amdStatusCallback;
        private Integer machineDetectionTimeout;
        private Integer machineDetectionSpeechThreshold;
        private Integer machineDetectionSpeechEndThreshold;
        private Integer machineDetectionSilenceTimeout;
        private URI sipUrl;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Sip.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(URI sipUrl) {
            this.sipUrl = sipUrl;
        }

        public Builder(String sipUrl) {
            this.sipUrl = Promoter.uriFromString(sipUrl);
        }

        private Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="username")
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="password")
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="url")
        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackEvent")
        public Builder statusCallbackEvents(List<Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        public Builder statusCallbackEvents(Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallback")
        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackMethod")
        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="machineDetection")
        public Builder machineDetection(String machineDetection) {
            this.machineDetection = machineDetection;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="amdStatusCallbackMethod")
        public Builder amdStatusCallbackMethod(HttpMethod amdStatusCallbackMethod) {
            this.amdStatusCallbackMethod = amdStatusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="amdStatusCallback")
        public Builder amdStatusCallback(String amdStatusCallback) {
            this.amdStatusCallback = amdStatusCallback;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="machineDetectionTimeout")
        public Builder machineDetectionTimeout(Integer machineDetectionTimeout) {
            this.machineDetectionTimeout = machineDetectionTimeout;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="machineDetectionSpeechThreshold")
        public Builder machineDetectionSpeechThreshold(Integer machineDetectionSpeechThreshold) {
            this.machineDetectionSpeechThreshold = machineDetectionSpeechThreshold;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="machineDetectionSpeechEndThreshold")
        public Builder machineDetectionSpeechEndThreshold(Integer machineDetectionSpeechEndThreshold) {
            this.machineDetectionSpeechEndThreshold = machineDetectionSpeechEndThreshold;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="machineDetectionSilenceTimeout")
        public Builder machineDetectionSilenceTimeout(Integer machineDetectionSilenceTimeout) {
            this.machineDetectionSilenceTimeout = machineDetectionSilenceTimeout;
            return this;
        }

        public Sip build() {
            return new Sip(this);
        }
    }

    public static enum Event {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

