/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.SsmlBreak;
import com.twilio.twiml.voice.SsmlEmphasis;
import com.twilio.twiml.voice.SsmlLang;
import com.twilio.twiml.voice.SsmlP;
import com.twilio.twiml.voice.SsmlPhoneme;
import com.twilio.twiml.voice.SsmlProsody;
import com.twilio.twiml.voice.SsmlS;
import com.twilio.twiml.voice.SsmlSayAs;
import com.twilio.twiml.voice.SsmlSub;
import com.twilio.twiml.voice.SsmlW;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Say
extends TwiML {
    private final Voice voice;
    private final Integer loop;
    private final Language language;
    private final String message;

    private Say() {
        this(new Builder());
    }

    private Say(Builder b) {
        super("Say", b);
        this.voice = b.voice;
        this.loop = b.loop;
        this.language = b.language;
        this.message = b.message;
    }

    @Override
    protected String getElementBody() {
        return this.getMessage() == null ? null : this.getMessage();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getVoice() != null) {
            attrs.put("voice", this.getVoice().toString());
        }
        if (this.getLoop() != null) {
            attrs.put("loop", this.getLoop().toString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }
        return attrs;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getMessage() {
        return this.message;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private Voice voice;
        private Integer loop;
        private Language language;
        private String message;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Say.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String message) {
            this.message = message;
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="voice")
        public Builder voice(Voice voice) {
            this.voice = voice;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="loop")
        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="language")
        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="break")
        public Builder break_(SsmlBreak ssmlBreak) {
            this.children.add(ssmlBreak);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="emphasis")
        public Builder emphasis(SsmlEmphasis ssmlEmphasis) {
            this.children.add(ssmlEmphasis);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="lang")
        public Builder lang(SsmlLang ssmlLang) {
            this.children.add(ssmlLang);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="p")
        public Builder p(SsmlP ssmlP) {
            this.children.add(ssmlP);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="phoneme")
        public Builder phoneme(SsmlPhoneme ssmlPhoneme) {
            this.children.add(ssmlPhoneme);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="prosody")
        public Builder prosody(SsmlProsody ssmlProsody) {
            this.children.add(ssmlProsody);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="s")
        public Builder s(SsmlS ssmlS) {
            this.children.add(ssmlS);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="say-as")
        public Builder sayAs(SsmlSayAs ssmlSayAs) {
            this.children.add(ssmlSayAs);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="sub")
        public Builder sub(SsmlSub ssmlSub) {
            this.children.add(ssmlSub);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="w")
        public Builder w(SsmlW ssmlW) {
            this.children.add(ssmlW);
            return this;
        }

        public Say build() {
            return new Say(this);
        }
    }

    public static enum Language {
        AF_ZA("af-ZA"),
        AM_ET("am-ET"),
        AR_AE("ar-AE"),
        AR_XA("ar-XA"),
        ARB("arb"),
        BG_BG("bg-BG"),
        BN_IN("bn-IN"),
        CA_ES("ca-ES"),
        CMN_CN("cmn-CN"),
        CMN_TW("cmn-TW"),
        CS_CZ("cs-CZ"),
        CY_GB("cy-GB"),
        DA_DK("da-DK"),
        DE_AT("de-AT"),
        DE_DE("de-DE"),
        EL_GR("el-GR"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_GB_WLS("en-GB-WLS"),
        EN_IE("en-IE"),
        EN_IN("en-IN"),
        EN_NZ("en-NZ"),
        EN_US("en-US"),
        EN_ZA("en-ZA"),
        ES_ES("es-ES"),
        ES_MX("es-MX"),
        ES_US("es-US"),
        FI_FI("fi-FI"),
        FIL_PH("fil-PH"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        FR_BE("fr-BE"),
        GU_IN("gu-IN"),
        HE_IL("he-IL"),
        HI_IN("hi-IN"),
        HU_HU("hu-HU"),
        ID_ID("id-ID"),
        IS_IS("is-IS"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        KN_IN("kn-IN"),
        KO_KR("ko-KR"),
        LV_LV("lv-LV"),
        ML_IN("ml-IN"),
        MR_IN("mr-IN"),
        MS_MY("ms-MY"),
        NB_NO("nb-NO"),
        NL_BE("nl-BE"),
        NL_NL("nl-NL"),
        PA_IN("pa-IN"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RO_RO("ro-RO"),
        RU_RU("ru-RU"),
        SK_SK("sk-SK"),
        SR_RS("sr-RS"),
        SV_SE("sv-SE"),
        TA_IN("ta-IN"),
        TE_IN("te-IN"),
        TH_TH("th-TH"),
        TR_TR("tr-TR"),
        UK_UA("uk-UA"),
        VI_VN("vi-VN"),
        YUE_HK("yue-HK"),
        ZH_CN("zh-CN"),
        ZH_HK("zh-HK"),
        ZH_TW("zh-TW");

        private final String value;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Voice {
        MAN("man"),
        WOMAN("woman"),
        ALICE("alice"),
        GOOGLE_AF_ZA_STANDARD_A("Google.af-ZA-Standard-A"),
        GOOGLE_AM_ET_STANDARD_A("Google.am-ET-Standard-A"),
        GOOGLE_AM_ET_STANDARD_B("Google.am-ET-Standard-B"),
        GOOGLE_AM_ET_WAVENET_A("Google.am-ET-Wavenet-A"),
        GOOGLE_AM_ET_WAVENET_B("Google.am-ET-Wavenet-B"),
        GOOGLE_AR_XA_STANDARD_A("Google.ar-XA-Standard-A"),
        GOOGLE_AR_XA_STANDARD_B("Google.ar-XA-Standard-B"),
        GOOGLE_AR_XA_STANDARD_C("Google.ar-XA-Standard-C"),
        GOOGLE_AR_XA_STANDARD_D("Google.ar-XA-Standard-D"),
        GOOGLE_AR_XA_WAVENET_A("Google.ar-XA-Wavenet-A"),
        GOOGLE_AR_XA_WAVENET_B("Google.ar-XA-Wavenet-B"),
        GOOGLE_AR_XA_WAVENET_C("Google.ar-XA-Wavenet-C"),
        GOOGLE_AR_XA_WAVENET_D("Google.ar-XA-Wavenet-D"),
        GOOGLE_BG_BG_STANDARD_A("Google.bg-BG-Standard-A"),
        GOOGLE_BN_IN_STANDARD_C("Google.bn-IN-Standard-C"),
        GOOGLE_BN_IN_STANDARD_D("Google.bn-IN-Standard-D"),
        GOOGLE_BN_IN_WAVENET_C("Google.bn-IN-Wavenet-C"),
        GOOGLE_BN_IN_WAVENET_D("Google.bn-IN-Wavenet-D"),
        GOOGLE_CA_ES_STANDARD_A("Google.ca-ES-Standard-A"),
        GOOGLE_CMN_CN_STANDARD_A("Google.cmn-CN-Standard-A"),
        GOOGLE_CMN_CN_STANDARD_B("Google.cmn-CN-Standard-B"),
        GOOGLE_CMN_CN_STANDARD_C("Google.cmn-CN-Standard-C"),
        GOOGLE_CMN_CN_STANDARD_D("Google.cmn-CN-Standard-D"),
        GOOGLE_CMN_CN_WAVENET_A("Google.cmn-CN-Wavenet-A"),
        GOOGLE_CMN_CN_WAVENET_B("Google.cmn-CN-Wavenet-B"),
        GOOGLE_CMN_CN_WAVENET_C("Google.cmn-CN-Wavenet-C"),
        GOOGLE_CMN_CN_WAVENET_D("Google.cmn-CN-Wavenet-D"),
        GOOGLE_CMN_TW_STANDARD_A("Google.cmn-TW-Standard-A"),
        GOOGLE_CMN_TW_STANDARD_B("Google.cmn-TW-Standard-B"),
        GOOGLE_CMN_TW_STANDARD_C("Google.cmn-TW-Standard-C"),
        GOOGLE_CMN_TW_WAVENET_A("Google.cmn-TW-Wavenet-A"),
        GOOGLE_CMN_TW_WAVENET_B("Google.cmn-TW-Wavenet-B"),
        GOOGLE_CMN_TW_WAVENET_C("Google.cmn-TW-Wavenet-C"),
        GOOGLE_CS_CZ_STANDARD_A("Google.cs-CZ-Standard-A"),
        GOOGLE_CS_CZ_WAVENET_A("Google.cs-CZ-Wavenet-A"),
        GOOGLE_DA_DK_NEURAL2_D("Google.da-DK-Neural2-D"),
        GOOGLE_DA_DK_NEURAL2_F("Google.da-DK-Neural2-F"),
        GOOGLE_DA_DK_STANDARD_A("Google.da-DK-Standard-A"),
        GOOGLE_DA_DK_STANDARD_C("Google.da-DK-Standard-C"),
        GOOGLE_DA_DK_STANDARD_D("Google.da-DK-Standard-D"),
        GOOGLE_DA_DK_STANDARD_E("Google.da-DK-Standard-E"),
        GOOGLE_DA_DK_WAVENET_A("Google.da-DK-Wavenet-A"),
        GOOGLE_DA_DK_WAVENET_C("Google.da-DK-Wavenet-C"),
        GOOGLE_DA_DK_WAVENET_D("Google.da-DK-Wavenet-D"),
        GOOGLE_DA_DK_WAVENET_E("Google.da-DK-Wavenet-E"),
        GOOGLE_DE_DE_NEURAL2_A("Google.de-DE-Neural2-A"),
        GOOGLE_DE_DE_NEURAL2_B("Google.de-DE-Neural2-B"),
        GOOGLE_DE_DE_NEURAL2_C("Google.de-DE-Neural2-C"),
        GOOGLE_DE_DE_NEURAL2_D("Google.de-DE-Neural2-D"),
        GOOGLE_DE_DE_NEURAL2_F("Google.de-DE-Neural2-F"),
        GOOGLE_DE_DE_STANDARD_A("Google.de-DE-Standard-A"),
        GOOGLE_DE_DE_STANDARD_B("Google.de-DE-Standard-B"),
        GOOGLE_DE_DE_STANDARD_C("Google.de-DE-Standard-C"),
        GOOGLE_DE_DE_STANDARD_D("Google.de-DE-Standard-D"),
        GOOGLE_DE_DE_STANDARD_E("Google.de-DE-Standard-E"),
        GOOGLE_DE_DE_STANDARD_F("Google.de-DE-Standard-F"),
        GOOGLE_DE_DE_WAVENET_A("Google.de-DE-Wavenet-A"),
        GOOGLE_DE_DE_WAVENET_B("Google.de-DE-Wavenet-B"),
        GOOGLE_DE_DE_WAVENET_C("Google.de-DE-Wavenet-C"),
        GOOGLE_DE_DE_WAVENET_D("Google.de-DE-Wavenet-D"),
        GOOGLE_DE_DE_WAVENET_E("Google.de-DE-Wavenet-E"),
        GOOGLE_DE_DE_WAVENET_F("Google.de-DE-Wavenet-F"),
        GOOGLE_EL_GR_STANDARD_A("Google.el-GR-Standard-A"),
        GOOGLE_EL_GR_WAVENET_A("Google.el-GR-Wavenet-A"),
        GOOGLE_EN_AU_NEURAL2_A("Google.en-AU-Neural2-A"),
        GOOGLE_EN_AU_NEURAL2_B("Google.en-AU-Neural2-B"),
        GOOGLE_EN_AU_NEURAL2_C("Google.en-AU-Neural2-C"),
        GOOGLE_EN_AU_NEURAL2_D("Google.en-AU-Neural2-D"),
        GOOGLE_EN_AU_STANDARD_A("Google.en-AU-Standard-A"),
        GOOGLE_EN_AU_STANDARD_B("Google.en-AU-Standard-B"),
        GOOGLE_EN_AU_STANDARD_C("Google.en-AU-Standard-C"),
        GOOGLE_EN_AU_STANDARD_D("Google.en-AU-Standard-D"),
        GOOGLE_EN_AU_WAVENET_A("Google.en-AU-Wavenet-A"),
        GOOGLE_EN_AU_WAVENET_B("Google.en-AU-Wavenet-B"),
        GOOGLE_EN_AU_WAVENET_C("Google.en-AU-Wavenet-C"),
        GOOGLE_EN_AU_WAVENET_D("Google.en-AU-Wavenet-D"),
        GOOGLE_EN_GB_NEURAL2_A("Google.en-GB-Neural2-A"),
        GOOGLE_EN_GB_NEURAL2_B("Google.en-GB-Neural2-B"),
        GOOGLE_EN_GB_NEURAL2_C("Google.en-GB-Neural2-C"),
        GOOGLE_EN_GB_NEURAL2_D("Google.en-GB-Neural2-D"),
        GOOGLE_EN_GB_NEURAL2_F("Google.en-GB-Neural2-F"),
        GOOGLE_EN_GB_STANDARD_A("Google.en-GB-Standard-A"),
        GOOGLE_EN_GB_STANDARD_B("Google.en-GB-Standard-B"),
        GOOGLE_EN_GB_STANDARD_C("Google.en-GB-Standard-C"),
        GOOGLE_EN_GB_STANDARD_D("Google.en-GB-Standard-D"),
        GOOGLE_EN_GB_STANDARD_F("Google.en-GB-Standard-F"),
        GOOGLE_EN_GB_WAVENET_A("Google.en-GB-Wavenet-A"),
        GOOGLE_EN_GB_WAVENET_B("Google.en-GB-Wavenet-B"),
        GOOGLE_EN_GB_WAVENET_C("Google.en-GB-Wavenet-C"),
        GOOGLE_EN_GB_WAVENET_D("Google.en-GB-Wavenet-D"),
        GOOGLE_EN_GB_WAVENET_F("Google.en-GB-Wavenet-F"),
        GOOGLE_EN_IN_NEURAL2_A("Google.en-IN-Neural2-A"),
        GOOGLE_EN_IN_NEURAL2_B("Google.en-IN-Neural2-B"),
        GOOGLE_EN_IN_NEURAL2_C("Google.en-IN-Neural2-C"),
        GOOGLE_EN_IN_NEURAL2_D("Google.en-IN-Neural2-D"),
        GOOGLE_EN_IN_STANDARD_A("Google.en-IN-Standard-A"),
        GOOGLE_EN_IN_STANDARD_B("Google.en-IN-Standard-B"),
        GOOGLE_EN_IN_STANDARD_C("Google.en-IN-Standard-C"),
        GOOGLE_EN_IN_STANDARD_D("Google.en-IN-Standard-D"),
        GOOGLE_EN_IN_WAVENET_A("Google.en-IN-Wavenet-A"),
        GOOGLE_EN_IN_WAVENET_B("Google.en-IN-Wavenet-B"),
        GOOGLE_EN_IN_WAVENET_C("Google.en-IN-Wavenet-C"),
        GOOGLE_EN_IN_WAVENET_D("Google.en-IN-Wavenet-D"),
        GOOGLE_EN_US_NEURAL2_A("Google.en-US-Neural2-A"),
        GOOGLE_EN_US_NEURAL2_C("Google.en-US-Neural2-C"),
        GOOGLE_EN_US_NEURAL2_D("Google.en-US-Neural2-D"),
        GOOGLE_EN_US_NEURAL2_E("Google.en-US-Neural2-E"),
        GOOGLE_EN_US_NEURAL2_F("Google.en-US-Neural2-F"),
        GOOGLE_EN_US_NEURAL2_G("Google.en-US-Neural2-G"),
        GOOGLE_EN_US_NEURAL2_H("Google.en-US-Neural2-H"),
        GOOGLE_EN_US_NEURAL2_I("Google.en-US-Neural2-I"),
        GOOGLE_EN_US_NEURAL2_J("Google.en-US-Neural2-J"),
        GOOGLE_EN_US_STANDARD_A("Google.en-US-Standard-A"),
        GOOGLE_EN_US_STANDARD_B("Google.en-US-Standard-B"),
        GOOGLE_EN_US_STANDARD_C("Google.en-US-Standard-C"),
        GOOGLE_EN_US_STANDARD_D("Google.en-US-Standard-D"),
        GOOGLE_EN_US_STANDARD_E("Google.en-US-Standard-E"),
        GOOGLE_EN_US_STANDARD_F("Google.en-US-Standard-F"),
        GOOGLE_EN_US_STANDARD_G("Google.en-US-Standard-G"),
        GOOGLE_EN_US_STANDARD_H("Google.en-US-Standard-H"),
        GOOGLE_EN_US_STANDARD_I("Google.en-US-Standard-I"),
        GOOGLE_EN_US_STANDARD_J("Google.en-US-Standard-J"),
        GOOGLE_EN_US_WAVENET_A("Google.en-US-Wavenet-A"),
        GOOGLE_EN_US_WAVENET_B("Google.en-US-Wavenet-B"),
        GOOGLE_EN_US_WAVENET_C("Google.en-US-Wavenet-C"),
        GOOGLE_EN_US_WAVENET_D("Google.en-US-Wavenet-D"),
        GOOGLE_EN_US_WAVENET_E("Google.en-US-Wavenet-E"),
        GOOGLE_EN_US_WAVENET_F("Google.en-US-Wavenet-F"),
        GOOGLE_EN_US_WAVENET_G("Google.en-US-Wavenet-G"),
        GOOGLE_EN_US_WAVENET_H("Google.en-US-Wavenet-H"),
        GOOGLE_EN_US_WAVENET_I("Google.en-US-Wavenet-I"),
        GOOGLE_EN_US_WAVENET_J("Google.en-US-Wavenet-J"),
        GOOGLE_ES_ES_NEURAL2_A("Google.es-ES-Neural2-A"),
        GOOGLE_ES_ES_NEURAL2_B("Google.es-ES-Neural2-B"),
        GOOGLE_ES_ES_NEURAL2_C("Google.es-ES-Neural2-C"),
        GOOGLE_ES_ES_NEURAL2_D("Google.es-ES-Neural2-D"),
        GOOGLE_ES_ES_NEURAL2_E("Google.es-ES-Neural2-E"),
        GOOGLE_ES_ES_NEURAL2_F("Google.es-ES-Neural2-F"),
        GOOGLE_ES_ES_STANDARD_B("Google.es-ES-Standard-B"),
        GOOGLE_ES_ES_STANDARD_C("Google.es-ES-Standard-C"),
        GOOGLE_ES_ES_STANDARD_D("Google.es-ES-Standard-D"),
        GOOGLE_ES_ES_WAVENET_B("Google.es-ES-Wavenet-B"),
        GOOGLE_ES_ES_WAVENET_C("Google.es-ES-Wavenet-C"),
        GOOGLE_ES_ES_WAVENET_D("Google.es-ES-Wavenet-D"),
        GOOGLE_ES_US_NEURAL2_A("Google.es-US-Neural2-A"),
        GOOGLE_ES_US_NEURAL2_B("Google.es-US-Neural2-B"),
        GOOGLE_ES_US_NEURAL2_C("Google.es-US-Neural2-C"),
        GOOGLE_ES_US_STANDARD_A("Google.es-US-Standard-A"),
        GOOGLE_ES_US_STANDARD_B("Google.es-US-Standard-B"),
        GOOGLE_ES_US_STANDARD_C("Google.es-US-Standard-C"),
        GOOGLE_ES_US_WAVENET_A("Google.es-US-Wavenet-A"),
        GOOGLE_ES_US_WAVENET_B("Google.es-US-Wavenet-B"),
        GOOGLE_ES_US_WAVENET_C("Google.es-US-Wavenet-C"),
        GOOGLE_EU_ES_STANDARD_A("Google.eu-ES-Standard-A"),
        GOOGLE_FI_FI_STANDARD_A("Google.fi-FI-Standard-A"),
        GOOGLE_FI_FI_WAVENET_A("Google.fi-FI-Wavenet-A"),
        GOOGLE_FIL_PH_STANDARD_A("Google.fil-PH-Standard-A"),
        GOOGLE_FIL_PH_STANDARD_B("Google.fil-PH-Standard-B"),
        GOOGLE_FIL_PH_STANDARD_C("Google.fil-PH-Standard-C"),
        GOOGLE_FIL_PH_STANDARD_D("Google.fil-PH-Standard-D"),
        GOOGLE_FIL_PH_WAVENET_A("Google.fil-PH-Wavenet-A"),
        GOOGLE_FIL_PH_WAVENET_B("Google.fil-PH-Wavenet-B"),
        GOOGLE_FIL_PH_WAVENET_C("Google.fil-PH-Wavenet-C"),
        GOOGLE_FIL_PH_WAVENET_D("Google.fil-PH-Wavenet-D"),
        GOOGLE_FIL_PH_NEURAL2_A("Google.fil-ph-Neural2-A"),
        GOOGLE_FIL_PH_NEURAL2_D("Google.fil-ph-Neural2-D"),
        GOOGLE_FR_CA_NEURAL2_A("Google.fr-CA-Neural2-A"),
        GOOGLE_FR_CA_NEURAL2_B("Google.fr-CA-Neural2-B"),
        GOOGLE_FR_CA_NEURAL2_C("Google.fr-CA-Neural2-C"),
        GOOGLE_FR_CA_NEURAL2_D("Google.fr-CA-Neural2-D"),
        GOOGLE_FR_CA_STANDARD_A("Google.fr-CA-Standard-A"),
        GOOGLE_FR_CA_STANDARD_B("Google.fr-CA-Standard-B"),
        GOOGLE_FR_CA_STANDARD_C("Google.fr-CA-Standard-C"),
        GOOGLE_FR_CA_STANDARD_D("Google.fr-CA-Standard-D"),
        GOOGLE_FR_CA_WAVENET_A("Google.fr-CA-Wavenet-A"),
        GOOGLE_FR_CA_WAVENET_B("Google.fr-CA-Wavenet-B"),
        GOOGLE_FR_CA_WAVENET_C("Google.fr-CA-Wavenet-C"),
        GOOGLE_FR_CA_WAVENET_D("Google.fr-CA-Wavenet-D"),
        GOOGLE_FR_FR_NEURAL2_A("Google.fr-FR-Neural2-A"),
        GOOGLE_FR_FR_NEURAL2_B("Google.fr-FR-Neural2-B"),
        GOOGLE_FR_FR_NEURAL2_C("Google.fr-FR-Neural2-C"),
        GOOGLE_FR_FR_NEURAL2_D("Google.fr-FR-Neural2-D"),
        GOOGLE_FR_FR_NEURAL2_E("Google.fr-FR-Neural2-E"),
        GOOGLE_FR_FR_STANDARD_A("Google.fr-FR-Standard-A"),
        GOOGLE_FR_FR_STANDARD_B("Google.fr-FR-Standard-B"),
        GOOGLE_FR_FR_STANDARD_C("Google.fr-FR-Standard-C"),
        GOOGLE_FR_FR_STANDARD_D("Google.fr-FR-Standard-D"),
        GOOGLE_FR_FR_STANDARD_E("Google.fr-FR-Standard-E"),
        GOOGLE_FR_FR_WAVENET_A("Google.fr-FR-Wavenet-A"),
        GOOGLE_FR_FR_WAVENET_B("Google.fr-FR-Wavenet-B"),
        GOOGLE_FR_FR_WAVENET_C("Google.fr-FR-Wavenet-C"),
        GOOGLE_FR_FR_WAVENET_D("Google.fr-FR-Wavenet-D"),
        GOOGLE_FR_FR_WAVENET_E("Google.fr-FR-Wavenet-E"),
        GOOGLE_GL_ES_STANDARD_A("Google.gl-ES-Standard-A"),
        GOOGLE_GU_IN_STANDARD_C("Google.gu-IN-Standard-C"),
        GOOGLE_GU_IN_STANDARD_D("Google.gu-IN-Standard-D"),
        GOOGLE_GU_IN_WAVENET_C("Google.gu-IN-Wavenet-C"),
        GOOGLE_GU_IN_WAVENET_D("Google.gu-IN-Wavenet-D"),
        GOOGLE_HE_IL_STANDARD_A("Google.he-IL-Standard-A"),
        GOOGLE_HE_IL_STANDARD_B("Google.he-IL-Standard-B"),
        GOOGLE_HE_IL_STANDARD_C("Google.he-IL-Standard-C"),
        GOOGLE_HE_IL_STANDARD_D("Google.he-IL-Standard-D"),
        GOOGLE_HE_IL_WAVENET_A("Google.he-IL-Wavenet-A"),
        GOOGLE_HE_IL_WAVENET_B("Google.he-IL-Wavenet-B"),
        GOOGLE_HE_IL_WAVENET_C("Google.he-IL-Wavenet-C"),
        GOOGLE_HE_IL_WAVENET_D("Google.he-IL-Wavenet-D"),
        GOOGLE_HI_IN_NEURAL2_A("Google.hi-IN-Neural2-A"),
        GOOGLE_HI_IN_NEURAL2_B("Google.hi-IN-Neural2-B"),
        GOOGLE_HI_IN_NEURAL2_C("Google.hi-IN-Neural2-C"),
        GOOGLE_HI_IN_NEURAL2_D("Google.hi-IN-Neural2-D"),
        GOOGLE_HI_IN_STANDARD_A("Google.hi-IN-Standard-A"),
        GOOGLE_HI_IN_STANDARD_B("Google.hi-IN-Standard-B"),
        GOOGLE_HI_IN_STANDARD_C("Google.hi-IN-Standard-C"),
        GOOGLE_HI_IN_STANDARD_D("Google.hi-IN-Standard-D"),
        GOOGLE_HI_IN_WAVENET_A("Google.hi-IN-Wavenet-A"),
        GOOGLE_HI_IN_WAVENET_B("Google.hi-IN-Wavenet-B"),
        GOOGLE_HI_IN_WAVENET_C("Google.hi-IN-Wavenet-C"),
        GOOGLE_HI_IN_WAVENET_D("Google.hi-IN-Wavenet-D"),
        GOOGLE_HU_HU_STANDARD_A("Google.hu-HU-Standard-A"),
        GOOGLE_HU_HU_WAVENET_A("Google.hu-HU-Wavenet-A"),
        GOOGLE_ID_ID_STANDARD_A("Google.id-ID-Standard-A"),
        GOOGLE_ID_ID_STANDARD_B("Google.id-ID-Standard-B"),
        GOOGLE_ID_ID_STANDARD_C("Google.id-ID-Standard-C"),
        GOOGLE_ID_ID_STANDARD_D("Google.id-ID-Standard-D"),
        GOOGLE_ID_ID_WAVENET_A("Google.id-ID-Wavenet-A"),
        GOOGLE_ID_ID_WAVENET_B("Google.id-ID-Wavenet-B"),
        GOOGLE_ID_ID_WAVENET_C("Google.id-ID-Wavenet-C"),
        GOOGLE_ID_ID_WAVENET_D("Google.id-ID-Wavenet-D"),
        GOOGLE_IS_IS_STANDARD_A("Google.is-IS-Standard-A"),
        GOOGLE_IT_IT_NEURAL2_A("Google.it-IT-Neural2-A"),
        GOOGLE_IT_IT_NEURAL2_C("Google.it-IT-Neural2-C"),
        GOOGLE_IT_IT_STANDARD_B("Google.it-IT-Standard-B"),
        GOOGLE_IT_IT_STANDARD_C("Google.it-IT-Standard-C"),
        GOOGLE_IT_IT_STANDARD_D("Google.it-IT-Standard-D"),
        GOOGLE_IT_IT_WAVENET_B("Google.it-IT-Wavenet-B"),
        GOOGLE_IT_IT_WAVENET_C("Google.it-IT-Wavenet-C"),
        GOOGLE_IT_IT_WAVENET_D("Google.it-IT-Wavenet-D"),
        GOOGLE_JA_JP_NEURAL2_B("Google.ja-JP-Neural2-B"),
        GOOGLE_JA_JP_NEURAL2_C("Google.ja-JP-Neural2-C"),
        GOOGLE_JA_JP_NEURAL2_D("Google.ja-JP-Neural2-D"),
        GOOGLE_JA_JP_STANDARD_A("Google.ja-JP-Standard-A"),
        GOOGLE_JA_JP_STANDARD_B("Google.ja-JP-Standard-B"),
        GOOGLE_JA_JP_STANDARD_C("Google.ja-JP-Standard-C"),
        GOOGLE_JA_JP_STANDARD_D("Google.ja-JP-Standard-D"),
        GOOGLE_JA_JP_WAVENET_A("Google.ja-JP-Wavenet-A"),
        GOOGLE_JA_JP_WAVENET_B("Google.ja-JP-Wavenet-B"),
        GOOGLE_JA_JP_WAVENET_C("Google.ja-JP-Wavenet-C"),
        GOOGLE_JA_JP_WAVENET_D("Google.ja-JP-Wavenet-D"),
        GOOGLE_KN_IN_STANDARD_C("Google.kn-IN-Standard-C"),
        GOOGLE_KN_IN_STANDARD_D("Google.kn-IN-Standard-D"),
        GOOGLE_KN_IN_WAVENET_C("Google.kn-IN-Wavenet-C"),
        GOOGLE_KN_IN_WAVENET_D("Google.kn-IN-Wavenet-D"),
        GOOGLE_KO_KR_NEURAL2_A("Google.ko-KR-Neural2-A"),
        GOOGLE_KO_KR_NEURAL2_B("Google.ko-KR-Neural2-B"),
        GOOGLE_KO_KR_NEURAL2_C("Google.ko-KR-Neural2-C"),
        GOOGLE_KO_KR_STANDARD_A("Google.ko-KR-Standard-A"),
        GOOGLE_KO_KR_STANDARD_B("Google.ko-KR-Standard-B"),
        GOOGLE_KO_KR_STANDARD_C("Google.ko-KR-Standard-C"),
        GOOGLE_KO_KR_STANDARD_D("Google.ko-KR-Standard-D"),
        GOOGLE_KO_KR_WAVENET_A("Google.ko-KR-Wavenet-A"),
        GOOGLE_KO_KR_WAVENET_B("Google.ko-KR-Wavenet-B"),
        GOOGLE_KO_KR_WAVENET_C("Google.ko-KR-Wavenet-C"),
        GOOGLE_KO_KR_WAVENET_D("Google.ko-KR-Wavenet-D"),
        GOOGLE_LT_LT_STANDARD_A("Google.lt-LT-Standard-A"),
        GOOGLE_LV_LV_STANDARD_A("Google.lv-LV-Standard-A"),
        GOOGLE_ML_IN_WAVENET_C("Google.ml-IN-Wavenet-C"),
        GOOGLE_ML_IN_WAVENET_D("Google.ml-IN-Wavenet-D"),
        GOOGLE_MR_IN_STANDARD_A("Google.mr-IN-Standard-A"),
        GOOGLE_MR_IN_STANDARD_B("Google.mr-IN-Standard-B"),
        GOOGLE_MR_IN_STANDARD_C("Google.mr-IN-Standard-C"),
        GOOGLE_MR_IN_WAVENET_A("Google.mr-IN-Wavenet-A"),
        GOOGLE_MR_IN_WAVENET_B("Google.mr-IN-Wavenet-B"),
        GOOGLE_MR_IN_WAVENET_C("Google.mr-IN-Wavenet-C"),
        GOOGLE_MS_MY_STANDARD_A("Google.ms-MY-Standard-A"),
        GOOGLE_MS_MY_STANDARD_B("Google.ms-MY-Standard-B"),
        GOOGLE_MS_MY_STANDARD_C("Google.ms-MY-Standard-C"),
        GOOGLE_MS_MY_STANDARD_D("Google.ms-MY-Standard-D"),
        GOOGLE_MS_MY_WAVENET_A("Google.ms-MY-Wavenet-A"),
        GOOGLE_MS_MY_WAVENET_B("Google.ms-MY-Wavenet-B"),
        GOOGLE_MS_MY_WAVENET_C("Google.ms-MY-Wavenet-C"),
        GOOGLE_MS_MY_WAVENET_D("Google.ms-MY-Wavenet-D"),
        GOOGLE_NB_NO_STANDARD_A("Google.nb-NO-Standard-A"),
        GOOGLE_NB_NO_STANDARD_B("Google.nb-NO-Standard-B"),
        GOOGLE_NB_NO_STANDARD_C("Google.nb-NO-Standard-C"),
        GOOGLE_NB_NO_STANDARD_D("Google.nb-NO-Standard-D"),
        GOOGLE_NB_NO_STANDARD_E("Google.nb-NO-Standard-E"),
        GOOGLE_NB_NO_WAVENET_A("Google.nb-NO-Wavenet-A"),
        GOOGLE_NB_NO_WAVENET_B("Google.nb-NO-Wavenet-B"),
        GOOGLE_NB_NO_WAVENET_C("Google.nb-NO-Wavenet-C"),
        GOOGLE_NB_NO_WAVENET_D("Google.nb-NO-Wavenet-D"),
        GOOGLE_NB_NO_WAVENET_E("Google.nb-NO-Wavenet-E"),
        GOOGLE_NL_BE_STANDARD_A("Google.nl-BE-Standard-A"),
        GOOGLE_NL_BE_STANDARD_B("Google.nl-BE-Standard-B"),
        GOOGLE_NL_BE_WAVENET_A("Google.nl-BE-Wavenet-A"),
        GOOGLE_NL_BE_WAVENET_B("Google.nl-BE-Wavenet-B"),
        GOOGLE_NL_NL_STANDARD_A("Google.nl-NL-Standard-A"),
        GOOGLE_NL_NL_STANDARD_B("Google.nl-NL-Standard-B"),
        GOOGLE_NL_NL_STANDARD_C("Google.nl-NL-Standard-C"),
        GOOGLE_NL_NL_STANDARD_D("Google.nl-NL-Standard-D"),
        GOOGLE_NL_NL_STANDARD_E("Google.nl-NL-Standard-E"),
        GOOGLE_NL_NL_WAVENET_A("Google.nl-NL-Wavenet-A"),
        GOOGLE_NL_NL_WAVENET_B("Google.nl-NL-Wavenet-B"),
        GOOGLE_NL_NL_WAVENET_C("Google.nl-NL-Wavenet-C"),
        GOOGLE_NL_NL_WAVENET_D("Google.nl-NL-Wavenet-D"),
        GOOGLE_NL_NL_WAVENET_E("Google.nl-NL-Wavenet-E"),
        GOOGLE_PA_IN_STANDARD_A("Google.pa-IN-Standard-A"),
        GOOGLE_PA_IN_STANDARD_B("Google.pa-IN-Standard-B"),
        GOOGLE_PA_IN_STANDARD_C("Google.pa-IN-Standard-C"),
        GOOGLE_PA_IN_STANDARD_D("Google.pa-IN-Standard-D"),
        GOOGLE_PA_IN_WAVENET_A("Google.pa-IN-Wavenet-A"),
        GOOGLE_PA_IN_WAVENET_B("Google.pa-IN-Wavenet-B"),
        GOOGLE_PA_IN_WAVENET_C("Google.pa-IN-Wavenet-C"),
        GOOGLE_PA_IN_WAVENET_D("Google.pa-IN-Wavenet-D"),
        GOOGLE_PL_PL_STANDARD_A("Google.pl-PL-Standard-A"),
        GOOGLE_PL_PL_STANDARD_B("Google.pl-PL-Standard-B"),
        GOOGLE_PL_PL_STANDARD_C("Google.pl-PL-Standard-C"),
        GOOGLE_PL_PL_STANDARD_D("Google.pl-PL-Standard-D"),
        GOOGLE_PL_PL_STANDARD_E("Google.pl-PL-Standard-E"),
        GOOGLE_PL_PL_WAVENET_A("Google.pl-PL-Wavenet-A"),
        GOOGLE_PL_PL_WAVENET_B("Google.pl-PL-Wavenet-B"),
        GOOGLE_PL_PL_WAVENET_C("Google.pl-PL-Wavenet-C"),
        GOOGLE_PL_PL_WAVENET_D("Google.pl-PL-Wavenet-D"),
        GOOGLE_PL_PL_WAVENET_E("Google.pl-PL-Wavenet-E"),
        GOOGLE_PT_BR_NEURAL2_A("Google.pt-BR-Neural2-A"),
        GOOGLE_PT_BR_NEURAL2_B("Google.pt-BR-Neural2-B"),
        GOOGLE_PT_BR_NEURAL2_C("Google.pt-BR-Neural2-C"),
        GOOGLE_PT_BR_STANDARD_A("Google.pt-BR-Standard-A"),
        GOOGLE_PT_BR_STANDARD_B("Google.pt-BR-Standard-B"),
        GOOGLE_PT_BR_STANDARD_C("Google.pt-BR-Standard-C"),
        GOOGLE_PT_BR_WAVENET_A("Google.pt-BR-Wavenet-A"),
        GOOGLE_PT_BR_WAVENET_B("Google.pt-BR-Wavenet-B"),
        GOOGLE_PT_BR_WAVENET_C("Google.pt-BR-Wavenet-C"),
        GOOGLE_PT_PT_STANDARD_A("Google.pt-PT-Standard-A"),
        GOOGLE_PT_PT_STANDARD_B("Google.pt-PT-Standard-B"),
        GOOGLE_PT_PT_STANDARD_C("Google.pt-PT-Standard-C"),
        GOOGLE_PT_PT_STANDARD_D("Google.pt-PT-Standard-D"),
        GOOGLE_PT_PT_WAVENET_A("Google.pt-PT-Wavenet-A"),
        GOOGLE_PT_PT_WAVENET_B("Google.pt-PT-Wavenet-B"),
        GOOGLE_PT_PT_WAVENET_C("Google.pt-PT-Wavenet-C"),
        GOOGLE_PT_PT_WAVENET_D("Google.pt-PT-Wavenet-D"),
        GOOGLE_RO_RO_STANDARD_A("Google.ro-RO-Standard-A"),
        GOOGLE_RO_RO_WAVENET_A("Google.ro-RO-Wavenet-A"),
        GOOGLE_RU_RU_STANDARD_A("Google.ru-RU-Standard-A"),
        GOOGLE_RU_RU_STANDARD_B("Google.ru-RU-Standard-B"),
        GOOGLE_RU_RU_STANDARD_C("Google.ru-RU-Standard-C"),
        GOOGLE_RU_RU_STANDARD_D("Google.ru-RU-Standard-D"),
        GOOGLE_RU_RU_STANDARD_E("Google.ru-RU-Standard-E"),
        GOOGLE_RU_RU_WAVENET_A("Google.ru-RU-Wavenet-A"),
        GOOGLE_RU_RU_WAVENET_B("Google.ru-RU-Wavenet-B"),
        GOOGLE_RU_RU_WAVENET_C("Google.ru-RU-Wavenet-C"),
        GOOGLE_RU_RU_WAVENET_D("Google.ru-RU-Wavenet-D"),
        GOOGLE_RU_RU_WAVENET_E("Google.ru-RU-Wavenet-E"),
        GOOGLE_SK_SK_STANDARD_A("Google.sk-SK-Standard-A"),
        GOOGLE_SK_SK_WAVENET_A("Google.sk-SK-Wavenet-A"),
        GOOGLE_SR_RS_STANDARD_A("Google.sr-RS-Standard-A"),
        GOOGLE_SV_SE_STANDARD_A("Google.sv-SE-Standard-A"),
        GOOGLE_SV_SE_STANDARD_B("Google.sv-SE-Standard-B"),
        GOOGLE_SV_SE_STANDARD_C("Google.sv-SE-Standard-C"),
        GOOGLE_SV_SE_STANDARD_D("Google.sv-SE-Standard-D"),
        GOOGLE_SV_SE_STANDARD_E("Google.sv-SE-Standard-E"),
        GOOGLE_SV_SE_WAVENET_A("Google.sv-SE-Wavenet-A"),
        GOOGLE_SV_SE_WAVENET_B("Google.sv-SE-Wavenet-B"),
        GOOGLE_SV_SE_WAVENET_C("Google.sv-SE-Wavenet-C"),
        GOOGLE_SV_SE_WAVENET_D("Google.sv-SE-Wavenet-D"),
        GOOGLE_SV_SE_WAVENET_E("Google.sv-SE-Wavenet-E"),
        GOOGLE_TA_IN_STANDARD_A("Google.ta-IN-Standard-A"),
        GOOGLE_TA_IN_STANDARD_B("Google.ta-IN-Standard-B"),
        GOOGLE_TA_IN_STANDARD_C("Google.ta-IN-Standard-C"),
        GOOGLE_TA_IN_STANDARD_D("Google.ta-IN-Standard-D"),
        GOOGLE_TA_IN_WAVENET_A("Google.ta-IN-Wavenet-A"),
        GOOGLE_TA_IN_WAVENET_B("Google.ta-IN-Wavenet-B"),
        GOOGLE_TA_IN_WAVENET_C("Google.ta-IN-Wavenet-C"),
        GOOGLE_TA_IN_WAVENET_D("Google.ta-IN-Wavenet-D"),
        GOOGLE_TE_IN_STANDARD_A("Google.te-IN-Standard-A"),
        GOOGLE_TE_IN_STANDARD_B("Google.te-IN-Standard-B"),
        GOOGLE_TH_TH_NEURAL2_C("Google.th-TH-Neural2-C"),
        GOOGLE_TH_TH_STANDARD_A("Google.th-TH-Standard-A"),
        GOOGLE_TR_TR_STANDARD_A("Google.tr-TR-Standard-A"),
        GOOGLE_TR_TR_STANDARD_B("Google.tr-TR-Standard-B"),
        GOOGLE_TR_TR_STANDARD_C("Google.tr-TR-Standard-C"),
        GOOGLE_TR_TR_STANDARD_D("Google.tr-TR-Standard-D"),
        GOOGLE_TR_TR_STANDARD_E("Google.tr-TR-Standard-E"),
        GOOGLE_TR_TR_WAVENET_A("Google.tr-TR-Wavenet-A"),
        GOOGLE_TR_TR_WAVENET_B("Google.tr-TR-Wavenet-B"),
        GOOGLE_TR_TR_WAVENET_C("Google.tr-TR-Wavenet-C"),
        GOOGLE_TR_TR_WAVENET_D("Google.tr-TR-Wavenet-D"),
        GOOGLE_TR_TR_WAVENET_E("Google.tr-TR-Wavenet-E"),
        GOOGLE_UK_UA_STANDARD_A("Google.uk-UA-Standard-A"),
        GOOGLE_UK_UA_WAVENET_A("Google.uk-UA-Wavenet-A"),
        GOOGLE_VI_VN_NEURAL2_A("Google.vi-VN-Neural2-A"),
        GOOGLE_VI_VN_NEURAL2_D("Google.vi-VN-Neural2-D"),
        GOOGLE_VI_VN_STANDARD_A("Google.vi-VN-Standard-A"),
        GOOGLE_VI_VN_STANDARD_B("Google.vi-VN-Standard-B"),
        GOOGLE_VI_VN_STANDARD_C("Google.vi-VN-Standard-C"),
        GOOGLE_VI_VN_STANDARD_D("Google.vi-VN-Standard-D"),
        GOOGLE_VI_VN_WAVENET_A("Google.vi-VN-Wavenet-A"),
        GOOGLE_VI_VN_WAVENET_B("Google.vi-VN-Wavenet-B"),
        GOOGLE_VI_VN_WAVENET_C("Google.vi-VN-Wavenet-C"),
        GOOGLE_VI_VN_WAVENET_D("Google.vi-VN-Wavenet-D"),
        GOOGLE_YUE_HK_STANDARD_A("Google.yue-HK-Standard-A"),
        GOOGLE_YUE_HK_STANDARD_B("Google.yue-HK-Standard-B"),
        GOOGLE_YUE_HK_STANDARD_C("Google.yue-HK-Standard-C"),
        GOOGLE_YUE_HK_STANDARD_D("Google.yue-HK-Standard-D"),
        POLLY_ADITI("Polly.Aditi"),
        POLLY_AMY("Polly.Amy"),
        POLLY_ASTRID("Polly.Astrid"),
        POLLY_BIANCA("Polly.Bianca"),
        POLLY_BRIAN("Polly.Brian"),
        POLLY_CAMILA("Polly.Camila"),
        POLLY_CARLA("Polly.Carla"),
        POLLY_CARMEN("Polly.Carmen"),
        POLLY_CELINE("Polly.Celine"),
        POLLY_CHANTAL("Polly.Chantal"),
        POLLY_CONCHITA("Polly.Conchita"),
        POLLY_CRISTIANO("Polly.Cristiano"),
        POLLY_DORA("Polly.Dora"),
        POLLY_EMMA("Polly.Emma"),
        POLLY_ENRIQUE("Polly.Enrique"),
        POLLY_EWA("Polly.Ewa"),
        POLLY_FILIZ("Polly.Filiz"),
        POLLY_GERAINT("Polly.Geraint"),
        POLLY_GIORGIO("Polly.Giorgio"),
        POLLY_GWYNETH("Polly.Gwyneth"),
        POLLY_HANS("Polly.Hans"),
        POLLY_INES("Polly.Ines"),
        POLLY_IVY("Polly.Ivy"),
        POLLY_JACEK("Polly.Jacek"),
        POLLY_JAN("Polly.Jan"),
        POLLY_JOANNA("Polly.Joanna"),
        POLLY_JOEY("Polly.Joey"),
        POLLY_JUSTIN("Polly.Justin"),
        POLLY_KARL("Polly.Karl"),
        POLLY_KENDRA("Polly.Kendra"),
        POLLY_KIMBERLY("Polly.Kimberly"),
        POLLY_LEA("Polly.Lea"),
        POLLY_LIV("Polly.Liv"),
        POLLY_LOTTE("Polly.Lotte"),
        POLLY_LUCIA("Polly.Lucia"),
        POLLY_LUPE("Polly.Lupe"),
        POLLY_MADS("Polly.Mads"),
        POLLY_MAJA("Polly.Maja"),
        POLLY_MARLENE("Polly.Marlene"),
        POLLY_MATHIEU("Polly.Mathieu"),
        POLLY_MATTHEW("Polly.Matthew"),
        POLLY_MAXIM("Polly.Maxim"),
        POLLY_MIA("Polly.Mia"),
        POLLY_MIGUEL("Polly.Miguel"),
        POLLY_MIZUKI("Polly.Mizuki"),
        POLLY_NAJA("Polly.Naja"),
        POLLY_NICOLE("Polly.Nicole"),
        POLLY_PENELOPE("Polly.Penelope"),
        POLLY_RAVEENA("Polly.Raveena"),
        POLLY_RICARDO("Polly.Ricardo"),
        POLLY_RUBEN("Polly.Ruben"),
        POLLY_RUSSELL("Polly.Russell"),
        POLLY_SALLI("Polly.Salli"),
        POLLY_SEOYEON("Polly.Seoyeon"),
        POLLY_TAKUMI("Polly.Takumi"),
        POLLY_TATYANA("Polly.Tatyana"),
        POLLY_VICKI("Polly.Vicki"),
        POLLY_VITORIA("Polly.Vitoria"),
        POLLY_ZEINA("Polly.Zeina"),
        POLLY_ZHIYU("Polly.Zhiyu"),
        POLLY_ADRIANO_NEURAL("Polly.Adriano-Neural"),
        POLLY_AMY_NEURAL("Polly.Amy-Neural"),
        POLLY_ANDRES_NEURAL("Polly.Andres-Neural"),
        POLLY_ARIA_NEURAL("Polly.Aria-Neural"),
        POLLY_ARLET_NEURAL("Polly.Arlet-Neural"),
        POLLY_ARTHUR_NEURAL("Polly.Arthur-Neural"),
        POLLY_AYANDA_NEURAL("Polly.Ayanda-Neural"),
        POLLY_BIANCA_NEURAL("Polly.Bianca-Neural"),
        POLLY_BRIAN_NEURAL("Polly.Brian-Neural"),
        POLLY_CAMILA_NEURAL("Polly.Camila-Neural"),
        POLLY_DANIEL_NEURAL("Polly.Daniel-Neural"),
        POLLY_DANIELLE_NEURAL("Polly.Danielle-Neural"),
        POLLY_ELIN_NEURAL("Polly.Elin-Neural"),
        POLLY_EMMA_NEURAL("Polly.Emma-Neural"),
        POLLY_GABRIELLE_NEURAL("Polly.Gabrielle-Neural"),
        POLLY_GREGORY_NEURAL("Polly.Gregory-Neural"),
        POLLY_HALA_NEURAL("Polly.Hala-Neural"),
        POLLY_HANNAH_NEURAL("Polly.Hannah-Neural"),
        POLLY_HIUJIN_NEURAL("Polly.Hiujin-Neural"),
        POLLY_IDA_NEURAL("Polly.Ida-Neural"),
        POLLY_INES_NEURAL("Polly.Ines-Neural"),
        POLLY_ISABELLE_NEURAL("Polly.Isabelle-Neural"),
        POLLY_IVY_NEURAL("Polly.Ivy-Neural"),
        POLLY_JOANNA_NEURAL("Polly.Joanna-Neural"),
        POLLY_JOEY_NEURAL("Polly.Joey-Neural"),
        POLLY_JUSTIN_NEURAL("Polly.Justin-Neural"),
        POLLY_KAJAL_NEURAL("Polly.Kajal-Neural"),
        POLLY_KAZUHA_NEURAL("Polly.Kazuha-Neural"),
        POLLY_KENDRA_NEURAL("Polly.Kendra-Neural"),
        POLLY_KEVIN_NEURAL("Polly.Kevin-Neural"),
        POLLY_KIMBERLY_NEURAL("Polly.Kimberly-Neural"),
        POLLY_LAURA_NEURAL("Polly.Laura-Neural"),
        POLLY_LEA_NEURAL("Polly.Lea-Neural"),
        POLLY_LIAM_NEURAL("Polly.Liam-Neural"),
        POLLY_LISA_NEURAL("Polly.Lisa-Neural"),
        POLLY_LUCIA_NEURAL("Polly.Lucia-Neural"),
        POLLY_LUPE_NEURAL("Polly.Lupe-Neural"),
        POLLY_MATTHEW_NEURAL("Polly.Matthew-Neural"),
        POLLY_MIA_NEURAL("Polly.Mia-Neural"),
        POLLY_NIAMH_NEURAL("Polly.Niamh-Neural"),
        POLLY_OLA_NEURAL("Polly.Ola-Neural"),
        POLLY_OLIVIA_NEURAL("Polly.Olivia-Neural"),
        POLLY_PEDRO_NEURAL("Polly.Pedro-Neural"),
        POLLY_REMI_NEURAL("Polly.Remi-Neural"),
        POLLY_RUTH_NEURAL("Polly.Ruth-Neural"),
        POLLY_SALLI_NEURAL("Polly.Salli-Neural"),
        POLLY_SEOYEON_NEURAL("Polly.Seoyeon-Neural"),
        POLLY_SERGIO_NEURAL("Polly.Sergio-Neural"),
        POLLY_SOFIE_NEURAL("Polly.Sofie-Neural"),
        POLLY_STEPHEN_NEURAL("Polly.Stephen-Neural"),
        POLLY_SUVI_NEURAL("Polly.Suvi-Neural"),
        POLLY_TAKUMI_NEURAL("Polly.Takumi-Neural"),
        POLLY_TOMOKO_NEURAL("Polly.Tomoko-Neural"),
        POLLY_THIAGO_NEURAL("Polly.Thiago-Neural"),
        POLLY_VICKI_NEURAL("Polly.Vicki-Neural"),
        POLLY_VITORIA_NEURAL("Polly.Vitoria-Neural"),
        POLLY_ZAYD_NEURAL("Polly.Zayd-Neural"),
        POLLY_ZHIYU_NEURAL("Polly.Zhiyu-Neural");

        private final String value;

        private Voice(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

