/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Room
extends TwiML {
    private final String participantIdentity;
    private final String name;

    private Room() {
        this(new Builder(null));
    }

    private Room(Builder b) {
        super("Room", b);
        this.participantIdentity = b.participantIdentity;
        this.name = b.name;
    }

    @Override
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getParticipantIdentity() != null) {
            attrs.put("participantIdentity", this.getParticipantIdentity());
        }
        return attrs;
    }

    public String getParticipantIdentity() {
        return this.participantIdentity;
    }

    public String getName() {
        return this.name;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String participantIdentity;
        private String name;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Room.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String name) {
            this.name = name;
        }

        private Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="participantIdentity")
        public Builder participantIdentity(String participantIdentity) {
            this.participantIdentity = participantIdentity;
            return this;
        }

        public Room build() {
            return new Room(this);
        }
    }
}

