/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.wireless.v1.Command;
import java.net.URI;

public class CommandCreator
extends Creator<Command> {
    private String command;
    private String sim;
    private HttpMethod callbackMethod;
    private URI callbackUrl;
    private Command.CommandMode commandMode;
    private String includeSid;
    private Boolean deliveryReceiptRequested;

    public CommandCreator(String command) {
        this.command = command;
    }

    public CommandCreator setCommand(String command) {
        this.command = command;
        return this;
    }

    public CommandCreator setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public CommandCreator setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public CommandCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CommandCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public CommandCreator setCommandMode(Command.CommandMode commandMode) {
        this.commandMode = commandMode;
        return this;
    }

    public CommandCreator setIncludeSid(String includeSid) {
        this.includeSid = includeSid;
        return this;
    }

    public CommandCreator setDeliveryReceiptRequested(Boolean deliveryReceiptRequested) {
        this.deliveryReceiptRequested = deliveryReceiptRequested;
        return this;
    }

    @Override
    public Command create(TwilioRestClient client) {
        String path = "/v1/Commands";
        path = path.replace("{Command}", this.command.toString());
        Request request = new Request(HttpMethod.POST, Domains.WIRELESS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Command creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Command.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.command != null) {
            request.addPostParam("Command", this.command);
        }
        if (this.sim != null) {
            request.addPostParam("Sim", this.sim);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.commandMode != null) {
            request.addPostParam("CommandMode", this.commandMode.toString());
        }
        if (this.includeSid != null) {
            request.addPostParam("IncludeSid", this.includeSid);
        }
        if (this.deliveryReceiptRequested != null) {
            request.addPostParam("DeliveryReceiptRequested", this.deliveryReceiptRequested.toString());
        }
    }
}

