/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.connectionpolicy;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTarget;
import java.net.URI;

public class ConnectionPolicyTargetCreator
extends Creator<ConnectionPolicyTarget> {
    private String pathConnectionPolicySid;
    private URI target;
    private String friendlyName;
    private Integer priority;
    private Integer weight;
    private Boolean enabled;

    public ConnectionPolicyTargetCreator(String pathConnectionPolicySid, URI target) {
        this.pathConnectionPolicySid = pathConnectionPolicySid;
        this.target = target;
    }

    public ConnectionPolicyTargetCreator setTarget(URI target) {
        this.target = target;
        return this;
    }

    public ConnectionPolicyTargetCreator setTarget(String target) {
        return this.setTarget(Promoter.uriFromString(target));
    }

    public ConnectionPolicyTargetCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConnectionPolicyTargetCreator setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public ConnectionPolicyTargetCreator setWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public ConnectionPolicyTargetCreator setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public ConnectionPolicyTarget create(TwilioRestClient client) {
        String path = "/v1/ConnectionPolicies/{ConnectionPolicySid}/Targets";
        path = path.replace("{ConnectionPolicySid}", this.pathConnectionPolicySid.toString());
        path = path.replace("{Target}", this.target.toString());
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConnectionPolicyTarget creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ConnectionPolicyTarget.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.target != null) {
            request.addPostParam("Target", this.target.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.weight != null) {
            request.addPostParam("Weight", this.weight.toString());
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
    }
}

