/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.RecordingRules;
import java.util.Map;

public class RecordingRulesUpdater
extends Updater<RecordingRules> {
    private String pathRoomSid;
    private Map<String, Object> rules;

    public RecordingRulesUpdater(String pathRoomSid) {
        this.pathRoomSid = pathRoomSid;
    }

    public RecordingRulesUpdater setRules(Map<String, Object> rules) {
        this.rules = rules;
        return this;
    }

    @Override
    public RecordingRules update(TwilioRestClient client) {
        String path = "/v1/Rooms/{RoomSid}/RecordingRules";
        path = path.replace("{RoomSid}", this.pathRoomSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RecordingRules update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return RecordingRules.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.rules != null) {
            request.addPostParam("Rules", Converter.mapToJson(this.rules));
        }
    }
}

