/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.NewFactor;
import java.util.Map;

public class NewFactorCreator
extends Creator<NewFactor> {
    private String pathServiceSid;
    private String pathIdentity;
    private String friendlyName;
    private NewFactor.FactorTypes factorType;
    private String bindingAlg;
    private String bindingPublicKey;
    private String configAppId;
    private NewFactor.NotificationPlatforms configNotificationPlatform;
    private String configNotificationToken;
    private String configSdkVersion;
    private String bindingSecret;
    private Integer configTimeStep;
    private Integer configSkew;
    private Integer configCodeLength;
    private NewFactor.TotpAlgorithms configAlg;
    private Map<String, Object> metadata;

    public NewFactorCreator(String pathServiceSid, String pathIdentity, String friendlyName, NewFactor.FactorTypes factorType) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.friendlyName = friendlyName;
        this.factorType = factorType;
    }

    public NewFactorCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public NewFactorCreator setFactorType(NewFactor.FactorTypes factorType) {
        this.factorType = factorType;
        return this;
    }

    public NewFactorCreator setBindingAlg(String bindingAlg) {
        this.bindingAlg = bindingAlg;
        return this;
    }

    public NewFactorCreator setBindingPublicKey(String bindingPublicKey) {
        this.bindingPublicKey = bindingPublicKey;
        return this;
    }

    public NewFactorCreator setConfigAppId(String configAppId) {
        this.configAppId = configAppId;
        return this;
    }

    public NewFactorCreator setConfigNotificationPlatform(NewFactor.NotificationPlatforms configNotificationPlatform) {
        this.configNotificationPlatform = configNotificationPlatform;
        return this;
    }

    public NewFactorCreator setConfigNotificationToken(String configNotificationToken) {
        this.configNotificationToken = configNotificationToken;
        return this;
    }

    public NewFactorCreator setConfigSdkVersion(String configSdkVersion) {
        this.configSdkVersion = configSdkVersion;
        return this;
    }

    public NewFactorCreator setBindingSecret(String bindingSecret) {
        this.bindingSecret = bindingSecret;
        return this;
    }

    public NewFactorCreator setConfigTimeStep(Integer configTimeStep) {
        this.configTimeStep = configTimeStep;
        return this;
    }

    public NewFactorCreator setConfigSkew(Integer configSkew) {
        this.configSkew = configSkew;
        return this;
    }

    public NewFactorCreator setConfigCodeLength(Integer configCodeLength) {
        this.configCodeLength = configCodeLength;
        return this;
    }

    public NewFactorCreator setConfigAlg(NewFactor.TotpAlgorithms configAlg) {
        this.configAlg = configAlg;
        return this;
    }

    public NewFactorCreator setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public NewFactor create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Entities/{Identity}/Factors";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{FactorType}", this.factorType.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("NewFactor creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return NewFactor.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.factorType != null) {
            request.addPostParam("FactorType", this.factorType.toString());
        }
        if (this.bindingAlg != null) {
            request.addPostParam("Binding.Alg", this.bindingAlg);
        }
        if (this.bindingPublicKey != null) {
            request.addPostParam("Binding.PublicKey", this.bindingPublicKey);
        }
        if (this.configAppId != null) {
            request.addPostParam("Config.AppId", this.configAppId);
        }
        if (this.configNotificationPlatform != null) {
            request.addPostParam("Config.NotificationPlatform", this.configNotificationPlatform.toString());
        }
        if (this.configNotificationToken != null) {
            request.addPostParam("Config.NotificationToken", this.configNotificationToken);
        }
        if (this.configSdkVersion != null) {
            request.addPostParam("Config.SdkVersion", this.configSdkVersion);
        }
        if (this.bindingSecret != null) {
            request.addPostParam("Binding.Secret", this.bindingSecret);
        }
        if (this.configTimeStep != null) {
            request.addPostParam("Config.TimeStep", this.configTimeStep.toString());
        }
        if (this.configSkew != null) {
            request.addPostParam("Config.Skew", this.configSkew.toString());
        }
        if (this.configCodeLength != null) {
            request.addPostParam("Config.CodeLength", this.configCodeLength.toString());
        }
        if (this.configAlg != null) {
            request.addPostParam("Config.Alg", this.configAlg.toString());
        }
        if (this.metadata != null) {
            request.addPostParam("Metadata", Converter.mapToJson(this.metadata));
        }
    }
}

