/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.Webhook;
import java.util.List;

public class WebhookCreator
extends Creator<Webhook> {
    private String pathServiceSid;
    private String friendlyName;
    private List<String> eventTypes;
    private String webhookUrl;
    private Webhook.Status status;
    private Webhook.Version version;

    public WebhookCreator(String pathServiceSid, String friendlyName, List<String> eventTypes, String webhookUrl) {
        this.pathServiceSid = pathServiceSid;
        this.friendlyName = friendlyName;
        this.eventTypes = eventTypes;
        this.webhookUrl = webhookUrl;
    }

    public WebhookCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WebhookCreator setEventTypes(List<String> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public WebhookCreator setEventTypes(String eventTypes) {
        return this.setEventTypes(Promoter.listOfOne(eventTypes));
    }

    public WebhookCreator setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public WebhookCreator setStatus(Webhook.Status status) {
        this.status = status;
        return this;
    }

    public WebhookCreator setVersion(Webhook.Version version) {
        this.version = version;
        return this;
    }

    @Override
    public Webhook create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Webhooks";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{EventTypes}", this.eventTypes.toString());
        path = path.replace("{WebhookUrl}", this.webhookUrl.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.eventTypes != null) {
            for (String prop : this.eventTypes) {
                request.addPostParam("EventTypes", prop);
            }
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl);
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.version != null) {
            request.addPostParam("Version", this.version.toString());
        }
    }
}

