/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.VerificationCreator;
import com.twilio.rest.verify.v2.service.VerificationFetcher;
import com.twilio.rest.verify.v2.service.VerificationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Verification
extends Resource {
    private static final long serialVersionUID = 3815558292528L;
    private final String sid;
    private final String serviceSid;
    private final String accountSid;
    private final String to;
    private final Channel channel;
    private final String status;
    private final Boolean valid;
    private final Map<String, Object> lookup;
    private final String amount;
    private final String payee;
    private final List<Map<String, Object>> sendCodeAttempts;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Map<String, Object> sna;
    private final URI url;

    public static VerificationCreator creator(String pathServiceSid, String to, String channel) {
        return new VerificationCreator(pathServiceSid, to, channel);
    }

    public static VerificationFetcher fetcher(String pathServiceSid, String pathSid) {
        return new VerificationFetcher(pathServiceSid, pathSid);
    }

    public static VerificationUpdater updater(String pathServiceSid, String pathSid, Status status) {
        return new VerificationUpdater(pathServiceSid, pathSid, status);
    }

    public static Verification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Verification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Verification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Verification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Verification(@JsonProperty(value="sid") String sid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="to") String to, @JsonProperty(value="channel") Channel channel, @JsonProperty(value="status") String status, @JsonProperty(value="valid") Boolean valid, @JsonProperty(value="lookup") Map<String, Object> lookup, @JsonProperty(value="amount") String amount, @JsonProperty(value="payee") String payee, @JsonProperty(value="send_code_attempts") List<Map<String, Object>> sendCodeAttempts, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sna") Map<String, Object> sna, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.to = to;
        this.channel = channel;
        this.status = status;
        this.valid = valid;
        this.lookup = lookup;
        this.amount = amount;
        this.payee = payee;
        this.sendCodeAttempts = sendCodeAttempts;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.sna = sna;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getTo() {
        return this.to;
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final String getStatus() {
        return this.status;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final Map<String, Object> getLookup() {
        return this.lookup;
    }

    public final String getAmount() {
        return this.amount;
    }

    public final String getPayee() {
        return this.payee;
    }

    public final List<Map<String, Object>> getSendCodeAttempts() {
        return this.sendCodeAttempts;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, Object> getSna() {
        return this.sna;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Verification other = (Verification)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.to, other.to) && Objects.equals((Object)this.channel, (Object)other.channel) && Objects.equals(this.status, other.status) && Objects.equals(this.valid, other.valid) && Objects.equals(this.lookup, other.lookup) && Objects.equals(this.amount, other.amount) && Objects.equals(this.payee, other.payee) && Objects.equals(this.sendCodeAttempts, other.sendCodeAttempts) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sna, other.sna) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.serviceSid, this.accountSid, this.to, this.channel, this.status, this.valid, this.lookup, this.amount, this.payee, this.sendCodeAttempts, this.dateCreated, this.dateUpdated, this.sna, this.url});
    }

    public String toString() {
        return "Verification(sid=" + this.getSid() + ", serviceSid=" + this.getServiceSid() + ", accountSid=" + this.getAccountSid() + ", to=" + this.getTo() + ", channel=" + (Object)((Object)this.getChannel()) + ", status=" + this.getStatus() + ", valid=" + this.getValid() + ", lookup=" + this.getLookup() + ", amount=" + this.getAmount() + ", payee=" + this.getPayee() + ", sendCodeAttempts=" + this.getSendCodeAttempts() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", sna=" + this.getSna() + ", url=" + this.getUrl() + ")";
    }

    public static enum Channel {
        SMS("sms"),
        CALL("call"),
        EMAIL("email"),
        WHATSAPP("whatsapp"),
        SNA("sna");

        private final String value;

        private Channel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Channel forValue(String value) {
            return (Channel)Promoter.enumFromString((String)value, (Enum[])Channel.values());
        }
    }

    public static enum Status {
        CANCELED("canceled"),
        APPROVED("approved");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum RiskCheck {
        ENABLE("enable"),
        DISABLE("disable");

        private final String value;

        private RiskCheck(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RiskCheck forValue(String value) {
            return (RiskCheck)Promoter.enumFromString((String)value, (Enum[])RiskCheck.values());
        }
    }
}

