/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.RateLimit;

public class RateLimitReader
extends Reader<RateLimit> {
    private String pathServiceSid;
    private Integer pageSize;

    public RateLimitReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public RateLimitReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<RateLimit> read(TwilioRestClient client) {
        return new ResourceSet<RateLimit>(this, client, this.firstPage(client));
    }

    @Override
    public Page<RateLimit> firstPage(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/RateLimits";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<RateLimit> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RateLimit read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("rate_limits", response.getContent(), RateLimit.class, client.getObjectMapper());
    }

    @Override
    public Page<RateLimit> previousPage(Page<RateLimit> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RateLimit> nextPage(Page<RateLimit> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RateLimit> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

