/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.Service;

public class ServiceUpdater
extends Updater<Service> {
    private String pathSid;
    private String friendlyName;
    private Integer codeLength;
    private Boolean lookupEnabled;
    private Boolean skipSmsToLandlines;
    private Boolean dtmfInputRequired;
    private String ttsName;
    private Boolean psd2Enabled;
    private Boolean doNotShareWarningEnabled;
    private Boolean customCodeEnabled;
    private Boolean pushIncludeDate;
    private String pushApnCredentialSid;
    private String pushFcmCredentialSid;
    private String totpIssuer;
    private Integer totpTimeStep;
    private Integer totpCodeLength;
    private Integer totpSkew;
    private String defaultTemplateSid;
    private Boolean verifyEventSubscriptionEnabled;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setCodeLength(Integer codeLength) {
        this.codeLength = codeLength;
        return this;
    }

    public ServiceUpdater setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
        return this;
    }

    public ServiceUpdater setSkipSmsToLandlines(Boolean skipSmsToLandlines) {
        this.skipSmsToLandlines = skipSmsToLandlines;
        return this;
    }

    public ServiceUpdater setDtmfInputRequired(Boolean dtmfInputRequired) {
        this.dtmfInputRequired = dtmfInputRequired;
        return this;
    }

    public ServiceUpdater setTtsName(String ttsName) {
        this.ttsName = ttsName;
        return this;
    }

    public ServiceUpdater setPsd2Enabled(Boolean psd2Enabled) {
        this.psd2Enabled = psd2Enabled;
        return this;
    }

    public ServiceUpdater setDoNotShareWarningEnabled(Boolean doNotShareWarningEnabled) {
        this.doNotShareWarningEnabled = doNotShareWarningEnabled;
        return this;
    }

    public ServiceUpdater setCustomCodeEnabled(Boolean customCodeEnabled) {
        this.customCodeEnabled = customCodeEnabled;
        return this;
    }

    public ServiceUpdater setPushIncludeDate(Boolean pushIncludeDate) {
        this.pushIncludeDate = pushIncludeDate;
        return this;
    }

    public ServiceUpdater setPushApnCredentialSid(String pushApnCredentialSid) {
        this.pushApnCredentialSid = pushApnCredentialSid;
        return this;
    }

    public ServiceUpdater setPushFcmCredentialSid(String pushFcmCredentialSid) {
        this.pushFcmCredentialSid = pushFcmCredentialSid;
        return this;
    }

    public ServiceUpdater setTotpIssuer(String totpIssuer) {
        this.totpIssuer = totpIssuer;
        return this;
    }

    public ServiceUpdater setTotpTimeStep(Integer totpTimeStep) {
        this.totpTimeStep = totpTimeStep;
        return this;
    }

    public ServiceUpdater setTotpCodeLength(Integer totpCodeLength) {
        this.totpCodeLength = totpCodeLength;
        return this;
    }

    public ServiceUpdater setTotpSkew(Integer totpSkew) {
        this.totpSkew = totpSkew;
        return this;
    }

    public ServiceUpdater setDefaultTemplateSid(String defaultTemplateSid) {
        this.defaultTemplateSid = defaultTemplateSid;
        return this;
    }

    public ServiceUpdater setVerifyEventSubscriptionEnabled(Boolean verifyEventSubscriptionEnabled) {
        this.verifyEventSubscriptionEnabled = verifyEventSubscriptionEnabled;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        String path = "/v2/Services/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.codeLength != null) {
            request.addPostParam("CodeLength", this.codeLength.toString());
        }
        if (this.lookupEnabled != null) {
            request.addPostParam("LookupEnabled", this.lookupEnabled.toString());
        }
        if (this.skipSmsToLandlines != null) {
            request.addPostParam("SkipSmsToLandlines", this.skipSmsToLandlines.toString());
        }
        if (this.dtmfInputRequired != null) {
            request.addPostParam("DtmfInputRequired", this.dtmfInputRequired.toString());
        }
        if (this.ttsName != null) {
            request.addPostParam("TtsName", this.ttsName);
        }
        if (this.psd2Enabled != null) {
            request.addPostParam("Psd2Enabled", this.psd2Enabled.toString());
        }
        if (this.doNotShareWarningEnabled != null) {
            request.addPostParam("DoNotShareWarningEnabled", this.doNotShareWarningEnabled.toString());
        }
        if (this.customCodeEnabled != null) {
            request.addPostParam("CustomCodeEnabled", this.customCodeEnabled.toString());
        }
        if (this.pushIncludeDate != null) {
            request.addPostParam("Push.IncludeDate", this.pushIncludeDate.toString());
        }
        if (this.pushApnCredentialSid != null) {
            request.addPostParam("Push.ApnCredentialSid", this.pushApnCredentialSid);
        }
        if (this.pushFcmCredentialSid != null) {
            request.addPostParam("Push.FcmCredentialSid", this.pushFcmCredentialSid);
        }
        if (this.totpIssuer != null) {
            request.addPostParam("Totp.Issuer", this.totpIssuer);
        }
        if (this.totpTimeStep != null) {
            request.addPostParam("Totp.TimeStep", this.totpTimeStep.toString());
        }
        if (this.totpCodeLength != null) {
            request.addPostParam("Totp.CodeLength", this.totpCodeLength.toString());
        }
        if (this.totpSkew != null) {
            request.addPostParam("Totp.Skew", this.totpSkew.toString());
        }
        if (this.defaultTemplateSid != null) {
            request.addPostParam("DefaultTemplateSid", this.defaultTemplateSid);
        }
        if (this.verifyEventSubscriptionEnabled != null) {
            request.addPostParam("VerifyEventSubscriptionEnabled", this.verifyEventSubscriptionEnabled.toString());
        }
    }
}

