/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsEntityAssignments;

public class TrustProductsEntityAssignmentsCreator
extends Creator<TrustProductsEntityAssignments> {
    private String pathTrustProductSid;
    private String objectSid;

    public TrustProductsEntityAssignmentsCreator(String pathTrustProductSid, String objectSid) {
        this.pathTrustProductSid = pathTrustProductSid;
        this.objectSid = objectSid;
    }

    public TrustProductsEntityAssignmentsCreator setObjectSid(String objectSid) {
        this.objectSid = objectSid;
        return this;
    }

    @Override
    public TrustProductsEntityAssignments create(TwilioRestClient client) {
        String path = "/v1/TrustProducts/{TrustProductSid}/EntityAssignments";
        path = path.replace("{TrustProductSid}", this.pathTrustProductSid.toString());
        path = path.replace("{ObjectSid}", this.objectSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TrustProductsEntityAssignments creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TrustProductsEntityAssignments.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.objectSid != null) {
            request.addPostParam("ObjectSid", this.objectSid);
        }
    }
}

