/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsChannelEndpointAssignmentCreator;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsChannelEndpointAssignmentDeleter;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsChannelEndpointAssignmentFetcher;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsChannelEndpointAssignmentReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrustProductsChannelEndpointAssignment
extends Resource {
    private static final long serialVersionUID = 19553243454529L;
    private final String sid;
    private final String trustProductSid;
    private final String accountSid;
    private final String channelEndpointType;
    private final String channelEndpointSid;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static TrustProductsChannelEndpointAssignmentCreator creator(String pathTrustProductSid, String channelEndpointType, String channelEndpointSid) {
        return new TrustProductsChannelEndpointAssignmentCreator(pathTrustProductSid, channelEndpointType, channelEndpointSid);
    }

    public static TrustProductsChannelEndpointAssignmentDeleter deleter(String pathTrustProductSid, String pathSid) {
        return new TrustProductsChannelEndpointAssignmentDeleter(pathTrustProductSid, pathSid);
    }

    public static TrustProductsChannelEndpointAssignmentFetcher fetcher(String pathTrustProductSid, String pathSid) {
        return new TrustProductsChannelEndpointAssignmentFetcher(pathTrustProductSid, pathSid);
    }

    public static TrustProductsChannelEndpointAssignmentReader reader(String pathTrustProductSid) {
        return new TrustProductsChannelEndpointAssignmentReader(pathTrustProductSid);
    }

    public static TrustProductsChannelEndpointAssignment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProductsChannelEndpointAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TrustProductsChannelEndpointAssignment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TrustProductsChannelEndpointAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TrustProductsChannelEndpointAssignment(@JsonProperty(value="sid") String sid, @JsonProperty(value="trust_product_sid") String trustProductSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="channel_endpoint_type") String channelEndpointType, @JsonProperty(value="channel_endpoint_sid") String channelEndpointSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.trustProductSid = trustProductSid;
        this.accountSid = accountSid;
        this.channelEndpointType = channelEndpointType;
        this.channelEndpointSid = channelEndpointSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTrustProductSid() {
        return this.trustProductSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChannelEndpointType() {
        return this.channelEndpointType;
    }

    public final String getChannelEndpointSid() {
        return this.channelEndpointSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustProductsChannelEndpointAssignment other = (TrustProductsChannelEndpointAssignment)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.trustProductSid, other.trustProductSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.channelEndpointType, other.channelEndpointType) && Objects.equals(this.channelEndpointSid, other.channelEndpointSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.trustProductSid, this.accountSid, this.channelEndpointType, this.channelEndpointSid, this.dateCreated, this.url);
    }

    public String toString() {
        return "TrustProductsChannelEndpointAssignment(sid=" + this.getSid() + ", trustProductSid=" + this.getTrustProductSid() + ", accountSid=" + this.getAccountSid() + ", channelEndpointType=" + this.getChannelEndpointType() + ", channelEndpointSid=" + this.getChannelEndpointSid() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

