/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesEntityAssignments;

public class CustomerProfilesEntityAssignmentsReader
extends Reader<CustomerProfilesEntityAssignments> {
    private String pathCustomerProfileSid;
    private String objectType;
    private Integer pageSize;

    public CustomerProfilesEntityAssignmentsReader(String pathCustomerProfileSid) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
    }

    public CustomerProfilesEntityAssignmentsReader setObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public CustomerProfilesEntityAssignmentsReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<CustomerProfilesEntityAssignments> read(TwilioRestClient client) {
        return new ResourceSet<CustomerProfilesEntityAssignments>(this, client, this.firstPage(client));
    }

    @Override
    public Page<CustomerProfilesEntityAssignments> firstPage(TwilioRestClient client) {
        String path = "/v1/CustomerProfiles/{CustomerProfileSid}/EntityAssignments";
        path = path.replace("{CustomerProfileSid}", this.pathCustomerProfileSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUSTHUB.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<CustomerProfilesEntityAssignments> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CustomerProfilesEntityAssignments read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), CustomerProfilesEntityAssignments.class, client.getObjectMapper());
    }

    @Override
    public Page<CustomerProfilesEntityAssignments> previousPage(Page<CustomerProfilesEntityAssignments> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesEntityAssignments> nextPage(Page<CustomerProfilesEntityAssignments> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesEntityAssignments> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.objectType != null) {
            request.addQueryParam("ObjectType", this.objectType);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

