/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.customerprofiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesChannelEndpointAssignmentCreator;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesChannelEndpointAssignmentDeleter;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesChannelEndpointAssignmentFetcher;
import com.twilio.rest.trusthub.v1.customerprofiles.CustomerProfilesChannelEndpointAssignmentReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomerProfilesChannelEndpointAssignment
extends Resource {
    private static final long serialVersionUID = 18267773562551L;
    private final String sid;
    private final String customerProfileSid;
    private final String accountSid;
    private final String channelEndpointType;
    private final String channelEndpointSid;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static CustomerProfilesChannelEndpointAssignmentCreator creator(String pathCustomerProfileSid, String channelEndpointType, String channelEndpointSid) {
        return new CustomerProfilesChannelEndpointAssignmentCreator(pathCustomerProfileSid, channelEndpointType, channelEndpointSid);
    }

    public static CustomerProfilesChannelEndpointAssignmentDeleter deleter(String pathCustomerProfileSid, String pathSid) {
        return new CustomerProfilesChannelEndpointAssignmentDeleter(pathCustomerProfileSid, pathSid);
    }

    public static CustomerProfilesChannelEndpointAssignmentFetcher fetcher(String pathCustomerProfileSid, String pathSid) {
        return new CustomerProfilesChannelEndpointAssignmentFetcher(pathCustomerProfileSid, pathSid);
    }

    public static CustomerProfilesChannelEndpointAssignmentReader reader(String pathCustomerProfileSid) {
        return new CustomerProfilesChannelEndpointAssignmentReader(pathCustomerProfileSid);
    }

    public static CustomerProfilesChannelEndpointAssignment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomerProfilesChannelEndpointAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CustomerProfilesChannelEndpointAssignment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomerProfilesChannelEndpointAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CustomerProfilesChannelEndpointAssignment(@JsonProperty(value="sid") String sid, @JsonProperty(value="customer_profile_sid") String customerProfileSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="channel_endpoint_type") String channelEndpointType, @JsonProperty(value="channel_endpoint_sid") String channelEndpointSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.customerProfileSid = customerProfileSid;
        this.accountSid = accountSid;
        this.channelEndpointType = channelEndpointType;
        this.channelEndpointSid = channelEndpointSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getCustomerProfileSid() {
        return this.customerProfileSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChannelEndpointType() {
        return this.channelEndpointType;
    }

    public final String getChannelEndpointSid() {
        return this.channelEndpointSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerProfilesChannelEndpointAssignment other = (CustomerProfilesChannelEndpointAssignment)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.customerProfileSid, other.customerProfileSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.channelEndpointType, other.channelEndpointType) && Objects.equals(this.channelEndpointSid, other.channelEndpointSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.customerProfileSid, this.accountSid, this.channelEndpointType, this.channelEndpointSid, this.dateCreated, this.url);
    }

    public String toString() {
        return "CustomerProfilesChannelEndpointAssignment(sid=" + this.getSid() + ", customerProfileSid=" + this.getCustomerProfileSid() + ", accountSid=" + this.getAccountSid() + ", channelEndpointType=" + this.getChannelEndpointType() + ", channelEndpointSid=" + this.getChannelEndpointSid() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

