/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.PoliciesFetcher;
import com.twilio.rest.trusthub.v1.PoliciesReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Policies
extends Resource {
    private static final long serialVersionUID = 142613922631852L;
    private final String sid;
    private final String friendlyName;
    private final Map<String, Object> requirements;
    private final URI url;

    public static PoliciesFetcher fetcher(String pathSid) {
        return new PoliciesFetcher(pathSid);
    }

    public static PoliciesReader reader() {
        return new PoliciesReader();
    }

    public static Policies fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Policies.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Policies fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Policies.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Policies(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="requirements") Map<String, Object> requirements, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.requirements = requirements;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, Object> getRequirements() {
        return this.requirements;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policies other = (Policies)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.requirements, other.requirements) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.friendlyName, this.requirements, this.url);
    }

    public String toString() {
        return "Policies(sid=" + this.getSid() + ", friendlyName=" + this.getFriendlyName() + ", requirements=" + this.getRequirements() + ", url=" + this.getUrl() + ")";
    }
}

