/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trusthub.v1.ComplianceRegistrationInquiriesCreator;
import com.twilio.rest.trusthub.v1.ComplianceRegistrationInquiriesUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComplianceRegistrationInquiries
extends Resource {
    private static final long serialVersionUID = 153862952025802L;
    private final String inquiryId;
    private final String inquirySessionToken;
    private final String registrationId;
    private final URI url;

    public static ComplianceRegistrationInquiriesCreator creator(EndUserType endUserType, PhoneNumberType phoneNumberType) {
        return new ComplianceRegistrationInquiriesCreator(endUserType, phoneNumberType);
    }

    public static ComplianceRegistrationInquiriesUpdater updater(String pathRegistrationId) {
        return new ComplianceRegistrationInquiriesUpdater(pathRegistrationId);
    }

    public static ComplianceRegistrationInquiries fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ComplianceRegistrationInquiries.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ComplianceRegistrationInquiries fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ComplianceRegistrationInquiries.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ComplianceRegistrationInquiries(@JsonProperty(value="inquiry_id") String inquiryId, @JsonProperty(value="inquiry_session_token") String inquirySessionToken, @JsonProperty(value="registration_id") String registrationId, @JsonProperty(value="url") URI url) {
        this.inquiryId = inquiryId;
        this.inquirySessionToken = inquirySessionToken;
        this.registrationId = registrationId;
        this.url = url;
    }

    public final String getInquiryId() {
        return this.inquiryId;
    }

    public final String getInquirySessionToken() {
        return this.inquirySessionToken;
    }

    public final String getRegistrationId() {
        return this.registrationId;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplianceRegistrationInquiries other = (ComplianceRegistrationInquiries)o;
        return Objects.equals(this.inquiryId, other.inquiryId) && Objects.equals(this.inquirySessionToken, other.inquirySessionToken) && Objects.equals(this.registrationId, other.registrationId) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.inquiryId, this.inquirySessionToken, this.registrationId, this.url);
    }

    public String toString() {
        return "ComplianceRegistrationInquiries(inquiryId=" + this.getInquiryId() + ", inquirySessionToken=" + this.getInquirySessionToken() + ", registrationId=" + this.getRegistrationId() + ", url=" + this.getUrl() + ")";
    }

    public static enum PhoneNumberType {
        LOCAL("local"),
        NATIONAL("national"),
        MOBILE("mobile"),
        TOLL_FREE("toll-free");

        private final String value;

        private PhoneNumberType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static PhoneNumberType forValue(String value) {
            return (PhoneNumberType)Promoter.enumFromString((String)value, (Enum[])PhoneNumberType.values());
        }
    }

    public static enum EndUserType {
        INDIVIDUAL("Individual"),
        BUSINESS("Business");

        private final String value;

        private EndUserType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EndUserType forValue(String value) {
            return (EndUserType)Promoter.enumFromString((String)value, (Enum[])EndUserType.values());
        }
    }

    public static enum BusinessRegistrationAuthority {
        UK_CRN("UK:CRN"),
        US_EIN("US:EIN"),
        CA_CBN("CA:CBN"),
        AU_ACN("AU:ACN"),
        OTHER("Other");

        private final String value;

        private BusinessRegistrationAuthority(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BusinessRegistrationAuthority forValue(String value) {
            return (BusinessRegistrationAuthority)Promoter.enumFromString((String)value, (Enum[])BusinessRegistrationAuthority.values());
        }
    }

    public static enum BusinessIdentityType {
        DIRECT_CUSTOMER("direct_customer"),
        ISV_RESELLER_OR_PARTNER("isv_reseller_or_partner"),
        UNKNOWN("unknown");

        private final String value;

        private BusinessIdentityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BusinessIdentityType forValue(String value) {
            return (BusinessIdentityType)Promoter.enumFromString((String)value, (Enum[])BusinessIdentityType.values());
        }
    }
}

