/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.ComplianceInquiries;

public class ComplianceInquiriesUpdater
extends Updater<ComplianceInquiries> {
    private String pathCustomerId;
    private String primaryProfileSid;

    public ComplianceInquiriesUpdater(String pathCustomerId, String primaryProfileSid) {
        this.pathCustomerId = pathCustomerId;
        this.primaryProfileSid = primaryProfileSid;
    }

    public ComplianceInquiriesUpdater setPrimaryProfileSid(String primaryProfileSid) {
        this.primaryProfileSid = primaryProfileSid;
        return this;
    }

    @Override
    public ComplianceInquiries update(TwilioRestClient client) {
        String path = "/v1/ComplianceInquiries/Customers/{CustomerId}/Initialize";
        path = path.replace("{CustomerId}", this.pathCustomerId.toString());
        path = path.replace("{PrimaryProfileSid}", this.primaryProfileSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ComplianceInquiries update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ComplianceInquiries.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.primaryProfileSid != null) {
            request.addPostParam("PrimaryProfileSid", this.primaryProfileSid);
        }
    }
}

