/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.CredentialList;

public class CredentialListCreator
extends Creator<CredentialList> {
    private String pathTrunkSid;
    private String credentialListSid;

    public CredentialListCreator(String pathTrunkSid, String credentialListSid) {
        this.pathTrunkSid = pathTrunkSid;
        this.credentialListSid = credentialListSid;
    }

    public CredentialListCreator setCredentialListSid(String credentialListSid) {
        this.credentialListSid = credentialListSid;
        return this;
    }

    @Override
    public CredentialList create(TwilioRestClient client) {
        String path = "/v1/Trunks/{TrunkSid}/CredentialLists";
        path = path.replace("{TrunkSid}", this.pathTrunkSid.toString());
        path = path.replace("{CredentialListSid}", this.credentialListSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUNKING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialList creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CredentialList.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.credentialListSid != null) {
            request.addPostParam("CredentialListSid", this.credentialListSid);
        }
    }
}

