/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.WorkerCreator;
import com.twilio.rest.taskrouter.v1.workspace.WorkerDeleter;
import com.twilio.rest.taskrouter.v1.workspace.WorkerFetcher;
import com.twilio.rest.taskrouter.v1.workspace.WorkerReader;
import com.twilio.rest.taskrouter.v1.workspace.WorkerUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Worker
extends Resource {
    private static final long serialVersionUID = 110824061154379L;
    private final String accountSid;
    private final String activityName;
    private final String activitySid;
    private final String attributes;
    private final Boolean available;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateStatusChanged;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;

    public static WorkerCreator creator(String pathWorkspaceSid, String friendlyName) {
        return new WorkerCreator(pathWorkspaceSid, friendlyName);
    }

    public static WorkerDeleter deleter(String pathWorkspaceSid, String pathSid) {
        return new WorkerDeleter(pathWorkspaceSid, pathSid);
    }

    public static WorkerFetcher fetcher(String pathWorkspaceSid, String pathSid) {
        return new WorkerFetcher(pathWorkspaceSid, pathSid);
    }

    public static WorkerReader reader(String pathWorkspaceSid) {
        return new WorkerReader(pathWorkspaceSid);
    }

    public static WorkerUpdater updater(String pathWorkspaceSid, String pathSid) {
        return new WorkerUpdater(pathWorkspaceSid, pathSid);
    }

    public static Worker fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Worker.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Worker fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Worker.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Worker(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="activity_name") String activityName, @JsonProperty(value="activity_sid") String activitySid, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="available") Boolean available, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_status_changed") String dateStatusChanged, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.activityName = activityName;
        this.activitySid = activitySid;
        this.attributes = attributes;
        this.available = available;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateStatusChanged = DateConverter.iso8601DateTimeFromString(dateStatusChanged);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getActivityName() {
        return this.activityName;
    }

    public final String getActivitySid() {
        return this.activitySid;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final Boolean getAvailable() {
        return this.available;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateStatusChanged() {
        return this.dateStatusChanged;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Worker other = (Worker)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.activityName, other.activityName) && Objects.equals(this.activitySid, other.activitySid) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.available, other.available) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateStatusChanged, other.dateStatusChanged) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.activityName, this.activitySid, this.attributes, this.available, this.dateCreated, this.dateStatusChanged, this.dateUpdated, this.friendlyName, this.sid, this.workspaceSid, this.url, this.links);
    }

    public String toString() {
        return "Worker(accountSid=" + this.getAccountSid() + ", activityName=" + this.getActivityName() + ", activitySid=" + this.getActivitySid() + ", attributes=" + this.getAttributes() + ", available=" + this.getAvailable() + ", dateCreated=" + this.getDateCreated() + ", dateStatusChanged=" + this.getDateStatusChanged() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", sid=" + this.getSid() + ", workspaceSid=" + this.getWorkspaceSid() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

