/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueue;

public class TaskQueueUpdater
extends Updater<TaskQueue> {
    private String pathWorkspaceSid;
    private String pathSid;
    private String friendlyName;
    private String targetWorkers;
    private String reservationActivitySid;
    private String assignmentActivitySid;
    private Integer maxReservedWorkers;
    private TaskQueue.TaskOrder taskOrder;

    public TaskQueueUpdater(String pathWorkspaceSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathSid = pathSid;
    }

    public TaskQueueUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskQueueUpdater setTargetWorkers(String targetWorkers) {
        this.targetWorkers = targetWorkers;
        return this;
    }

    public TaskQueueUpdater setReservationActivitySid(String reservationActivitySid) {
        this.reservationActivitySid = reservationActivitySid;
        return this;
    }

    public TaskQueueUpdater setAssignmentActivitySid(String assignmentActivitySid) {
        this.assignmentActivitySid = assignmentActivitySid;
        return this;
    }

    public TaskQueueUpdater setMaxReservedWorkers(Integer maxReservedWorkers) {
        this.maxReservedWorkers = maxReservedWorkers;
        return this;
    }

    public TaskQueueUpdater setTaskOrder(TaskQueue.TaskOrder taskOrder) {
        this.taskOrder = taskOrder;
        return this;
    }

    @Override
    public TaskQueue update(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/TaskQueues/{Sid}";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueue update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TaskQueue.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.targetWorkers != null) {
            request.addPostParam("TargetWorkers", this.targetWorkers);
        }
        if (this.reservationActivitySid != null) {
            request.addPostParam("ReservationActivitySid", this.reservationActivitySid);
        }
        if (this.assignmentActivitySid != null) {
            request.addPostParam("AssignmentActivitySid", this.assignmentActivitySid);
        }
        if (this.maxReservedWorkers != null) {
            request.addPostParam("MaxReservedWorkers", this.maxReservedWorkers.toString());
        }
        if (this.taskOrder != null) {
            request.addPostParam("TaskOrder", this.taskOrder.toString());
        }
    }
}

