/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueue;

public class TaskQueueReader
extends Reader<TaskQueue> {
    private String pathWorkspaceSid;
    private String friendlyName;
    private String evaluateWorkerAttributes;
    private String workerSid;
    private String ordering;
    private Integer pageSize;

    public TaskQueueReader(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public TaskQueueReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskQueueReader setEvaluateWorkerAttributes(String evaluateWorkerAttributes) {
        this.evaluateWorkerAttributes = evaluateWorkerAttributes;
        return this;
    }

    public TaskQueueReader setWorkerSid(String workerSid) {
        this.workerSid = workerSid;
        return this;
    }

    public TaskQueueReader setOrdering(String ordering) {
        this.ordering = ordering;
        return this;
    }

    public TaskQueueReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<TaskQueue> read(TwilioRestClient client) {
        return new ResourceSet<TaskQueue>(this, client, this.firstPage(client));
    }

    @Override
    public Page<TaskQueue> firstPage(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/TaskQueues";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<TaskQueue> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueue read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("task_queues", response.getContent(), TaskQueue.class, client.getObjectMapper());
    }

    @Override
    public Page<TaskQueue> previousPage(Page<TaskQueue> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskQueue> nextPage(Page<TaskQueue> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TaskQueue> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.evaluateWorkerAttributes != null) {
            request.addQueryParam("EvaluateWorkerAttributes", this.evaluateWorkerAttributes);
        }
        if (this.workerSid != null) {
            request.addQueryParam("WorkerSid", this.workerSid);
        }
        if (this.ordering != null) {
            request.addQueryParam("Ordering", this.ordering);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

