/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.Workspace;
import java.net.URI;

public class WorkspaceUpdater
extends Updater<Workspace> {
    private String pathSid;
    private String defaultActivitySid;
    private URI eventCallbackUrl;
    private String eventsFilter;
    private String friendlyName;
    private Boolean multiTaskEnabled;
    private String timeoutActivitySid;
    private Workspace.QueueOrder prioritizeQueueOrder;

    public WorkspaceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public WorkspaceUpdater setDefaultActivitySid(String defaultActivitySid) {
        this.defaultActivitySid = defaultActivitySid;
        return this;
    }

    public WorkspaceUpdater setEventCallbackUrl(URI eventCallbackUrl) {
        this.eventCallbackUrl = eventCallbackUrl;
        return this;
    }

    public WorkspaceUpdater setEventCallbackUrl(String eventCallbackUrl) {
        return this.setEventCallbackUrl(Promoter.uriFromString(eventCallbackUrl));
    }

    public WorkspaceUpdater setEventsFilter(String eventsFilter) {
        this.eventsFilter = eventsFilter;
        return this;
    }

    public WorkspaceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkspaceUpdater setMultiTaskEnabled(Boolean multiTaskEnabled) {
        this.multiTaskEnabled = multiTaskEnabled;
        return this;
    }

    public WorkspaceUpdater setTimeoutActivitySid(String timeoutActivitySid) {
        this.timeoutActivitySid = timeoutActivitySid;
        return this;
    }

    public WorkspaceUpdater setPrioritizeQueueOrder(Workspace.QueueOrder prioritizeQueueOrder) {
        this.prioritizeQueueOrder = prioritizeQueueOrder;
        return this;
    }

    @Override
    public Workspace update(TwilioRestClient client) {
        String path = "/v1/Workspaces/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workspace update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Workspace.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.defaultActivitySid != null) {
            request.addPostParam("DefaultActivitySid", this.defaultActivitySid);
        }
        if (this.eventCallbackUrl != null) {
            request.addPostParam("EventCallbackUrl", this.eventCallbackUrl.toString());
        }
        if (this.eventsFilter != null) {
            request.addPostParam("EventsFilter", this.eventsFilter);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.multiTaskEnabled != null) {
            request.addPostParam("MultiTaskEnabled", this.multiTaskEnabled.toString());
        }
        if (this.timeoutActivitySid != null) {
            request.addPostParam("TimeoutActivitySid", this.timeoutActivitySid);
        }
        if (this.prioritizeQueueOrder != null) {
            request.addPostParam("PrioritizeQueueOrder", this.prioritizeQueueOrder.toString());
        }
    }
}

