/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.Workspace;
import java.net.URI;

public class WorkspaceCreator
extends Creator<Workspace> {
    private String friendlyName;
    private URI eventCallbackUrl;
    private String eventsFilter;
    private Boolean multiTaskEnabled;
    private String template;
    private Workspace.QueueOrder prioritizeQueueOrder;

    public WorkspaceCreator(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public WorkspaceCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkspaceCreator setEventCallbackUrl(URI eventCallbackUrl) {
        this.eventCallbackUrl = eventCallbackUrl;
        return this;
    }

    public WorkspaceCreator setEventCallbackUrl(String eventCallbackUrl) {
        return this.setEventCallbackUrl(Promoter.uriFromString(eventCallbackUrl));
    }

    public WorkspaceCreator setEventsFilter(String eventsFilter) {
        this.eventsFilter = eventsFilter;
        return this;
    }

    public WorkspaceCreator setMultiTaskEnabled(Boolean multiTaskEnabled) {
        this.multiTaskEnabled = multiTaskEnabled;
        return this;
    }

    public WorkspaceCreator setTemplate(String template) {
        this.template = template;
        return this;
    }

    public WorkspaceCreator setPrioritizeQueueOrder(Workspace.QueueOrder prioritizeQueueOrder) {
        this.prioritizeQueueOrder = prioritizeQueueOrder;
        return this;
    }

    @Override
    public Workspace create(TwilioRestClient client) {
        String path = "/v1/Workspaces";
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workspace creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Workspace.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.eventCallbackUrl != null) {
            request.addPostParam("EventCallbackUrl", this.eventCallbackUrl.toString());
        }
        if (this.eventsFilter != null) {
            request.addPostParam("EventsFilter", this.eventsFilter);
        }
        if (this.multiTaskEnabled != null) {
            request.addPostParam("MultiTaskEnabled", this.multiTaskEnabled.toString());
        }
        if (this.template != null) {
            request.addPostParam("Template", this.template);
        }
        if (this.prioritizeQueueOrder != null) {
            request.addPostParam("PrioritizeQueueOrder", this.prioritizeQueueOrder.toString());
        }
    }
}

