/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.syncmap;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.syncmap.SyncMapPermission;

public class SyncMapPermissionDeleter
extends Deleter<SyncMapPermission> {
    private String pathServiceSid;
    private String pathMapSid;
    private String pathIdentity;

    public SyncMapPermissionDeleter(String pathServiceSid, String pathMapSid, String pathIdentity) {
        this.pathServiceSid = pathServiceSid;
        this.pathMapSid = pathMapSid;
        this.pathIdentity = pathIdentity;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Maps/{MapSid}/Permissions/{Identity}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{MapSid}", this.pathMapSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        Request request = new Request(HttpMethod.DELETE, Domains.SYNC.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMapPermission delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }
}

