/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.document;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.document.DocumentPermission;

public class DocumentPermissionReader
extends Reader<DocumentPermission> {
    private String pathServiceSid;
    private String pathDocumentSid;
    private Integer pageSize;

    public DocumentPermissionReader(String pathServiceSid, String pathDocumentSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathDocumentSid = pathDocumentSid;
    }

    public DocumentPermissionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<DocumentPermission> read(TwilioRestClient client) {
        return new ResourceSet<DocumentPermission>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DocumentPermission> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Documents/{DocumentSid}/Permissions";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{DocumentSid}", this.pathDocumentSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SYNC.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<DocumentPermission> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DocumentPermission read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("permissions", response.getContent(), DocumentPermission.class, client.getObjectMapper());
    }

    @Override
    public Page<DocumentPermission> previousPage(Page<DocumentPermission> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DocumentPermission> nextPage(Page<DocumentPermission> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DocumentPermission> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

